/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.streamflyer.xml;

import com.googlecode.streamflyer.core.AfterModification;
import com.googlecode.streamflyer.core.Modifier;
import com.googlecode.streamflyer.internal.thirdparty.ZzzValidate;
import com.googlecode.streamflyer.util.ModificationFactory;
import com.googlecode.streamflyer.xml.XmlPrologRidiculouslyLongException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class XmlVersionModifier
implements Modifier {
    public final int INITIAL_NUMBER_OF_CHARACTERS = 4096;
    protected ModificationFactory factory;
    protected String xmlVersion;
    private XmlVersionModifierState state = XmlVersionModifierState.INITIAL;

    public XmlVersionModifier(String xmlVersion, int newNumberOfChars) {
        ZzzValidate.notNull(xmlVersion, "xmlVersion must not be null");
        this.factory = new ModificationFactory(0, newNumberOfChars);
        this.xmlVersion = xmlVersion;
    }

    @Override
    public AfterModification modify(StringBuilder characterBuffer, int firstModifiableCharacterInBuffer, boolean endOfStreamHit) {
        switch (this.state) {
            case NO_LONGER_MODIFYING: {
                return this.factory.skipEntireBuffer(characterBuffer, firstModifiableCharacterInBuffer, endOfStreamHit);
            }
            case INITIAL: {
                this.state = XmlVersionModifierState.PROLOG_REQUEST;
                return this.factory.modifyAgainImmediately(4096, firstModifiableCharacterInBuffer);
            }
            case PROLOG_REQUEST: {
                Matcher matcher = Pattern.compile("<\\?xml[^>]*version\\s*=\\s*['\"]((1.0)|(1.1))['\"].*").matcher(characterBuffer);
                if (matcher.matches()) {
                    characterBuffer.replace(matcher.start(1), matcher.end(1), this.xmlVersion);
                } else {
                    Matcher matcher2 = Pattern.compile("<\\?xml.*").matcher(characterBuffer);
                    if (matcher2.matches()) {
                        throw new XmlPrologRidiculouslyLongException(characterBuffer.toString());
                    }
                    characterBuffer.insert(0, "<?xml version='" + this.xmlVersion + "'>");
                }
                this.state = XmlVersionModifierState.NO_LONGER_MODIFYING;
                return this.factory.skipEntireBuffer(characterBuffer, firstModifiableCharacterInBuffer, endOfStreamHit);
            }
        }
        throw new IllegalStateException("state " + (Object)((Object)this.state) + " not supported");
    }

    private static enum XmlVersionModifierState {
        INITIAL,
        PROLOG_REQUEST,
        NO_LONGER_MODIFYING;

    }
}

