/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.furnace.impl.addons;

import java.util.Set;
import java.util.concurrent.Future;
import org.jboss.forge.furnace.addons.Addon;
import org.jboss.forge.furnace.addons.AddonDependency;
import org.jboss.forge.furnace.addons.AddonId;
import org.jboss.forge.furnace.addons.AddonStatus;
import org.jboss.forge.furnace.event.EventManager;
import org.jboss.forge.furnace.impl.addons.AddonStateManager;
import org.jboss.forge.furnace.impl.util.ExceptionFuture;
import org.jboss.forge.furnace.impl.util.NullFuture;
import org.jboss.forge.furnace.repositories.AddonRepository;
import org.jboss.forge.furnace.spi.ServiceRegistry;
import org.jboss.forge.furnace.util.Assert;

public class AddonImpl
implements Addon {
    private final AddonId id;
    private AddonStateManager manager;

    public AddonImpl(AddonStateManager manager, AddonId id) {
        Assert.notNull((Object)manager, (String)"Manager must not be null.");
        Assert.notNull((Object)id, (String)"AddonId must not be null.");
        this.id = id;
        this.manager = manager;
        this.manager.initialize(this);
    }

    public AddonId getId() {
        return this.id;
    }

    public Set<AddonDependency> getDependencies() {
        return this.manager.getDependenciesOf(this);
    }

    public ClassLoader getClassLoader() {
        return this.manager.getClassLoaderOf(this);
    }

    public EventManager getEventManager() {
        return this.manager.getEventManagerOf(this);
    }

    public Future<Void> getFuture() {
        return this.manager.getFutureOf(this);
    }

    public AddonRepository getRepository() {
        return this.manager.getRepositoryOf(this);
    }

    public ServiceRegistry getServiceRegistry() {
        return this.manager.getServiceRegistryOf(this);
    }

    public AddonStatus getStatus() {
        AddonStatus result = AddonStatus.MISSING;
        if (this.getClassLoader() != null) {
            result = AddonStatus.LOADED;
        }
        if (this.getFuture() != null && !(this.getFuture() instanceof NullFuture)) {
            if (this.getFuture().isDone()) {
                result = AddonStatus.STARTED;
            }
            if (this.getFuture() instanceof ExceptionFuture || this.getFuture().isCancelled()) {
                result = AddonStatus.FAILED;
            }
        }
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getId().toCoordinates() + " +" + this.getStatus());
        if (this.getFuture() == null) {
            builder.append(" READY");
        }
        builder.append(" HC: ").append(this.hashCode());
        return builder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AddonImpl other = (AddonImpl)obj;
        return !(this.id == null ? other.id != null : !this.id.equals((Object)other.id));
    }
}

