/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.scan.operation;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantClass;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.EmptyVisitor;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Visitor;
import org.apache.bcel.generic.Type;
import org.apache.commons.lang.StringUtils;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.operation.ruleelement.AbstractIterationOperation;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.reporting.service.ClassificationService;
import org.jboss.windup.rules.apps.java.model.JavaClassFileModel;
import org.jboss.windup.rules.apps.java.model.JavaClassModel;
import org.jboss.windup.rules.apps.java.service.JavaClassService;
import org.jboss.windup.rules.apps.java.service.WindupJavaConfigurationService;
import org.jboss.windup.util.ExecutionStatistics;
import org.ocpsoft.rewrite.config.OperationBuilder;
import org.ocpsoft.rewrite.context.EvaluationContext;

public class AddClassFileMetadata
extends AbstractIterationOperation<JavaClassFileModel> {
    private static Logger LOG = Logger.getLogger(AddClassFileMetadata.class.getSimpleName());

    private AddClassFileMetadata(String variableName) {
        super(variableName);
    }

    public AddClassFileMetadata() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void perform(GraphRewrite event, EvaluationContext context, JavaClassFileModel payload) {
        ExecutionStatistics.get().begin("AddClassFileMetadata.perform()");
        try {
            WindupJavaConfigurationService javaCfgService = new WindupJavaConfigurationService(event.getGraphContext());
            try (FileInputStream fis = new FileInputStream(payload.getFilePath());){
                String superclassName;
                ClassParser parser = new ClassParser((InputStream)fis, payload.getFilePath());
                final JavaClass bcelJavaClass = parser.parse();
                String packageName = bcelJavaClass.getPackageName();
                String qualifiedName = bcelJavaClass.getClassName();
                int majorVersion = bcelJavaClass.getMajor();
                int minorVersion = bcelJavaClass.getMinor();
                String simpleName = qualifiedName;
                if (packageName != null && !packageName.equals("") && simpleName != null) {
                    simpleName = simpleName.substring(packageName.length() + 1);
                }
                payload.setMajorVersion(majorVersion);
                payload.setMinorVersion(minorVersion);
                payload.setPackageName(packageName);
                final JavaClassService javaClassService = new JavaClassService(event.getGraphContext());
                final JavaClassModel javaClassModel = javaClassService.getOrCreate(qualifiedName);
                javaClassModel.setSimpleName(simpleName);
                javaClassModel.setPackageName(packageName);
                javaClassModel.setQualifiedName(qualifiedName);
                javaClassModel.setClassFile(payload);
                String[] interfaceNames = bcelJavaClass.getInterfaceNames();
                if (interfaceNames != null) {
                    for (String iface : interfaceNames) {
                        JavaClassModel interfaceModel = javaClassService.getOrCreate(iface);
                        javaClassModel.addImplements(interfaceModel);
                    }
                }
                if (!StringUtils.isBlank((String)(superclassName = bcelJavaClass.getSuperclassName()))) {
                    javaClassModel.setExtends(javaClassService.getOrCreate(superclassName));
                }
                if (javaCfgService.shouldScanPackage(packageName)) {
                    Constant[] pool;
                    for (Method method : bcelJavaClass.getMethods()) {
                        javaClassService.addJavaMethod(javaClassModel, method.getName(), this.toJavaClasses(javaClassService, method.getArgumentTypes()));
                    }
                    for (Constant c : pool = bcelJavaClass.getConstantPool().getConstantPool()) {
                        if (c == null) continue;
                        c.accept((Visitor)new EmptyVisitor(){

                            public void visitConstantClass(ConstantClass obj) {
                                ConstantPool pool = bcelJavaClass.getConstantPool();
                                String classVal = obj.getConstantValue(pool).toString();
                                if (StringUtils.equals((String)(classVal = StringUtils.replace((String)classVal, (String)"/", (String)".")), (String)bcelJavaClass.getClassName())) {
                                    return;
                                }
                                JavaClassModel clz = javaClassService.getOrCreate(classVal);
                                javaClassModel.addImport(clz);
                            }
                        });
                    }
                }
                payload.setJavaClass(javaClassModel);
            }
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "BCEL was unable to parse class file: " + payload.getFilePath() + " due to: " + e.getMessage(), e);
            ClassificationService classificationService = new ClassificationService(event.getGraphContext());
            classificationService.attachClassification((FileModel)payload, "Unparseable Class File", "This Class file could not be parsed");
        }
        finally {
            ExecutionStatistics.get().end("AddClassFileMetadata.perform()");
        }
    }

    private JavaClassModel[] toJavaClasses(JavaClassService javaClassService, Type[] types) {
        JavaClassModel[] clz = new JavaClassModel[types.length];
        for (Type t : types) {
            clz[i] = javaClassService.getOrCreate(t.toString());
        }
        return clz;
    }

    public static OperationBuilder to(String var) {
        return new AddClassFileMetadata(var);
    }
}

