/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.scan.provider;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.codec.digest.DigestUtils;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.IteratingRuleProvider;
import org.jboss.windup.config.phase.ArchiveMetadataExtraction;
import org.jboss.windup.config.phase.RulePhase;
import org.jboss.windup.config.query.Query;
import org.jboss.windup.graph.model.ArchiveModel;
import org.jboss.windup.util.exception.WindupException;
import org.ocpsoft.rewrite.config.ConditionBuilder;
import org.ocpsoft.rewrite.context.EvaluationContext;

public class AnalyzeArchivesChecksumRuleProvider
extends IteratingRuleProvider<ArchiveModel> {
    public ConditionBuilder when() {
        return Query.fromType(ArchiveModel.class);
    }

    public Class<? extends RulePhase> getPhase() {
        return ArchiveMetadataExtraction.class;
    }

    public String toStringPerform() {
        return "AttachChecksumsToArchives";
    }

    public void perform(GraphRewrite event, EvaluationContext context, ArchiveModel payload) {
        Throwable throwable;
        InputStream is;
        try {
            is = payload.asInputStream();
            throwable = null;
            try {
                String md5 = DigestUtils.md5Hex((InputStream)is);
                payload.setMD5Hash(md5);
            }
            catch (Throwable md5) {
                throwable = md5;
                throw md5;
            }
            finally {
                if (is != null) {
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable md5) {
                            throwable.addSuppressed(md5);
                        }
                    } else {
                        is.close();
                    }
                }
            }
        }
        catch (IOException e) {
            throw new WindupException("Failed to read archive file at: " + payload.getFilePath() + " due to: " + e.getMessage(), (Throwable)e);
        }
        try {
            is = payload.asInputStream();
            throwable = null;
            try {
                String sha1 = DigestUtils.sha1Hex((InputStream)is);
                payload.setSHA1Hash(sha1);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (is != null) {
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        is.close();
                    }
                }
            }
        }
        catch (IOException e) {
            throw new WindupException("Failed to read archive file at: " + payload.getFilePath() + " due to: " + e.getMessage(), (Throwable)e);
        }
    }
}

