/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.rexster.config;

import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.blueprints.impls.sail.SailGraph;
import com.tinkerpop.blueprints.impls.sail.impls.LinkedDataSailGraph;
import com.tinkerpop.blueprints.impls.sail.impls.MemoryStoreSailGraph;
import com.tinkerpop.blueprints.impls.sail.impls.NativeStoreSailGraph;
import com.tinkerpop.blueprints.impls.sail.impls.SparqlRepositorySailGraph;
import com.tinkerpop.rexster.RexsterApplicationGraph;
import com.tinkerpop.rexster.config.GraphConfiguration;
import com.tinkerpop.rexster.config.GraphConfigurationContext;
import com.tinkerpop.rexster.config.GraphConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.SubnodeConfiguration;
import org.apache.log4j.Logger;

public abstract class AbstractSailGraphConfiguration
implements GraphConfiguration {
    private static final Logger logger = Logger.getLogger(AbstractSailGraphConfiguration.class);
    public static final String SAIL_TYPE_MEMORY = "memory";
    public static final String SAIL_TYPE_LINKED_DATA = "linked-data";
    public static final String SAIL_TYPE_NATIVE = "native";
    public static final String SAIL_TYPE_SPARQL = "sparql";
    protected String sailType;

    public Graph configureGraphInstance(GraphConfigurationContext context) throws GraphConfigurationException {
        String graphFile = context.getProperties().getString("graph-location", null);
        HierarchicalConfiguration graphSectionConfig = (HierarchicalConfiguration)context.getProperties();
        SubnodeConfiguration sailSpecificConfiguration = null;
        try {
            sailSpecificConfiguration = graphSectionConfig.configurationAt("properties");
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        if ((this.sailType.equals(SAIL_TYPE_NATIVE) || this.sailType.equals(SAIL_TYPE_SPARQL) || this.sailType.equals(SAIL_TYPE_LINKED_DATA)) && (graphFile == null || graphFile.trim().length() == 0)) {
            throw new GraphConfigurationException("Check graph configuration. Missing or empty configuration element: graph-location");
        }
        try {
            MemoryStoreSailGraph graph = null;
            if (this.sailType.equals(SAIL_TYPE_MEMORY)) {
                if (graphFile != null && !graphFile.isEmpty()) {
                    logger.warn((Object)("[" + MemoryStoreSailGraph.class.getSimpleName() + "] doesn't support the graph-file parameter.  It will be ignored."));
                }
                graph = new MemoryStoreSailGraph();
            } else if (this.sailType.equals(SAIL_TYPE_LINKED_DATA)) {
                RexsterApplicationGraph baseGraph = (RexsterApplicationGraph)context.getGraphs().get(graphFile);
                if (null == baseGraph) {
                    throw new GraphConfigurationException("no such base graph for LinkedDataSail graph: " + graphFile);
                }
                if (!(baseGraph.getGraph() instanceof SailGraph)) {
                    throw new GraphConfigurationException("base graph for LinkedDataSail graph must be an instance of SailGraph");
                }
                if (baseGraph.getGraph() instanceof LinkedDataSailGraph) {
                    throw new GraphConfigurationException("LinkedDataSail graph based on another LinkedDataSail graph");
                }
                graph = new LinkedDataSailGraph((SailGraph)baseGraph.getGraph());
            } else if (this.sailType.equals(SAIL_TYPE_NATIVE)) {
                String configTripleIndices = "";
                if (sailSpecificConfiguration != null) {
                    configTripleIndices = sailSpecificConfiguration.getString("triple-indices", "");
                }
                graph = configTripleIndices != null && configTripleIndices.trim().length() > 0 ? new NativeStoreSailGraph(graphFile, configTripleIndices) : new NativeStoreSailGraph(graphFile);
            } else if (this.sailType.equals(SAIL_TYPE_SPARQL)) {
                graph = new SparqlRepositorySailGraph(graphFile);
            }
            return graph;
        }
        catch (Exception ex) {
            throw new GraphConfigurationException((Throwable)ex);
        }
    }
}

