/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.archives;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Logger;
import org.apache.commons.collections4.list.TreeList;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.util.Bits;
import org.apache.maven.index.ArtifactInfo;
import org.apache.maven.index.Indexer;
import org.apache.maven.index.context.IndexCreator;
import org.apache.maven.index.context.IndexUtils;
import org.apache.maven.index.context.IndexingContext;
import org.apache.maven.index.updater.IndexUpdateRequest;
import org.apache.maven.index.updater.IndexUpdateResult;
import org.apache.maven.index.updater.IndexUpdater;
import org.apache.maven.index.updater.ResourceFetcher;
import org.apache.maven.index.updater.WagonHelper;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.events.TransferListener;
import org.codehaus.plexus.ContainerConfiguration;
import org.codehaus.plexus.DefaultContainerConfiguration;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.PlexusContainerException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.jboss.forge.addon.dependencies.DependencyRepository;
import org.jboss.windup.rules.apps.java.archives.LoggingTransferListener;

public class RepositoryIndexManager
implements AutoCloseable {
    private static final Logger log = Logger.getLogger(RepositoryIndexManager.class.getName());
    private File indexDirectory;
    private final PlexusContainer plexusContainer;
    private final Indexer indexer;
    private final IndexUpdater indexUpdater;
    private final Wagon httpWagon;
    private final IndexingContext context;
    private final File localCache;
    private final File indexDir;

    public static void generateMetadata(DependencyRepository repository, File outputDir) throws Exception {
        try (RepositoryIndexManager manager = new RepositoryIndexManager(outputDir, repository);){
            File metadataFile = RepositoryIndexManager.getMetadataFile(repository, outputDir);
            try (FileWriter out = new FileWriter(metadataFile);){
                log.info("Downloading or updating index into " + outputDir.getPath());
                manager.downloadIndexAndUpdate();
                log.info("Writing sorted metadata to " + metadataFile.getPath());
                manager.writeMetadataTo(out);
            }
        }
    }

    public static boolean metadataExists(DependencyRepository repository, File outputDir) {
        return RepositoryIndexManager.getMetadataFile(repository, outputDir).exists();
    }

    public static File getMetadataFile(DependencyRepository repository, File outputDir) {
        return new File(outputDir, repository.getId() + ".archive-metadata" + ".txt");
    }

    private RepositoryIndexManager(File indexDirectory, DependencyRepository repository) throws PlexusContainerException, ComponentLookupException, IOException {
        this.indexDirectory = indexDirectory;
        DefaultContainerConfiguration config = new DefaultContainerConfiguration();
        config.setClassPathScanning("index");
        this.plexusContainer = new DefaultPlexusContainer((ContainerConfiguration)config);
        this.indexer = (Indexer)this.plexusContainer.lookup(Indexer.class);
        this.indexUpdater = (IndexUpdater)this.plexusContainer.lookup(IndexUpdater.class);
        this.httpWagon = (Wagon)this.plexusContainer.lookup(Wagon.class, "http");
        this.localCache = new File(this.indexDirectory, repository.getId() + "-cache");
        this.indexDir = new File(this.indexDirectory, repository.getId() + "-index");
        ArrayList<Object> indexers = new ArrayList<Object>();
        indexers.add(this.plexusContainer.lookup(IndexCreator.class, "min"));
        this.context = this.indexer.createIndexingContext(repository.getId() + "Context", repository.getId(), this.localCache, this.indexDir, repository.getUrl(), null, true, false, indexers);
    }

    private void downloadIndexAndUpdate() throws IOException {
        WagonHelper.WagonFetcher resourceFetcher = new WagonHelper.WagonFetcher(this.httpWagon, (TransferListener)new LoggingTransferListener(log), null, null);
        IndexUpdateRequest updateRequest = new IndexUpdateRequest(this.context, (ResourceFetcher)resourceFetcher);
        updateRequest.setIncrementalOnly(false);
        updateRequest.setForceFullUpdate(false);
        IndexUpdateResult updateResult = this.indexUpdater.fetchAndUpdateIndex(updateRequest);
        if (updateResult.isFullUpdate()) {
            log.info("Fully updated index for repository [" + this.context.getId() + "] - [" + this.context.getRepositoryUrl() + "]");
        } else {
            log.info("Incrementally updated index for repository [" + this.context.getId() + "] - [" + this.context.getRepositoryUrl() + "]");
        }
    }

    private void writeMetadataTo(FileWriter writer) throws IOException {
        IndexSearcher searcher = this.context.acquireIndexSearcher();
        IndexReader reader = searcher.getIndexReader();
        Bits liveDocs = MultiFields.getLiveDocs((IndexReader)reader);
        TreeList lines = new TreeList();
        for (int i = 0; i < reader.maxDoc(); ++i) {
            Document doc;
            ArtifactInfo info;
            if (liveDocs != null && !liveDocs.get(i) || (info = IndexUtils.constructArtifactInfo((Document)(doc = reader.document(i)), (IndexingContext)this.context)) == null || info.getSha1() == null || info.getSha1().length() != 40 || "javadoc".equals(info.getClassifier()) || "sources".equals(info.getClassifier())) continue;
            StringBuilder line = new StringBuilder();
            line.append(StringUtils.lowerCase((String)info.getSha1())).append(' ');
            line.append(info.getGroupId()).append(":");
            line.append(info.getArtifactId()).append(":");
            line.append(info.getVersion()).append(":");
            line.append(StringUtils.defaultString((String)info.getClassifier()));
            line.append(System.lineSeparator());
            lines.add(line.toString());
        }
        Collections.sort(lines);
        for (String line : lines) {
            writer.append(line);
        }
    }

    @Override
    public void close() throws IOException {
        this.context.close(true);
        this.indexer.closeIndexingContext(this.context, false);
    }
}

