/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.scan.operation.packagemapping;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Pattern;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.GraphRule;
import org.jboss.windup.config.PreRulesetEvaluation;
import org.jboss.windup.rules.apps.java.scan.operation.packagemapping.PackageNameMappingWithPackagePattern;
import org.ocpsoft.rewrite.config.Rule;
import org.ocpsoft.rewrite.context.EvaluationContext;

public class PackageNameMapping
extends GraphRule
implements PackageNameMappingWithPackagePattern,
PreRulesetEvaluation {
    private String organization;
    private String packagePattern;

    public static String getOrganizationForPackage(GraphRewrite event, String pkg) {
        String organization = null;
        for (Map.Entry<Pattern, String> entry : PackageNameMapping.getMappings(event).entrySet()) {
            Pattern packagePattern = entry.getKey();
            if (!packagePattern.matcher(pkg).find()) continue;
            organization = entry.getValue();
            break;
        }
        return organization;
    }

    public static PackageNameMappingWithPackagePattern fromPackage(String packagePattern) {
        PackageNameMapping packageNameMapping = new PackageNameMapping();
        packageNameMapping.setPackagePattern(packagePattern);
        return packageNameMapping;
    }

    @Override
    public Rule toOrganization(String organization) {
        this.setOrganization(organization);
        return this;
    }

    public void preRulesetEvaluation(GraphRewrite event) {
        Pattern pattern = !this.packagePattern.startsWith("^") ? Pattern.compile("^" + this.packagePattern) : Pattern.compile(this.packagePattern);
        PackageNameMapping.getMappings(event).put(pattern, this.organization);
    }

    private static Map<Pattern, String> getMappings(GraphRewrite event) {
        HashMap map = (HashMap)event.getRewriteContext().get(PackageNameMapping.class);
        if (map == null) {
            map = new HashMap();
            event.getRewriteContext().put(PackageNameMapping.class, map);
        }
        return map;
    }

    public boolean evaluate(GraphRewrite event, EvaluationContext context) {
        return true;
    }

    public void perform(GraphRewrite event, EvaluationContext context) {
    }

    public String getOrganization() {
        return this.organization;
    }

    public void setOrganization(String organization) {
        this.organization = organization;
    }

    public String getPackagePattern() {
        return this.packagePattern;
    }

    public void setPackagePattern(String packagePattern) {
        this.packagePattern = packagePattern;
    }

    public String getId() {
        return this.getClass().getName() + "_" + UUID.randomUUID().toString();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getName());
        builder.append(".fromPackage(" + this.packagePattern + ")");
        builder.append(".toOrganization(" + this.organization + ")");
        return builder.toString();
    }
}

