/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.util;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.logging.Logger;

public class WindupPathUtil {
    private static final Logger log = Logger.getLogger(WindupPathUtil.class.getName());

    public static Path getWindupUserDir() {
        String userHome = System.getProperty("user.home");
        if (userHome == null) {
            Path path = new File("").toPath();
            log.warning("$USER_HOME not set, using [" + path + "] instead.");
            return path;
        }
        return Paths.get(userHome, new String[0]).resolve(".windup");
    }

    public static Path getWindupHome() {
        String windupHome = System.getProperty("windup.home");
        if (windupHome == null) {
            Path path = new File("").toPath();
            log.warning("$WINDUP_HOME not set, using [" + path + "] instead.");
            return path;
        }
        return Paths.get(windupHome, new String[0]);
    }

    public static Path getUserCacheDir() {
        return WindupPathUtil.getUserSubdirectory("cache");
    }

    public static Path getWindupCacheDir() {
        return WindupPathUtil.getWindupSubdirectory("cache");
    }

    public static Path getUserIgnoreDir() {
        return WindupPathUtil.getUserSubdirectory("ignore");
    }

    public static Path getWindupIgnoreDir() {
        return WindupPathUtil.getWindupSubdirectory("ignore");
    }

    public static Path getUserRulesDir() {
        return WindupPathUtil.getUserSubdirectory("rules");
    }

    public static Path getWindupRulesDir() {
        return WindupPathUtil.getWindupSubdirectory("rules");
    }

    public static String cleanFileName(String badFileName) {
        if (badFileName == null) {
            return null;
        }
        StringBuilder cleanName = new StringBuilder();
        for (int i = 0; i < badFileName.length(); ++i) {
            char c = badFileName.charAt(i);
            if (Character.isJavaIdentifierPart((int)c)) {
                cleanName.append(c);
                continue;
            }
            cleanName.append('_');
        }
        return cleanName.toString();
    }

    public static String classFilePathToClassname(String classFilePath) {
        if (classFilePath == null) {
            return null;
        }
        int pos = classFilePath.lastIndexOf(".class");
        if (pos < 0) {
            throw new IllegalArgumentException("Not a .class file path: " + classFilePath);
        }
        return classFilePath.substring(0, pos).replace('/', '.').replace('\\', '.');
    }

    private static Path getUserSubdirectory(String subdirectory) {
        Path windupUserDir = WindupPathUtil.getWindupUserDir();
        if (windupUserDir == null) {
            return null;
        }
        return windupUserDir.resolve(subdirectory);
    }

    private static Path getWindupSubdirectory(String subdirectory) {
        Path windupHome = WindupPathUtil.getWindupHome();
        if (windupHome == null) {
            return null;
        }
        return windupHome.resolve(subdirectory);
    }
}

