/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.streamflyer.util.statistics;

import com.googlecode.streamflyer.core.AfterModification;
import com.googlecode.streamflyer.util.ModificationFactory;
import com.googlecode.streamflyer.util.statistics.ModificationFactoryDecorator;

public class LineColumnAwareModificationFactory
extends ModificationFactoryDecorator {
    protected long currentLine = 0L;
    protected long currentColumn = 0L;
    protected char lastChar = (char)32;

    public LineColumnAwareModificationFactory(ModificationFactory delegate) {
        super(delegate);
    }

    @Override
    public AfterModification fetchMoreInput(int numberOfCharactersToSkip, StringBuilder characterBuffer, int firstModifiableCharacterInBuffer, boolean endOfStreamHit) {
        AfterModification afterModification = super.fetchMoreInput(numberOfCharactersToSkip, characterBuffer, firstModifiableCharacterInBuffer, endOfStreamHit);
        this.onCharactersSkipped(afterModification.getNumberOfCharactersToSkip(), characterBuffer, firstModifiableCharacterInBuffer);
        return afterModification;
    }

    @Override
    public AfterModification modifyAgainImmediately(int newNumberOfChars, int firstModifiableCharacterInBuffer) {
        AfterModification afterModification = super.modifyAgainImmediately(newNumberOfChars, firstModifiableCharacterInBuffer);
        return afterModification;
    }

    @Override
    public AfterModification skip(int numberOfCharactersToSkip, StringBuilder characterBuffer, int firstModifiableCharacterInBuffer, boolean endOfStreamHit) {
        AfterModification afterModification = super.skip(numberOfCharactersToSkip, characterBuffer, firstModifiableCharacterInBuffer, endOfStreamHit);
        this.onCharactersSkipped(afterModification.getNumberOfCharactersToSkip(), characterBuffer, firstModifiableCharacterInBuffer);
        return afterModification;
    }

    @Override
    public AfterModification skipEntireBuffer(StringBuilder characterBuffer, int firstModifiableCharacterInBuffer, boolean endOfStreamHit) {
        AfterModification afterModification = super.skipEntireBuffer(characterBuffer, firstModifiableCharacterInBuffer, endOfStreamHit);
        this.onCharactersSkipped(afterModification.getNumberOfCharactersToSkip(), characterBuffer, firstModifiableCharacterInBuffer);
        return afterModification;
    }

    @Override
    public AfterModification skipOrStop(int numberOfCharactersToSkip, StringBuilder characterBuffer, int firstModifiableCharacterInBuffer, boolean endOfStreamHit) {
        AfterModification afterModification = super.skipOrStop(numberOfCharactersToSkip, characterBuffer, firstModifiableCharacterInBuffer, endOfStreamHit);
        this.onCharactersSkipped(afterModification.getNumberOfCharactersToSkip(), characterBuffer, firstModifiableCharacterInBuffer);
        return afterModification;
    }

    @Override
    public AfterModification stop(StringBuilder characterBuffer, int firstModifiableCharacterInBuffer, boolean endOfStreamHit) {
        AfterModification afterModification = super.stop(characterBuffer, firstModifiableCharacterInBuffer, endOfStreamHit);
        this.onCharactersSkipped(afterModification.getNumberOfCharactersToSkip(), characterBuffer, firstModifiableCharacterInBuffer);
        return afterModification;
    }

    protected void onCharactersSkipped(int numberOfCharactersToSkip, StringBuilder characterBuffer, int firstModifiableCharacterInBuffer) {
        int end = firstModifiableCharacterInBuffer + numberOfCharactersToSkip;
        for (int index = firstModifiableCharacterInBuffer; index < end; ++index) {
            this.onCharacterSkipped(characterBuffer.charAt(index));
        }
    }

    protected void onCharacterSkipped(char ch) {
        if (ch == '\r') {
            ++this.currentLine;
            this.currentColumn = 0L;
        } else if (ch == '\n') {
            if (this.lastChar != '\r') {
                ++this.currentLine;
                this.currentColumn = 0L;
            }
        } else {
            ++this.currentColumn;
        }
        this.lastChar = ch;
    }

    public long getCurrentColumn() {
        return this.currentColumn;
    }

    public long getCurrentLine() {
        return this.currentLine;
    }
}

