/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.bootstrap;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import org.jboss.forge.furnace.ContainerStatus;
import org.jboss.forge.furnace.Furnace;
import org.jboss.forge.furnace.impl.addons.AddonRepositoryImpl;
import org.jboss.forge.furnace.repositories.AddonRepository;
import org.jboss.forge.furnace.repositories.AddonRepositoryMode;
import org.jboss.forge.furnace.repositories.MutableAddonRepository;
import org.jboss.forge.furnace.se.FurnaceFactory;
import org.jboss.forge.furnace.spi.ContainerLifecycleListener;
import org.jboss.forge.furnace.util.OperatingSystemUtils;
import org.jboss.forge.furnace.util.Strings;
import org.jboss.forge.furnace.versions.EmptyVersion;
import org.jboss.forge.furnace.versions.SingleVersion;
import org.jboss.forge.furnace.versions.Version;
import org.jboss.windup.bootstrap.BootstrapFurnaceService;
import org.jboss.windup.bootstrap.listener.GreetingListener;
import org.jboss.windup.config.WindupConfigurationOption;
import org.jboss.windup.exec.configuration.WindupConfiguration;

public class Bootstrap {
    private BootstrapFurnaceService furnaceService = null;
    private boolean exitAfter = false;
    private boolean batchMode = false;

    public static void main(String[] args) throws InterruptedException, ExecutionException {
        ArrayList<String> bootstrapArgs = new ArrayList<String>();
        Properties systemProperties = System.getProperties();
        for (String arg : args) {
            if (arg.startsWith("-D")) {
                String value;
                String name;
                int index = arg.indexOf("=");
                if (index == -1) {
                    name = arg.substring(2);
                    value = "true";
                } else {
                    name = arg.substring(2, index);
                    value = arg.substring(index + 1);
                }
                systemProperties.setProperty(name, value);
                continue;
            }
            bootstrapArgs.add(arg);
        }
        File rulesDir = new File(Bootstrap.getUserWindupDir(), "rules");
        if (!rulesDir.exists()) {
            rulesDir.mkdirs();
        }
        String defaultLog = new File(Bootstrap.getUserWindupDir(), "log/windup.log").getAbsolutePath();
        String logDir = systemProperties.getProperty("org.jboss.forge.log.file", defaultLog);
        systemProperties.setProperty("org.jboss.forge.log.file", logDir);
        String logManagerName = Bootstrap.getServiceName(Bootstrap.class.getClassLoader(), "java.util.logging.LogManager");
        if (logManagerName != null) {
            systemProperties.setProperty("java.util.logging.manager", logManagerName);
        }
        Bootstrap bootstrap = new Bootstrap(bootstrapArgs.toArray(new String[bootstrapArgs.size()]));
        bootstrap.start();
    }

    private String[] processArguments(String[] args, BootstrapFurnaceService furnaceService) {
        Furnace furnace = furnaceService.getFurnace();
        System.setProperty("forge.standalone", "false");
        boolean displayHelp = false;
        List<String> listArgs = Arrays.asList(args);
        if (listArgs.contains("-help") || listArgs.contains("--help") || listArgs.contains("-h") || listArgs.contains("/?") || listArgs.contains("/help")) {
            displayHelp = true;
            this.exitAfter = true;
        }
        boolean listInstalled = false;
        String installAddon = null;
        String removeAddon = null;
        boolean isEvaluate = false;
        ArrayList<String> unknownArgs = new ArrayList<String>();
        ArrayList<File> mutableRepos = new ArrayList<File>();
        ArrayList<File> immutableRepos = new ArrayList<File>();
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if ("--install".equals(arg) || "-i".equals(arg)) {
                installAddon = args[++i];
                continue;
            }
            if ("--remove".equals(arg) || "-r".equals(arg)) {
                removeAddon = args[++i];
                continue;
            }
            if ("--list".equals(arg) || "-l".equals(arg)) {
                listInstalled = true;
                continue;
            }
            if ("--addonDir".equals(arg) || "-a".equals(arg)) {
                mutableRepos.add(new File(args[++i]));
                continue;
            }
            if ("--immutableAddonDir".equals(arg) || "-m".equals(arg)) {
                immutableRepos.add(new File(args[++i]));
                continue;
            }
            if ("--batchMode".equals(arg) || "-b".equals(arg)) {
                this.batchMode = true;
                continue;
            }
            if ("--evaluate".equals(arg) || "-e".equals(arg)) {
                isEvaluate = true;
                ++i;
                continue;
            }
            if ("--debug".equals(arg) || "-d".equals(arg)) continue;
            if ("--version".equals(arg) || "-v".equals(arg)) {
                System.out.println(Bootstrap.getVersionString());
                this.exitAfter = true;
                continue;
            }
            unknownArgs.add(arg);
        }
        Bootstrap.addReposToFurnace(furnace, mutableRepos, immutableRepos);
        Iterable<WindupConfigurationOption> knownWindupArgs = Bootstrap.getKnownWindupArgs(furnace);
        Bootstrap.addReposToFurnace(furnace, mutableRepos, immutableRepos);
        furnace.addContainerLifecycleListener((ContainerLifecycleListener)new GreetingListener());
        if (isEvaluate) {
            Bootstrap.setupNonInteractive(furnace);
        }
        if (this.batchMode) {
            furnace.setServerMode(false);
        }
        if (displayHelp) {
            System.out.println(Bootstrap.getHelpMessage(knownWindupArgs));
            return args;
        }
        ArrayList<String> windupArgs = new ArrayList<String>();
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (Bootstrap.isWindupArg(knownWindupArgs, arg)) {
                do {
                    unknownArgs.remove(args[i]);
                    windupArgs.add(args[i]);
                    args[i] = null;
                } while (++i < args.length && !args[i].startsWith("--"));
                --i;
                continue;
            }
            if (!unknownArgs.contains(arg)) continue;
            args[i] = null;
        }
        ArrayList<String> argsList = new ArrayList<String>(args.length + 2);
        for (String arg : args) {
            if (arg == null) continue;
            argsList.add(arg);
        }
        if (!windupArgs.isEmpty()) {
            Bootstrap.setupNonInteractive(furnace);
            windupArgs.addAll(unknownArgs);
            unknownArgs.clear();
            if (isEvaluate) {
                System.out.println("Both --evaluate (-e) and Windup options were found, may lead to unexpected behavior.");
            }
            StringBuilder sb = new StringBuilder("windup-migrate-app");
            for (String windupArg : windupArgs) {
                sb.append(" ").append(windupArg);
            }
            argsList.add("-e");
            argsList.add(sb.toString());
        } else {
            if (!unknownArgs.isEmpty()) {
                System.out.println("Windup: unrecognized options: " + Strings.join((Object[])unknownArgs.toArray(), (String)", "));
                System.out.println("Run 'windup --help' for more information.");
                this.exitAfter = true;
            }
            if (!isEvaluate) {
                System.setProperty("forge.standalone", "true");
            }
        }
        args = argsList.toArray(new String[argsList.size()]);
        if (!Bootstrap.containsMutableRepository(furnace.getRepositories())) {
            furnaceService.getFurnace().addRepository(AddonRepositoryMode.MUTABLE, new File(Bootstrap.getUserWindupDir(), "addons"));
        }
        if (listInstalled) {
            this.exitAfter = furnaceService.list();
        }
        if (removeAddon != null) {
            this.exitAfter = furnaceService.remove(removeAddon, this.exitAfter);
        }
        if (installAddon != null) {
            this.exitAfter = furnaceService.install(installAddon, this.exitAfter);
        }
        return args;
    }

    private static void addReposToFurnace(Furnace furnace, List<File> mutableRepos, List<File> immutableRepos) {
        for (File repo : mutableRepos) {
            furnace.addRepository(AddonRepositoryMode.MUTABLE, repo);
        }
        for (File repo : immutableRepos) {
            furnace.addRepository(AddonRepositoryMode.IMMUTABLE, repo);
        }
    }

    private static boolean isWindupArg(Iterable<WindupConfigurationOption> availableOptions, String arg) {
        for (WindupConfigurationOption availableOption : availableOptions) {
            if (!arg.equals("--" + availableOption.getName())) continue;
            return true;
        }
        return false;
    }

    private static void setupNonInteractive(Furnace furnace) {
        furnace.setServerMode(true);
        System.setProperty("INTERACTIVE", "false");
        System.setProperty("forge.shell.evaluate", "true");
    }

    private Bootstrap(String[] args) {
        Furnace furnace = FurnaceFactory.getInstance();
        this.furnaceService = new BootstrapFurnaceService(furnace);
        args = this.processArguments(args, this.furnaceService);
        furnace.setArgs(args);
    }

    private static String getHelpMessage(Iterable<WindupConfigurationOption> windupOptions) {
        StringBuilder sb = new StringBuilder();
        sb.append("Usage: windup [OPTION]... PARAMETER ... \n");
        sb.append("Extendable migration analysis, at your fingertips. \n");
        sb.append("\n");
        sb.append("\nWindup Options:\n");
        for (WindupConfigurationOption option : windupOptions) {
            sb.append("--").append(option.getName()).append("\n");
            sb.append("\t").append(option.getDescription()).append("\n");
        }
        sb.append("\nForge Options:\n");
        sb.append("-i, --install [[groupId:]addon[,version]]\n");
        sb.append("\t install the required addons and exit. ex: `windup -i core-addon-x` or `windup -i org.example.addon:example,1.0.0` \n");
        sb.append("-r, --remove [[groupId:]addon[,version]]\n");
        sb.append("\t remove the required addons and exit. ex: `windup -r core-addon-x` or `windup -r org.example.addon:example,1.0.0` \n");
        sb.append("-l, --list\n");
        sb.append("\t list installed addons and exit \n");
        sb.append("-a, --addonDir [dir]\n");
        sb.append("\t add the given directory for use as a custom addon repository \n");
        sb.append("-e, --evaluate [cmd]\n");
        sb.append("\t evaluate the given string as commands (requires shell addon. Install via: `windup -i shell`) \n");
        sb.append("-m, --immutableAddonDir [dir]\n");
        sb.append("\t add the given directory for use as a custom immutable addon repository (read only) \n");
        sb.append("-b, --batchMode\n");
        sb.append("\t run Forge in batch mode and does not prompt for confirmation (exits immediately after running) \n");
        sb.append("-d, --debug\n");
        sb.append("\t run Forge in debug mode (wait on port 8000 for a debugger to attach) \n");
        sb.append("-h, --help\n");
        sb.append("\t display this help and exit \n");
        sb.append("-v, --version\n");
        sb.append("\t output version information and exit \n");
        return sb.toString();
    }

    private static boolean containsMutableRepository(List<AddonRepository> repositories) {
        boolean result = false;
        for (AddonRepository repository : repositories) {
            if (!(repository instanceof MutableAddonRepository)) continue;
            result = true;
            break;
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getServiceName(ClassLoader classLoader, String className) {
        try (InputStream stream = classLoader.getResourceAsStream("META-INF/services/" + className);){
            if (stream == null) {
                String string = null;
                return string;
            }
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream));){
                String line;
                do {
                    if ((line = reader.readLine()) == null) return null;
                    int i = line.indexOf(35);
                    if (i == -1) continue;
                    line = line.substring(0, i);
                } while ((line = line.trim()).length() == 0);
                String string = line;
                return string;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public static File getUserWindupDir() {
        return new File(OperatingSystemUtils.getUserHomeDir(), ".windup").getAbsoluteFile();
    }

    public static String getVersion() {
        return Bootstrap.getRuntimeAPIVersion().toString();
    }

    public static String getVersionString() {
        return "> JBoss Windup, version " + Bootstrap.getRuntimeAPIVersion() + ". JBoss Forge, version " + AddonRepositoryImpl.getRuntimeAPIVersion();
    }

    public static Version getRuntimeAPIVersion() {
        String version = Bootstrap.class.getPackage().getImplementationVersion();
        if (version != null) {
            return new SingleVersion(version);
        }
        return EmptyVersion.getInstance();
    }

    private void start() throws InterruptedException, ExecutionException {
        this.furnaceService.start(this.exitAfter, this.batchMode);
    }

    private static void startFurnaceAsyncAndReturnWhenStarted(Furnace furnace) {
        furnace.setServerMode(true);
        furnace.startAsync();
        while (furnace.getStatus() != ContainerStatus.STARTED) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Iterable<WindupConfigurationOption> getKnownWindupArgs(Furnace furnace) {
        Bootstrap.startFurnaceAsyncAndReturnWhenStarted(furnace);
        try {
            Iterable iterable = WindupConfiguration.getWindupConfigurationOptions((Furnace)furnace);
            return iterable;
        }
        finally {
            furnace.stop();
            while (furnace.getStatus() != ContainerStatus.STOPPED || furnace.getRepositories().size() > 0) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

