/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.se.discovery;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import java.lang.annotation.Annotation;
import java.util.Set;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.weld.environment.se.discovery.WeldSEClassFileInfo;
import org.jboss.weld.environment.se.discovery.url.DiscoveryStrategy;
import org.jboss.weld.environment.se.discovery.url.JandexEnabledDiscoveryStrategy;
import org.jboss.weld.environment.se.discovery.url.WeldSEResourceLoader;
import org.jboss.weld.environment.se.logging.WeldSELogger;
import org.jboss.weld.resources.spi.ClassFileInfo;
import org.jboss.weld.resources.spi.ClassFileServices;

public class WeldSEClassFileServices
implements ClassFileServices {
    private IndexView index;
    private LoadingCache<DotName, Set<String>> annotationClassAnnotationsCache;
    private final ClassLoader classLoader;

    public WeldSEClassFileServices(DiscoveryStrategy strategy) {
        JandexEnabledDiscoveryStrategy jandexStrategy = (JandexEnabledDiscoveryStrategy)strategy;
        this.index = jandexStrategy.getCompositeJandexIndex();
        if (this.index == null) {
            throw WeldSELogger.LOG.jandexIndexNotCreated(ClassFileServices.class.getSimpleName());
        }
        this.classLoader = WeldSEResourceLoader.getClassLoader();
        this.annotationClassAnnotationsCache = CacheBuilder.newBuilder().build((CacheLoader)new AnnotationClassAnnotationLoader());
    }

    public ClassFileInfo getClassFileInfo(String className) {
        return new WeldSEClassFileInfo(className, this.index, this.annotationClassAnnotationsCache, this.classLoader);
    }

    public void cleanupAfterBoot() {
        if (this.annotationClassAnnotationsCache != null) {
            this.annotationClassAnnotationsCache.invalidateAll();
            this.annotationClassAnnotationsCache = null;
        }
        this.index = null;
    }

    public void cleanup() {
        this.cleanupAfterBoot();
    }

    private class AnnotationClassAnnotationLoader
    extends CacheLoader<DotName, Set<String>> {
        private AnnotationClassAnnotationLoader() {
        }

        public Set<String> load(DotName name) throws Exception {
            ClassInfo annotationClassInfo = WeldSEClassFileServices.this.index.getClassByName(name);
            ImmutableSet.Builder builder = ImmutableSet.builder();
            if (annotationClassInfo != null) {
                for (DotName annotationName : annotationClassInfo.annotations().keySet()) {
                    builder.add((Object)annotationName.toString());
                }
            } else {
                try {
                    Class<?> annotationClass = WeldSEClassFileServices.this.classLoader.loadClass(name.toString());
                    for (Annotation annotation : annotationClass.getDeclaredAnnotations()) {
                        builder.add((Object)annotation.annotationType().getName());
                    }
                }
                catch (ClassNotFoundException e) {
                    throw WeldSELogger.LOG.unableToLoadAnnotation(name.toString());
                }
            }
            return builder.build();
        }
    }
}

