/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.ui.util;

import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.forge.addon.ui.command.UICommand;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.wizard.UIWizardStep;

public class Commands {
    private static final Logger log = Logger.getLogger(Commands.class.getName());

    public static Iterable<UICommand> getEnabledCommands(Iterable<UICommand> commands, UIContext context) {
        LinkedList<UICommand> result = new LinkedList<UICommand>();
        for (UICommand uiCommand : commands) {
            try {
                if (!Commands.isEnabled(uiCommand, context)) continue;
                result.add(uiCommand);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Could not call method " + UICommand.class.getName() + "`isEnabled(UIContext ctx)` of type [" + uiCommand + "] with Metadata [" + Commands.getMetadata(uiCommand, context) + "].", e);
            }
        }
        return result;
    }

    public static boolean isEnabled(UICommand command, UIContext context) {
        return command.isEnabled(context) && !(command instanceof UIWizardStep);
    }

    private static String getMetadata(UICommand command, UIContext context) {
        String result = "!!! Failed to load Metadata via `" + UICommand.class.getName() + ".getMetadata(UIContext ctx)` !!!";
        try {
            UICommandMetadata metadata = command.getMetadata(context);
            result = metadata.toString();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Could not call method " + UICommand.class.getName() + "`getMetadata(UIContext ctx)` of type [" + command + "].", e);
        }
        return result;
    }
}

