/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.archives.config;

import java.io.File;
import java.util.logging.Logger;
import org.jboss.forge.furnace.util.Predicate;
import org.jboss.forge.furnace.util.Visitor;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.WindupRuleProvider;
import org.jboss.windup.config.operation.GraphOperation;
import org.jboss.windup.config.phase.Initialization;
import org.jboss.windup.config.phase.RulePhase;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.rules.apps.java.archives.identify.IdentifiedArchives;
import org.jboss.windup.util.Logging;
import org.jboss.windup.util.WindupPathUtil;
import org.jboss.windup.util.exception.WindupException;
import org.jboss.windup.util.file.FileSuffixPredicate;
import org.jboss.windup.util.file.FileVisit;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.config.ConfigurationBuilder;
import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.context.EvaluationContext;

public class ArchiveIdentificationConfigLoadingRuleProvider
extends WindupRuleProvider {
    private static final Logger log = Logging.get(ArchiveIdentificationConfigLoadingRuleProvider.class);

    public Class<? extends RulePhase> getPhase() {
        return Initialization.class;
    }

    public Configuration getConfiguration(GraphContext grCtx) {
        ConfigurationBuilder config = ConfigurationBuilder.begin();
        config.addRule().perform((Operation)new GraphOperation(){

            public void perform(GraphRewrite event, EvaluationContext evCtx) {
                Visitor<File> visitor = new Visitor<File>(){

                    public void visit(File file) {
                        try {
                            log.info("Loading archive identification metadata from [" + file.getAbsolutePath() + "]");
                            IdentifiedArchives.addMappingsFrom(file);
                        }
                        catch (Exception e) {
                            throw new WindupException("Failed to load metadata from file [" + file + "]", (Throwable)e);
                        }
                    }
                };
                FileSuffixPredicate predicate = new FileSuffixPredicate("\\.archive-metadata\\.txt");
                FileVisit.visit((File)WindupPathUtil.getUserCacheDir().toFile(), (Predicate)predicate, (Visitor)visitor);
                FileVisit.visit((File)WindupPathUtil.getWindupCacheDir().toFile(), (Predicate)predicate, (Visitor)visitor);
            }
        });
        return config;
    }
}

