/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.archives.identify;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.lang.StringUtils;
import org.jboss.forge.addon.dependencies.Coordinate;
import org.jboss.forge.addon.dependencies.builder.CoordinateBuilder;
import org.jboss.windup.util.exception.WindupException;

public class IdentifiedArchives {
    private static final Map<String, String> map = new TreeMap<String, String>();

    public static Coordinate getCoordinateFromSHA1(String sha1Hash) {
        if (sha1Hash == null) {
            return null;
        }
        String coordinate = map.get(sha1Hash);
        if (coordinate == null) {
            return null;
        }
        return CoordinateBuilder.create((String)coordinate);
    }

    public static void addMapping(String sha1, String coordinate) {
        map.put(sha1, coordinate);
    }

    public static void addMappingsFrom(File file) {
        try (FileInputStream inputStream = new FileInputStream(file);){
            LineIterator it = IOUtils.lineIterator((InputStream)inputStream, (String)"UTF-8");
            while (it.hasNext()) {
                String line = it.next();
                if (line.startsWith("#") || line.trim().isEmpty()) continue;
                String[] parts = StringUtils.split((String)line, (char)' ');
                if (parts.length < 2) {
                    throw new IllegalArgumentException("Expected 'SHA1 GROUP_ID:ARTIFACT_ID:VERSION[:COORDINATE]', but was [" + line + "] in [" + file + "]");
                }
                IdentifiedArchives.addMapping(parts[0], parts[1]);
            }
        }
        catch (IOException e) {
            throw new WindupException("Failed to load SHA1 to " + Coordinate.class.getSimpleName() + " definitions from [" + file + "]", (Throwable)e);
        }
    }
}

