/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.util.time;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.core.attribute.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class Durations {
    private static final Map<String, TimeUnit> unitNames = new HashMap<String, TimeUnit>(){
        {
            for (TimeUnit unit : TimeUnit.values()) {
                this.put(Durations.abbreviate(unit), unit);
                String name = unit.toString().toLowerCase();
                this.put(name, unit);
                assert (name.endsWith("s"));
                this.put(name.substring(0, name.length() - 1), unit);
            }
            this.put("us", TimeUnit.MICROSECONDS);
        }
    };

    public static Duration min(Duration x, Duration y) {
        return x.compareTo(y) <= 0 ? x : y;
    }

    static String abbreviate(TimeUnit unit) {
        switch (unit) {
            case NANOSECONDS: {
                return "ns";
            }
            case MICROSECONDS: {
                return "\u03bcs";
            }
            case MILLISECONDS: {
                return "ms";
            }
            case SECONDS: {
                return "s";
            }
            case MINUTES: {
                return "m";
            }
            case HOURS: {
                return "h";
            }
            case DAYS: {
                return "d";
            }
        }
        throw new AssertionError((Object)("Unexpected time unit: " + (Object)((Object)unit)));
    }

    public static TimeUnit parse(String unitName) {
        TimeUnit unit = unitNames.get(unitName.toLowerCase());
        Preconditions.checkArgument((unit != null ? 1 : 0) != 0, (String)"Unknown unit time: %s", (Object[])new Object[]{unitName});
        return unit;
    }

    public static int compare(long length1, TimeUnit unit1, long length2, TimeUnit unit2) {
        long length2Adj = unit1.convert(length2, unit2);
        if (length1 < length2Adj) {
            return -1;
        }
        if (length2Adj < length1) {
            return 1;
        }
        return 0;
    }
}

