/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.rexster.server.metrics;

import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ganglia.GangliaReporter;
import com.tinkerpop.rexster.server.metrics.AbstractHostPortReporterConfig;
import com.tinkerpop.rexster.server.metrics.HostPort;
import com.tinkerpop.rexster.server.metrics.RegexMetricFilter;
import info.ganglia.gmetric4j.gmetric.GMetric;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.log4j.Logger;

class GangliaReporterConfig
extends AbstractHostPortReporterConfig {
    private static final Logger logger = Logger.getLogger(GangliaReporterConfig.class);
    private List<GangliaReporter> reporters = new ArrayList<GangliaReporter>();

    public GangliaReporterConfig(HierarchicalConfiguration config, MetricRegistry metricRegistry) {
        super(config, metricRegistry);
        this.hostsString = this.registryConfiguration.getString("hosts", "localhost:8649");
        logger.info((Object)String.format("Configured Ganglia Metric Reporter [%s].", this.hostsString));
    }

    @Override
    public List<HostPort> getFullHostList() {
        return this.getHostListAndStringList();
    }

    @Override
    public boolean enable() {
        List<HostPort> hosts = this.getFullHostList();
        if (hosts == null || hosts.isEmpty()) {
            logger.error((Object)"No hosts specified, cannot enable GangliaReporter");
            return false;
        }
        try {
            for (HostPort hostPort : hosts) {
                GMetric ganglia = new GMetric(hostPort.getHost(), hostPort.getPort(), GMetric.UDPAddressingMode.MULTICAST, 1);
                GangliaReporter reporter = GangliaReporter.forRegistry((MetricRegistry)this.metricRegistry).convertDurationsTo(this.getRealDurationTimeUnitConversion()).convertRatesTo(this.getRealRateTimeUnitConversion()).filter((MetricFilter)new RegexMetricFilter(this.inclusion, this.exclusion)).build(ganglia);
                reporter.start(this.period, this.getRealTimeUnit());
                this.reporters.add(reporter);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Failure while enabling ganglia reporter", (Throwable)e);
            return false;
        }
        return true;
    }

    @Override
    public void disable() {
        for (GangliaReporter reporter : this.reporters) {
            reporter.stop();
        }
        this.reporters.clear();
    }
}

