/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.service;

import com.thinkaurelius.titan.core.attribute.Text;
import com.tinkerpop.blueprints.Predicate;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.frames.structures.FramedVertexIterable;
import com.tinkerpop.gremlin.java.GremlinPipeline;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.ProjectModel;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.reporting.model.InlineHintModel;

public class InlineHintService
extends GraphService<InlineHintModel> {
    public InlineHintService(GraphContext context) {
        super(context, InlineHintModel.class);
    }

    public Iterable<InlineHintModel> getHintsForFile(FileModel file) {
        GremlinPipeline inlineHintPipeline = new GremlinPipeline((Object)file.asVertex());
        inlineHintPipeline.in(new String[]{"file"});
        inlineHintPipeline.has("w:vertextype", (Predicate)Text.CONTAINS, (Object)"Inlinehintmodel");
        return new FramedVertexIterable(this.getGraphContext().getFramed(), (Iterable)inlineHintPipeline, InlineHintModel.class);
    }

    public int getMigrationEffortPoints(FileModel fileModel) {
        GremlinPipeline inlineHintPipeline = new GremlinPipeline((Object)fileModel.asVertex());
        inlineHintPipeline.in(new String[]{"file"});
        inlineHintPipeline.has("w:vertextype", (Predicate)Text.CONTAINS, (Object)"Inlinehintmodel");
        int hintEffort = 0;
        for (Vertex v : inlineHintPipeline) {
            hintEffort += ((Integer)v.getProperty("windupreporting:effort")).intValue();
        }
        return hintEffort;
    }

    public int getMigrationEffortPoints(ProjectModel projectModel, boolean recursive) {
        GremlinPipeline inlineHintPipeline = new GremlinPipeline((Object)projectModel.asVertex());
        inlineHintPipeline.out(new String[]{"projectModelToFile"}).in(new String[]{"file"});
        inlineHintPipeline.has("w:vertextype", (Predicate)Text.CONTAINS, (Object)"Inlinehintmodel");
        int hintEffort = 0;
        for (Vertex v : inlineHintPipeline) {
            hintEffort += ((Integer)v.getProperty("windupreporting:effort")).intValue();
        }
        if (recursive) {
            for (ProjectModel childProject : projectModel.getChildProjects()) {
                hintEffort += this.getMigrationEffortPoints(childProject, recursive);
            }
        }
        return hintEffort;
    }
}

