/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.jboss.forge.furnace.util.Predicate;
import org.jboss.forge.furnace.util.Visitor;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.WindupRuleProvider;
import org.jboss.windup.config.operation.GraphOperation;
import org.jboss.windup.config.phase.Initialization;
import org.jboss.windup.config.phase.RulePhase;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.rules.apps.java.model.WindupJavaConfigurationModel;
import org.jboss.windup.rules.apps.java.service.WindupJavaConfigurationService;
import org.jboss.windup.util.WindupPathUtil;
import org.jboss.windup.util.exception.WindupException;
import org.jboss.windup.util.file.FileSuffixPredicate;
import org.jboss.windup.util.file.FileVisit;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.config.ConfigurationBuilder;
import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.context.EvaluationContext;

public class CopyJavaConfigToGraphRuleProvider
extends WindupRuleProvider {
    public Class<? extends RulePhase> getPhase() {
        return Initialization.class;
    }

    public Configuration getConfiguration(GraphContext context) {
        GraphOperation copyConfigToGraph = new GraphOperation(){

            public void perform(GraphRewrite event, EvaluationContext context) {
                Map config = event.getGraphContext().getOptionMap();
                Boolean sourceMode = (Boolean)config.get("sourceMode");
                List includeJavaPackages = (List)config.get("packages");
                final ArrayList<String> excludeJavaPackages = new ArrayList<String>((List)config.get("excludePackages"));
                FileSuffixPredicate predicate = new FileSuffixPredicate("\\.package-ignore\\.txt");
                Visitor<File> visitor = new Visitor<File>(){

                    public void visit(File file) {
                        try (FileInputStream inputStream = new FileInputStream(file);){
                            LineIterator it = IOUtils.lineIterator((InputStream)inputStream, (String)"UTF-8");
                            while (it.hasNext()) {
                                String line = it.next();
                                if (line.startsWith("#") || line.trim().isEmpty()) continue;
                                excludeJavaPackages.add(line);
                            }
                        }
                        catch (Exception e) {
                            throw new WindupException("Failed loading package ignore patterns from [" + file.toString() + "]", (Throwable)e);
                        }
                    }
                };
                FileVisit.visit((File)WindupPathUtil.getUserIgnoreDir().toFile(), (Predicate)predicate, (Visitor)visitor);
                FileVisit.visit((File)WindupPathUtil.getWindupIgnoreDir().toFile(), (Predicate)predicate, (Visitor)visitor);
                WindupJavaConfigurationModel javaCfg = WindupJavaConfigurationService.getJavaConfigurationModel(event.getGraphContext());
                javaCfg.setSourceMode(sourceMode == null ? false : sourceMode);
                javaCfg.setScanJavaPackageList(includeJavaPackages);
                javaCfg.setExcludeJavaPackageList(excludeJavaPackages);
            }
        };
        return ConfigurationBuilder.begin().addRule().perform((Operation)copyConfigToGraph);
    }
}

