/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.scan.provider;

import java.util.ArrayList;
import java.util.List;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.WindupRuleProvider;
import org.jboss.windup.config.operation.Iteration;
import org.jboss.windup.config.operation.IterationProgress;
import org.jboss.windup.config.operation.ruleelement.AbstractIterationFilter;
import org.jboss.windup.config.operation.ruleelement.AbstractIterationOperation;
import org.jboss.windup.config.phase.DiscoverProjectStructure;
import org.jboss.windup.config.phase.RulePhase;
import org.jboss.windup.config.query.Query;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.ArchiveModel;
import org.jboss.windup.graph.model.ProjectModel;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.service.ProjectService;
import org.jboss.windup.rules.apps.java.scan.provider.DiscoverMavenProjectsRuleProvider;
import org.jboss.windup.util.ZipUtil;
import org.ocpsoft.rewrite.config.Condition;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.config.ConfigurationBuilder;
import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.context.EvaluationContext;

public class DiscoverNonMavenArchiveProjectsRuleProvider
extends WindupRuleProvider {
    public Class<? extends RulePhase> getPhase() {
        return DiscoverProjectStructure.class;
    }

    public List<Class<? extends WindupRuleProvider>> getExecuteAfter() {
        return this.asClassList(new Class[]{DiscoverMavenProjectsRuleProvider.class});
    }

    public Configuration getConfiguration(GraphContext arg0) {
        return ConfigurationBuilder.begin().addRule().when((Condition)Query.fromType(ArchiveModel.class)).perform((Operation)Iteration.over(ArchiveModel.class).when((Condition)new AbstractIterationFilter<ArchiveModel>(){

            public boolean evaluate(GraphRewrite event, EvaluationContext context, ArchiveModel payload) {
                return payload.getProjectModel() == null;
            }

            public String toString() {
                return "ProjectModel == null";
            }
        }).perform((Operation)new AbstractIterationOperation<ArchiveModel>(){

            public void perform(GraphRewrite event, EvaluationContext context, ArchiveModel payload) {
                ArrayList<ArchiveModel> hierarchy = new ArrayList<ArchiveModel>();
                for (ArchiveModel parentArchive = payload; parentArchive != null; parentArchive = parentArchive.getParentArchive()) {
                    hierarchy.add(parentArchive);
                    if (parentArchive.getProjectModel() != null) break;
                }
                ProjectModel childProjectModel = null;
                ProjectService projectModelService = new ProjectService(event.getGraphContext());
                for (ArchiveModel archiveModel : hierarchy) {
                    ProjectModel projectModel = archiveModel.getProjectModel();
                    if (projectModel == null) {
                        projectModel = (ProjectModel)projectModelService.create();
                        projectModel.setName(archiveModel.getArchiveName());
                        projectModel.setRootFileModel((FileModel)archiveModel);
                        projectModel.setDescription("Unidentified Archive");
                        if (ZipUtil.endsWithZipExtension((String)archiveModel.getArchiveName())) {
                            for (String extension : ZipUtil.getZipExtensions()) {
                                if (!archiveModel.getArchiveName().endsWith(extension)) continue;
                                projectModel.setProjectType(extension);
                            }
                        }
                        archiveModel.setProjectModel(projectModel);
                        for (FileModel f : archiveModel.getContainedFileModels()) {
                            if (f instanceof ArchiveModel || f.getProjectModel() != null) continue;
                            f.setProjectModel(projectModel);
                            projectModel.addFileModel(f);
                        }
                    }
                    if (childProjectModel != null) {
                        childProjectModel.setParentProject(projectModel);
                    }
                    childProjectModel = projectModel;
                }
            }

            public String toString() {
                return "ScanAsNonMavenProject";
            }
        }.and((Operation)IterationProgress.monitoring((String)"Checking for non-Maven archive: ", (int)1))).endIteration());
    }
}

