/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.streamflyer.regex;

import com.googlecode.streamflyer.core.AfterModification;
import com.googlecode.streamflyer.core.Modifier;
import com.googlecode.streamflyer.internal.thirdparty.ZzzAssert;
import com.googlecode.streamflyer.regex.MatchProcessor;
import com.googlecode.streamflyer.regex.MatchProcessorResult;
import com.googlecode.streamflyer.regex.OnStreamMatcher;
import com.googlecode.streamflyer.regex.OnStreamStandardMatcher;
import com.googlecode.streamflyer.regex.ReplacingProcessor;
import com.googlecode.streamflyer.util.ModificationFactory;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegexModifier
implements Modifier {
    protected ModificationFactory factory;
    protected MatchProcessor matchProcessor;
    protected OnStreamMatcher matcher;
    protected int newNumberOfChars = -1;
    private int unseenCharactersToSkip = 0;

    protected RegexModifier() {
    }

    public RegexModifier(String regex, int flags, String replacement) {
        this(regex, flags, replacement, 1, 2048);
    }

    public RegexModifier(String regex, int flags, String replacement, int minimumLengthOfLookBehind, int newNumberOfChars) {
        this(regex, flags, new ReplacingProcessor(replacement), minimumLengthOfLookBehind, newNumberOfChars);
    }

    public RegexModifier(String regex, int flags, MatchProcessor matchProcessor, int minimumLengthOfLookBehind, int newNumberOfChars) {
        Matcher jdkMatcher = Pattern.compile(regex, flags).matcher("");
        jdkMatcher.useTransparentBounds(true);
        jdkMatcher.useAnchoringBounds(false);
        this.init(new OnStreamStandardMatcher(jdkMatcher), matchProcessor, minimumLengthOfLookBehind, newNumberOfChars);
    }

    public RegexModifier(OnStreamMatcher matcher, MatchProcessor matchProcessor, int minimumLengthOfLookBehind, int newNumberOfChars) {
        this.init(matcher, matchProcessor, minimumLengthOfLookBehind, newNumberOfChars);
    }

    protected void init(OnStreamMatcher matcher, MatchProcessor matchProcessor, int minimumLengthOfLookBehind, int newNumberOfChars) {
        this.factory = new ModificationFactory(minimumLengthOfLookBehind, newNumberOfChars);
        this.matchProcessor = matchProcessor;
        this.matcher = matcher;
        this.newNumberOfChars = newNumberOfChars;
    }

    @Override
    public AfterModification modify(StringBuilder characterBuffer, int firstModifiableCharacterInBuffer, boolean endOfStreamHit) {
        AfterModification mod;
        int maxFrom;
        block18: {
            int numberOfCharactersToSkip;
            Integer minFrom;
            block19: {
                minFrom = null;
                while (true) {
                    if (minFrom == null) {
                        minFrom = firstModifiableCharacterInBuffer;
                        if (this.unseenCharactersToSkip > 0) {
                            if (minFrom + this.unseenCharactersToSkip > characterBuffer.length()) {
                                if (endOfStreamHit) {
                                    return this.factory.stop(characterBuffer, firstModifiableCharacterInBuffer, endOfStreamHit);
                                }
                                return this.factory.fetchMoreInput(0, characterBuffer, firstModifiableCharacterInBuffer, endOfStreamHit);
                            }
                            minFrom = minFrom + this.unseenCharactersToSkip;
                            this.unseenCharactersToSkip = 0;
                        }
                    }
                    if ((maxFrom = firstModifiableCharacterInBuffer + this.newNumberOfChars) > characterBuffer.length()) {
                        maxFrom = characterBuffer.length();
                    }
                    this.matcher.reset(characterBuffer);
                    boolean matchFound = this.matcher.findUnlessHitEnd(minFrom, maxFrom);
                    if (!matchFound) break block18;
                    if (this.matcher.hitEnd() && !endOfStreamHit) {
                        int numberOfCharactersToSkip2 = this.matcher.lastFrom() - firstModifiableCharacterInBuffer;
                        mod = this.factory.fetchMoreInput(numberOfCharactersToSkip2, characterBuffer, firstModifiableCharacterInBuffer, endOfStreamHit);
                        assert (this.__checkpoint("name", "match_open", "minLen", firstModifiableCharacterInBuffer, "characterBuffer", characterBuffer, "endOfStreamHit", endOfStreamHit, "afterModification", mod));
                        return mod;
                    }
                    OnStreamMatcher matchResult = this.matcher;
                    MatchProcessorResult matchProcessorResult = this.matchProcessor.process(characterBuffer, minFrom, matchResult);
                    if ((minFrom = Integer.valueOf(matchProcessorResult.getFirstModifiableCharacterInBuffer())) > maxFrom || !matchProcessorResult.isContinueMatching()) break block19;
                    assert (this.__checkpoint("name", "match_n_continue", "minLen", firstModifiableCharacterInBuffer, "characterBuffer", characterBuffer, "endOfStreamHit", endOfStreamHit, "minFrom", minFrom));
                }
            }
            if (minFrom > characterBuffer.length()) {
                this.unseenCharactersToSkip = minFrom - characterBuffer.length();
                ZzzAssert.isTrue(this.unseenCharactersToSkip == 1, "unseenCharactersToSkip must be one but was " + this.unseenCharactersToSkip);
                numberOfCharactersToSkip = characterBuffer.length() - firstModifiableCharacterInBuffer;
            } else {
                numberOfCharactersToSkip = minFrom - firstModifiableCharacterInBuffer;
            }
            if (numberOfCharactersToSkip == 0) {
                AfterModification mod2 = this.factory.fetchMoreInput(numberOfCharactersToSkip, characterBuffer, firstModifiableCharacterInBuffer, false);
                assert (this.__checkpoint("name", "match_n_refill", "minLen", firstModifiableCharacterInBuffer, "characterBuffer", characterBuffer, "endOfStreamHit", endOfStreamHit, "afterModification", mod2));
                return mod2;
            }
            AfterModification mod3 = this.factory.skipOrStop(numberOfCharactersToSkip, characterBuffer, firstModifiableCharacterInBuffer, endOfStreamHit);
            assert (this.__checkpoint("name", "match_n_skip", "minLen", firstModifiableCharacterInBuffer, "characterBuffer", characterBuffer, "endOfStreamHit", endOfStreamHit, "afterModification", mod3));
            return mod3;
        }
        if (this.matcher.lastFrom() <= maxFrom) {
            if (endOfStreamHit) {
                int numberOfCharactersToSkip = maxFrom - firstModifiableCharacterInBuffer;
                mod = this.factory.skipOrStop(numberOfCharactersToSkip, characterBuffer, firstModifiableCharacterInBuffer, endOfStreamHit);
                assert (this.__checkpoint("name", "nomatch_eos", "minLen", firstModifiableCharacterInBuffer, "characterBuffer", characterBuffer, "endOfStreamHit", endOfStreamHit, "afterModification", mod));
                return mod;
            }
            int numberOfCharactersToSkip = this.matcher.lastFrom() - firstModifiableCharacterInBuffer;
            mod = this.factory.fetchMoreInput(numberOfCharactersToSkip, characterBuffer, firstModifiableCharacterInBuffer, endOfStreamHit);
            assert (this.__checkpoint("name", "nomatch_fetch", "minLen", firstModifiableCharacterInBuffer, "characterBuffer", characterBuffer, "endOfStreamHit", endOfStreamHit, "afterModification", mod));
            return mod;
        }
        int numberOfCharactersToSkip = maxFrom - firstModifiableCharacterInBuffer;
        mod = this.factory.skipOrStop(numberOfCharactersToSkip, characterBuffer, firstModifiableCharacterInBuffer, endOfStreamHit);
        assert (this.__checkpoint("name", "nomatch_skip", "minLen", firstModifiableCharacterInBuffer, "characterBuffer", characterBuffer, "endOfStreamHit", endOfStreamHit, "afterModification", mod));
        return mod;
    }

    protected boolean __checkpoint(Object ... checkpointDescription) {
        return true;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("RegexModifier [\nfactory=");
        builder.append(this.factory);
        builder.append(", \nreplacement=");
        builder.append(this.matchProcessor);
        builder.append(", \nmatcher=");
        builder.append(this.matcher);
        builder.append(", \nnewNumberOfChars=");
        builder.append(this.newNumberOfChars);
        builder.append("]");
        return builder.toString();
    }

    public void setMatchProcessor(MatchProcessor matchProcessor) {
        this.matchProcessor = matchProcessor;
    }
}

