/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.resource;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.jboss.forge.addon.resource.AbstractResource;
import org.jboss.forge.addon.resource.DirectoryResource;
import org.jboss.forge.addon.resource.FileOperations;
import org.jboss.forge.addon.resource.FileResource;
import org.jboss.forge.addon.resource.Resource;
import org.jboss.forge.addon.resource.ResourceException;
import org.jboss.forge.addon.resource.ResourceFactory;
import org.jboss.forge.addon.resource.ResourceFilter;
import org.jboss.forge.addon.resource.monitor.ResourceMonitor;
import org.jboss.forge.furnace.util.Assert;
import org.jboss.forge.furnace.util.OperatingSystemUtils;
import org.jboss.forge.furnace.util.Streams;

public abstract class AbstractFileResource<T extends FileResource<T>>
extends AbstractResource<File>
implements FileResource<T> {
    private File file;
    private long lastModification = -1L;

    protected AbstractFileResource(ResourceFactory factory, File file) {
        super(factory, null);
        this.file = file;
    }

    @Override
    public String getName() {
        return this.file.getName();
    }

    public String toString() {
        return this.getFullyQualifiedName();
    }

    @Override
    public File getUnderlyingResourceObject() {
        return this.file;
    }

    @Override
    public InputStream getResourceInputStream() {
        try {
            return this.getFileOperations().createInputStream(this.file);
        }
        catch (IOException e) {
            throw new ResourceException("cannot obtain stream to file: file does not exist: " + this.file.getAbsolutePath());
        }
    }

    @Override
    public DirectoryResource getParent() {
        return this.file.getParentFile() != null ? this.getResourceFactory().create(DirectoryResource.class, this.file.getParentFile()) : null;
    }

    @Override
    public Resource<?> getChild(String name) {
        return null;
    }

    @Override
    public abstract Resource<File> createFrom(File var1);

    @Override
    public boolean exists() {
        return this.getFileOperations().fileExists(this.file);
    }

    @Override
    public boolean isDirectory() {
        return this.getFileOperations().fileExistsAndIsDirectory(this.file);
    }

    @Override
    public boolean isStale() {
        return this.lastModification != this.getUnderlyingResourceObject().lastModified();
    }

    @Override
    public void refresh() {
        this.lastModification = this.getUnderlyingResourceObject().lastModified();
    }

    @Override
    public boolean mkdir() {
        return this.getFileOperations().mkdir(this.file);
    }

    @Override
    public boolean mkdirs() {
        return this.getFileOperations().mkdirs(this.file);
    }

    @Override
    public boolean delete() {
        return this.delete(false);
    }

    @Override
    public boolean delete(boolean recursive) {
        if (recursive) {
            return this._deleteRecursive(this.file, true);
        }
        File[] listFiles = this.getFileOperations().listFiles(this.file);
        if (listFiles != null && listFiles.length != 0) {
            throw new RuntimeException("directory not empty");
        }
        if (OperatingSystemUtils.isWindows()) {
            System.gc();
        }
        return this.getFileOperations().deleteFile(this.file);
    }

    @Override
    public void deleteOnExit() {
        this.getFileOperations().deleteFileOnExit(this.file);
    }

    private boolean _deleteRecursive(File file, boolean collect) {
        if (collect && OperatingSystemUtils.isWindows()) {
            System.gc();
        }
        if (file == null) {
            return false;
        }
        File[] children = this.getFileOperations().listFiles(file);
        if (children != null) {
            for (File sf : children) {
                if (this.getFileOperations().fileExistsAndIsDirectory(sf)) {
                    this._deleteRecursive(sf, false);
                    continue;
                }
                if (this.getFileOperations().deleteFile(sf)) continue;
                throw new RuntimeException("failed to delete: " + sf.getAbsolutePath());
            }
        }
        return this.getFileOperations().deleteFile(file);
    }

    @Override
    public T setContents(String data) {
        if (data == null) {
            data = "";
        }
        return (T)this.setContents(data.toCharArray());
    }

    @Override
    public T setContents(String data, Charset charset) {
        if (data == null) {
            data = "";
        }
        return (T)this.setContents(data.toCharArray(), charset);
    }

    @Override
    public T setContents(char[] data, Charset charset) {
        return (T)this.setContents(new ByteArrayInputStream(new String(data).getBytes(charset)));
    }

    @Override
    public T setContents(char[] data) {
        return (T)this.setContents(new ByteArrayInputStream(new String(data).getBytes()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T setContents(InputStream data) {
        Assert.notNull((Object)data, (String)"InputStream must not be null.");
        try {
            if (!this.exists()) {
                this.getParent().mkdirs();
                if (!this.createNewFile()) {
                    throw new IOException("Failed to create file: " + this.file);
                }
            }
            try (OutputStream out = this.getResourceOutputStream();){
                Streams.write((InputStream)data, (OutputStream)out);
                out.flush();
            }
            finally {
                Streams.closeQuietly((Closeable)data);
            }
        }
        catch (IOException e) {
            throw new ResourceException("Error while setting the contents", e);
        }
        return (T)this;
    }

    @Override
    public boolean createNewFile() {
        try {
            this.getParent().mkdirs();
            return this.getFileOperations().createNewFile(this.file);
        }
        catch (IOException e) {
            throw new ResourceException("Error while creating a new file", e);
        }
    }

    @Override
    public T createTempResource() {
        try {
            FileResource result = (FileResource)this.createFrom(File.createTempFile("forgetemp", ""));
            return (T)result;
        }
        catch (IOException e) {
            throw new ResourceException("Error while creating a temporary resource", e);
        }
    }

    @Override
    public boolean renameTo(String pathspec) {
        return this.renameTo(new File(pathspec));
    }

    @Override
    public boolean renameTo(FileResource<?> target) {
        return this.renameTo((File)target.getUnderlyingResourceObject());
    }

    private boolean renameTo(File target) {
        if (this.getFileOperations().renameFile(this.file, target)) {
            this.file = target;
            return true;
        }
        return false;
    }

    @Override
    public long getSize() {
        return this.getFileOperations().getFileLength(this.file);
    }

    @Override
    public boolean isExecutable() {
        return this.file.canExecute() && !this.getFileOperations().fileExistsAndIsDirectory(this.file);
    }

    @Override
    public boolean isReadable() {
        return this.file.canRead() && !this.getFileOperations().fileExistsAndIsDirectory(this.file);
    }

    @Override
    public boolean isWritable() {
        return this.file.canWrite() && !this.getFileOperations().fileExistsAndIsDirectory(this.file);
    }

    @Override
    public String getFullyQualifiedName() {
        return this.file.getAbsolutePath();
    }

    @Override
    public ResourceMonitor monitor() {
        return this.getResourceFactory().monitor(this);
    }

    @Override
    public ResourceMonitor monitor(ResourceFilter filter) {
        return this.getResourceFactory().monitor(this, filter);
    }

    protected FileOperations getFileOperations() {
        return this.getResourceFactory().getFileOperations();
    }

    @Override
    public long getLastModified() {
        return this.file.lastModified();
    }

    @Override
    public void setLastModified(long time) {
        this.file.setLastModified(time);
    }

    @Override
    public OutputStream getResourceOutputStream() {
        try {
            return this.getFileOperations().createOutputStream(this.file);
        }
        catch (IOException ioe) {
            throw new ResourceException("Error while creating OutputStream for Resource " + this, ioe);
        }
    }
}

