/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.configuration;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.configuration.reloading.FileChangedReloadingStrategy;
import org.apache.commons.configuration.reloading.ReloadingStrategy;
import org.jboss.forge.addon.configuration.Configuration;
import org.jboss.forge.addon.configuration.ConfigurationAdapter;
import org.jboss.forge.addon.configuration.ConfigurationException;
import org.jboss.forge.addon.configuration.ConfigurationFactory;
import org.jboss.forge.addon.configuration.Subset;
import org.jboss.forge.addon.resource.FileResource;
import org.jboss.forge.furnace.Furnace;
import org.jboss.forge.furnace.util.OperatingSystemUtils;

@Singleton
public class ConfigurationFactoryImpl
implements ConfigurationFactory {
    static final String USER_CONFIG_PATH = "org.jboss.forge.addon.configuration.USER_CONFIG_PATH";
    private Configuration userConfiguration;
    @Inject
    private Furnace furnace;

    @Produces
    Configuration getUserConfiguration(InjectionPoint ip) throws ConfigurationException {
        Annotated annotated;
        Configuration config = this.getUserConfiguration();
        if (ip != null && (annotated = ip.getAnnotated()).isAnnotationPresent(Subset.class)) {
            config = config.subset(((Subset)annotated.getAnnotation(Subset.class)).value());
        }
        return config;
    }

    public Configuration getUserConfiguration() throws ConfigurationException {
        if (this.furnace.isTestMode()) {
            this.setupTemporaryUserConfig();
        }
        if (this.userConfiguration == null) {
            String property = System.getProperty(USER_CONFIG_PATH);
            File userConfigurationFile = property == null || property.isEmpty() ? new File(OperatingSystemUtils.getUserForgeDir(), "config.xml") : new File(property);
            if (!userConfigurationFile.exists() || userConfigurationFile.length() == 0L) {
                File parentFile = userConfigurationFile.getParentFile();
                if (parentFile != null) {
                    parentFile.mkdirs();
                }
                try (FileWriter fw = new FileWriter(userConfigurationFile);){
                    fw.write("<configuration/>");
                }
                catch (IOException e) {
                    throw new ConfigurationException("Error while create user configuration", (Throwable)e);
                }
            }
            this.userConfiguration = this.getConfiguration(userConfigurationFile);
        }
        return this.userConfiguration;
    }

    public Configuration getConfiguration(FileResource<?> configFile) {
        return this.getConfiguration((File)configFile.getUnderlyingResourceObject());
    }

    private Configuration getConfiguration(File file) {
        try {
            XMLConfiguration commonsConfig = new XMLConfiguration(file);
            commonsConfig.setEncoding("UTF-8");
            commonsConfig.setReloadingStrategy((ReloadingStrategy)new FileChangedReloadingStrategy());
            commonsConfig.setAutoSave(true);
            return new ConfigurationAdapter().setDelegate((HierarchicalConfiguration)commonsConfig);
        }
        catch (org.apache.commons.configuration.ConfigurationException e) {
            throw new ConfigurationException("Error while creating configuration from " + file, (Throwable)e);
        }
    }

    private void setupTemporaryUserConfig() {
        if (System.getProperty(USER_CONFIG_PATH) == null) {
            try {
                File tmpFile = File.createTempFile("user_config", ".xml");
                System.setProperty(USER_CONFIG_PATH, tmpFile.getAbsolutePath());
                tmpFile.deleteOnExit();
            }
            catch (IOException e) {
                throw new IllegalStateException("Cannot create temp file", e);
            }
        }
    }
}

