/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.index.creator;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexableField;
import org.apache.maven.index.ArtifactContext;
import org.apache.maven.index.ArtifactInfo;
import org.apache.maven.index.IndexerField;
import org.apache.maven.index.IndexerFieldVersion;
import org.apache.maven.index.OSGI;
import org.apache.maven.index.creator.AbstractIndexCreator;
import org.apache.maven.index.util.zip.ZipFacade;
import org.apache.maven.index.util.zip.ZipHandle;
import org.codehaus.plexus.util.StringUtils;

@Singleton
@Named(value="osgi-metadatas")
public class OsgiArtifactIndexCreator
extends AbstractIndexCreator {
    public static final String ID = "osgi-metadatas";
    private static final String BSN = "Bundle-SymbolicName";
    public static final IndexerField FLD_BUNDLE_SYMBOLIC_NAME = new IndexerField(OSGI.SYMBOLIC_NAME, IndexerFieldVersion.V4, "Bundle-SymbolicName", "Bundle-SymbolicName (indexed, stored)", Field.Store.YES, Field.Index.ANALYZED);
    private static final String BV = "Bundle-Version";
    public static final IndexerField FLD_BUNDLE_VERSION = new IndexerField(OSGI.VERSION, IndexerFieldVersion.V4, "Bundle-Version", "Bundle-Version (indexed, stored)", Field.Store.YES, Field.Index.ANALYZED);
    private static final String BEP = "Export-Package";
    public static final IndexerField FLD_BUNDLE_EXPORT_PACKAGE = new IndexerField(OSGI.EXPORT_PACKAGE, IndexerFieldVersion.V4, "Export-Package", "Export-Package (indexed, stored)", Field.Store.YES, Field.Index.ANALYZED);
    private static final String BES = "Export-Service";
    public static final IndexerField FLD_BUNDLE_EXPORT_SERVIVE = new IndexerField(OSGI.EXPORT_SERVICE, IndexerFieldVersion.V4, "Export-Service", "Export-Service (indexed, stored)", Field.Store.YES, Field.Index.ANALYZED);
    private static final String BD = "Bundle-Description";
    public static final IndexerField FLD_BUNDLE_DESCRIPTION = new IndexerField(OSGI.DESCRIPTION, IndexerFieldVersion.V4, "Bundle-Description", "Bundle-Description (indexed, stored)", Field.Store.YES, Field.Index.ANALYZED);
    private static final String BN = "Bundle-Name";
    public static final IndexerField FLD_BUNDLE_NAME = new IndexerField(OSGI.NAME, IndexerFieldVersion.V4, "Bundle-Name", "Bundle-Name (indexed, stored)", Field.Store.YES, Field.Index.ANALYZED);
    private static final String BL = "Bundle-License";
    public static final IndexerField FLD_BUNDLE_LICENSE = new IndexerField(OSGI.LICENSE, IndexerFieldVersion.V4, "Bundle-License", "Bundle-License (indexed, stored)", Field.Store.YES, Field.Index.ANALYZED);
    private static final String BDU = "Bundle-DocURL";
    public static final IndexerField FLD_BUNDLE_DOCURL = new IndexerField(OSGI.DOCURL, IndexerFieldVersion.V4, "Bundle-DocURL", "Bundle-DocURL (indexed, stored)", Field.Store.YES, Field.Index.ANALYZED);
    private static final String BIP = "Import-Package";
    public static final IndexerField FLD_BUNDLE_IMPORT_PACKAGE = new IndexerField(OSGI.IMPORT_PACKAGE, IndexerFieldVersion.V4, "Import-Package", "Import-Package (indexed, stored)", Field.Store.YES, Field.Index.ANALYZED);
    private static final String BRB = "Require-Bundle";
    public static final IndexerField FLD_BUNDLE_REQUIRE_BUNDLE = new IndexerField(OSGI.REQUIRE_BUNDLE, IndexerFieldVersion.V4, "Require-Bundle", "Require-Bundle (indexed, stored)", Field.Store.YES, Field.Index.ANALYZED);

    @Override
    public Collection<IndexerField> getIndexerFields() {
        return Arrays.asList(FLD_BUNDLE_SYMBOLIC_NAME, FLD_BUNDLE_VERSION, FLD_BUNDLE_EXPORT_PACKAGE, FLD_BUNDLE_EXPORT_SERVIVE, FLD_BUNDLE_DESCRIPTION, FLD_BUNDLE_NAME, FLD_BUNDLE_LICENSE, FLD_BUNDLE_DOCURL, FLD_BUNDLE_IMPORT_PACKAGE, FLD_BUNDLE_REQUIRE_BUNDLE);
    }

    public OsgiArtifactIndexCreator() {
        super(ID);
    }

    @Override
    public void populateArtifactInfo(ArtifactContext artifactContext) throws IOException {
        ArtifactInfo ai = artifactContext.getArtifactInfo();
        File artifactFile = artifactContext.getArtifact();
        if (artifactFile != null && artifactFile.isFile() && artifactFile.getName().endsWith(".jar")) {
            this.updateArtifactInfo(ai, artifactFile);
        }
    }

    @Override
    public void updateDocument(ArtifactInfo artifactInfo, Document document) {
        if (artifactInfo.getBundleSymbolicName() != null) {
            document.add((IndexableField)FLD_BUNDLE_SYMBOLIC_NAME.toField(artifactInfo.getBundleSymbolicName()));
        }
        if (artifactInfo.getBundleVersion() != null) {
            document.add((IndexableField)FLD_BUNDLE_VERSION.toField(artifactInfo.getBundleVersion()));
        }
        if (artifactInfo.getBundleExportPackage() != null) {
            document.add((IndexableField)FLD_BUNDLE_EXPORT_PACKAGE.toField(artifactInfo.getBundleExportPackage()));
        }
        if (artifactInfo.getBundleExportService() != null) {
            document.add((IndexableField)FLD_BUNDLE_EXPORT_SERVIVE.toField(artifactInfo.getBundleExportService()));
        }
        if (artifactInfo.getBundleDescription() != null) {
            document.add((IndexableField)FLD_BUNDLE_DESCRIPTION.toField(artifactInfo.getBundleDescription()));
        }
        if (artifactInfo.getBundleName() != null) {
            document.add((IndexableField)FLD_BUNDLE_NAME.toField(artifactInfo.getBundleName()));
        }
        if (artifactInfo.getBundleLicense() != null) {
            document.add((IndexableField)FLD_BUNDLE_LICENSE.toField(artifactInfo.getBundleLicense()));
        }
        if (artifactInfo.getBundleDocUrl() != null) {
            document.add((IndexableField)FLD_BUNDLE_DOCURL.toField(artifactInfo.getBundleDocUrl()));
        }
        if (artifactInfo.getBundleImportPackage() != null) {
            document.add((IndexableField)FLD_BUNDLE_IMPORT_PACKAGE.toField(artifactInfo.getBundleImportPackage()));
        }
        if (artifactInfo.getBundleRequireBundle() != null) {
            document.add((IndexableField)FLD_BUNDLE_REQUIRE_BUNDLE.toField(artifactInfo.getBundleRequireBundle()));
        }
    }

    @Override
    public boolean updateArtifactInfo(Document document, ArtifactInfo artifactInfo) {
        String bundleRequireBundle;
        String bundleImportPackage;
        String bundleDocUrl;
        String bundleLicense;
        String bundleName;
        String bundleDescription;
        String bundleExportService;
        String bundleExportPackage;
        String bundleVersion;
        boolean updated = false;
        String bundleSymbolicName = document.get(FLD_BUNDLE_SYMBOLIC_NAME.getKey());
        if (bundleSymbolicName != null) {
            artifactInfo.setBundleSymbolicName(bundleSymbolicName);
            updated = true;
        }
        if ((bundleVersion = document.get(FLD_BUNDLE_VERSION.getKey())) != null) {
            artifactInfo.setBundleVersion(bundleVersion);
            updated = true;
        }
        if ((bundleExportPackage = document.get(FLD_BUNDLE_EXPORT_PACKAGE.getKey())) != null) {
            artifactInfo.setBundleExportPackage(bundleExportPackage);
            updated = true;
        }
        if ((bundleExportService = document.get(FLD_BUNDLE_EXPORT_SERVIVE.getKey())) != null) {
            artifactInfo.setBundleExportService(bundleExportService);
            updated = true;
        }
        if ((bundleDescription = document.get(FLD_BUNDLE_DESCRIPTION.getKey())) != null) {
            artifactInfo.setBundleDescription(bundleDescription);
            updated = true;
        }
        if ((bundleName = document.get(FLD_BUNDLE_NAME.getKey())) != null) {
            artifactInfo.setBundleName(bundleName);
            updated = true;
        }
        if ((bundleLicense = document.get(FLD_BUNDLE_LICENSE.getKey())) != null) {
            artifactInfo.setBundleLicense(bundleLicense);
            updated = true;
        }
        if ((bundleDocUrl = document.get(FLD_BUNDLE_DOCURL.getKey())) != null) {
            artifactInfo.setBundleDocUrl(bundleDocUrl);
            updated = true;
        }
        if ((bundleImportPackage = document.get(FLD_BUNDLE_IMPORT_PACKAGE.getKey())) != null) {
            artifactInfo.setBundleImportPackage(bundleImportPackage);
            updated = true;
        }
        if ((bundleRequireBundle = document.get(FLD_BUNDLE_REQUIRE_BUNDLE.getKey())) != null) {
            artifactInfo.setBundleRequireBundle(bundleRequireBundle);
            updated = true;
        }
        return updated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateArtifactInfo(ArtifactInfo ai, File f) throws IOException {
        ZipHandle handle = null;
        boolean updated = false;
        try {
            handle = ZipFacade.getZipHandle(f);
            List<String> entries = handle.getEntries();
            for (String name : entries) {
                Manifest manifest;
                Attributes mainAttributes;
                if (!name.equals("META-INF/MANIFEST.MF") || (mainAttributes = (manifest = new Manifest(handle.getEntryContent(name))).getMainAttributes()) == null) continue;
                String attValue = mainAttributes.getValue(BSN);
                if (StringUtils.isNotBlank((String)attValue)) {
                    ai.setBundleSymbolicName(attValue);
                    updated = true;
                } else {
                    ai.setBundleSymbolicName(null);
                }
                attValue = mainAttributes.getValue(BV);
                if (StringUtils.isNotBlank((String)attValue)) {
                    ai.setBundleVersion(attValue);
                    updated = true;
                } else {
                    ai.setBundleVersion(null);
                }
                attValue = mainAttributes.getValue(BEP);
                if (StringUtils.isNotBlank((String)attValue)) {
                    ai.setBundleExportPackage(attValue);
                    updated = true;
                } else {
                    ai.setBundleExportPackage(null);
                }
                attValue = mainAttributes.getValue(BES);
                if (StringUtils.isNotBlank((String)attValue)) {
                    ai.setBundleExportService(attValue);
                    updated = true;
                } else {
                    ai.setBundleExportService(null);
                }
                attValue = mainAttributes.getValue(BD);
                if (StringUtils.isNotBlank((String)attValue)) {
                    ai.setBundleDescription(attValue);
                    updated = true;
                } else {
                    ai.setBundleDescription(null);
                }
                attValue = mainAttributes.getValue(BN);
                if (StringUtils.isNotBlank((String)attValue)) {
                    ai.setBundleName(attValue);
                    updated = true;
                } else {
                    ai.setBundleName(null);
                }
                attValue = mainAttributes.getValue(BL);
                if (StringUtils.isNotBlank((String)attValue)) {
                    ai.setBundleLicense(attValue);
                    updated = true;
                } else {
                    ai.setBundleLicense(null);
                }
                attValue = mainAttributes.getValue(BDU);
                if (StringUtils.isNotBlank((String)attValue)) {
                    ai.setBundleDocUrl(attValue);
                    updated = true;
                } else {
                    ai.setBundleDocUrl(null);
                }
                attValue = mainAttributes.getValue(BIP);
                if (StringUtils.isNotBlank((String)attValue)) {
                    ai.setBundleImportPackage(attValue);
                    updated = true;
                } else {
                    ai.setBundleImportPackage(null);
                }
                attValue = mainAttributes.getValue(BRB);
                if (StringUtils.isNotBlank((String)attValue)) {
                    ai.setBundleRequireBundle(attValue);
                    updated = true;
                    continue;
                }
                ai.setBundleRequireBundle(null);
            }
        }
        finally {
            try {
                ZipFacade.close(handle);
            }
            catch (Exception e) {
                this.getLogger().error("Could not close jar file properly.", (Throwable)e);
            }
        }
        return updated;
    }

    public String toString() {
        return ID;
    }
}

