/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.archives.ignore;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.jboss.forge.addon.dependencies.Coordinate;
import org.jboss.forge.addon.dependencies.builder.CoordinateBuilder;
import org.jboss.forge.furnace.util.Assert;
import org.jboss.forge.furnace.versions.EmptyVersionRange;
import org.jboss.forge.furnace.versions.SingleVersion;
import org.jboss.forge.furnace.versions.SingleVersionRange;
import org.jboss.forge.furnace.versions.Version;
import org.jboss.forge.furnace.versions.VersionRange;
import org.jboss.forge.furnace.versions.Versions;
import org.jboss.windup.rules.apps.java.archives.model.ArchiveCoordinateModel;
import org.jboss.windup.util.exception.WindupException;

public class SkippedArchives {
    private static final Map<Coordinate, VersionRange> map = new HashMap<Coordinate, VersionRange>();

    public static void load(File file) {
        try (FileInputStream inputStream = new FileInputStream(file);){
            LineIterator it = IOUtils.lineIterator((InputStream)inputStream, (String)"UTF-8");
            while (it.hasNext()) {
                String line = it.next();
                if (line.startsWith("#") || line.trim().isEmpty()) continue;
                SkippedArchives.add(line);
            }
        }
        catch (Exception e) {
            throw new WindupException("Failed loading archive ignore patterns from [" + file.toString() + "]", (Throwable)e);
        }
    }

    public static void add(String line) {
        Assert.notNull((Object)line, (String)"Archive coordinate pattern must not be null.");
        CoordinatePattern pattern = SkippedArchives.fromCoordinatePattern(line);
        map.put((Coordinate)pattern.getCoordinate(), pattern.getVersion());
    }

    static CoordinatePattern fromCoordinatePattern(String coordinates) {
        String[] parts = coordinates.split("\\s*:\\s*");
        if (parts.length < 3) {
            throw new IllegalArgumentException("Expected GAV definition format is 'GROUP_ID:ARTIFACT_ID:VERSION_OR_RANGE[:CLASSIFIER]', was: " + coordinates);
        }
        CoordinateBuilder coordinate = CoordinateBuilder.create().setGroupId(parts[0]).setArtifactId(parts[1]);
        Object version = null;
        version = parts[2].matches("\\*") ? new EmptyVersionRange() : (parts[2].matches("^(\\[|\\()[^,]+(,?[^,]+)+(\\]|\\))$") ? Versions.parseMultipleVersionRange((String)parts[2]) : new SingleVersionRange((Version)new SingleVersion(parts[2])));
        if (parts.length >= 4) {
            coordinate.setClassifier(parts[3]);
        }
        return new CoordinatePattern(coordinate, (VersionRange)version);
    }

    public static boolean isSkipped(ArchiveCoordinateModel coordinate) {
        return SkippedArchives.isSkipped((Coordinate)CoordinateBuilder.create().setArtifactId(coordinate.getArtifactId()).setGroupId(coordinate.getGroupId()).setClassifier(coordinate.getClassifier()).setVersion(coordinate.getVersion()));
    }

    public static boolean isSkipped(Coordinate coordinate) {
        for (Map.Entry<Coordinate, VersionRange> entry : map.entrySet()) {
            Coordinate pattern = entry.getKey();
            VersionRange range = entry.getValue();
            if (!SkippedArchives.isPatternMatch(pattern.getGroupId(), coordinate.getGroupId()) || !SkippedArchives.isPatternMatch(pattern.getArtifactId(), coordinate.getArtifactId()) || !SkippedArchives.isPatternMatch(pattern.getClassifier(), coordinate.getClassifier()) || !range.isEmpty() && !range.includes((Version)new SingleVersion(coordinate.getVersion()))) continue;
            return true;
        }
        return false;
    }

    private static boolean isPatternMatch(String pattern, String value) {
        if ("*".equals(pattern)) {
            return true;
        }
        if (pattern == value) {
            return true;
        }
        if (pattern != null && pattern.equals(value)) {
            return true;
        }
        return pattern != null && pattern.endsWith("*") && value != null && value.startsWith(pattern.substring(0, pattern.length() - 1));
    }

    public static int getCount() {
        return map.size();
    }

    private static class CoordinatePattern {
        private CoordinateBuilder coordinate;
        private VersionRange version;

        public CoordinatePattern(CoordinateBuilder coordinate, VersionRange version) {
            this.coordinate = coordinate;
            this.version = version;
        }

        public CoordinateBuilder getCoordinate() {
            return this.coordinate;
        }

        public VersionRange getVersion() {
            return this.version;
        }
    }
}

