/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.cl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.aesh.cl.exception.CommandLineParserException;
import org.jboss.aesh.cl.exception.OptionParserException;
import org.jboss.aesh.cl.internal.ProcessedOption;

public class CommandLine {
    private final List<ProcessedOption> options = new ArrayList<ProcessedOption>();
    private ProcessedOption argument;
    private boolean parserError;
    private CommandLineParserException parserException;

    public CommandLine() {
    }

    public CommandLine(CommandLineParserException parserException) {
        this();
        if (parserException != null) {
            this.setParserException(parserException);
        }
    }

    public void addOption(ProcessedOption option) {
        ProcessedOption existingOption = this.getOption(option.getName());
        if (existingOption == null) {
            this.options.add(option);
        } else if (existingOption.getProperties() == null || existingOption.getProperties().size() == 0 || option.getProperties() == null || existingOption.getProperties().size() == 0) {
            this.setParserError(true);
            this.setParserException(new OptionParserException("Not allowed to specify the same option (" + option.getDisplayName() + ") twice"));
        } else {
            existingOption.getProperties().putAll(option.getProperties());
        }
    }

    public List<ProcessedOption> getOptions() {
        return this.options;
    }

    public void addArgumentValue(String arg) {
        this.argument.addValue(arg);
    }

    public void setArgument(ProcessedOption argument) {
        this.argument = argument;
    }

    public ProcessedOption getArgument() {
        return this.argument;
    }

    public boolean hasOption(char name) {
        return this.hasOption(String.valueOf(name));
    }

    public ProcessedOption getOption(String name) {
        for (ProcessedOption po : this.options) {
            if ((po.getShortName() == null || !po.getShortName().equals(name)) && (po.getName() == null || !po.getName().equals(name))) continue;
            return po;
        }
        return null;
    }

    public boolean hasOption(String name) {
        for (ProcessedOption po : this.options) {
            if ((po.getShortName() == null || !po.getShortName().equals(name)) && !po.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public String getOptionValue(char c) {
        return this.getOptionValue(String.valueOf(c));
    }

    public String getOptionValue(String name) {
        return this.getOptionValue(name, null);
    }

    public String getOptionValue(String name, String fallback) {
        for (ProcessedOption po : this.options) {
            if ((po.getShortName() == null || !po.getShortName().equals(name)) && (po.getName() == null || !po.getName().equals(name))) continue;
            return po.getValue();
        }
        return fallback;
    }

    public List<String> getOptionValues(char c) {
        return this.getOptionValues(String.valueOf(c), new ArrayList<String>());
    }

    public List<String> getOptionValues(String name) {
        return this.getOptionValues(name, new ArrayList<String>());
    }

    public List<String> getOptionValues(String name, List<String> fallback) {
        for (ProcessedOption po : this.options) {
            if ((po.getShortName() == null || !po.getShortName().equals(name)) && (po.getName() == null || !po.getName().equals(name))) continue;
            return po.getValues();
        }
        return fallback;
    }

    public Map<String, String> getOptionProperties(String name) {
        for (ProcessedOption po : this.options) {
            if ((po.getShortName() == null || !po.getShortName().equals(name)) && (po.getName() == null || !po.getName().equals(name))) continue;
            return po.getProperties();
        }
        return new HashMap<String, String>();
    }

    public boolean hasParserError() {
        return this.parserError;
    }

    public void setParserError(boolean error) {
        this.parserError = error;
    }

    public CommandLineParserException getParserException() {
        return this.parserException;
    }

    public void setParserException(CommandLineParserException e) {
        this.parserException = e;
        if (this.parserException != null) {
            this.parserError = true;
        }
    }

    public boolean hasOptionWithOverrideRequired() {
        for (ProcessedOption option : this.options) {
            if (!option.doOverrideRequired()) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "CommandLine{options=" + this.options + ", argument=" + this.argument + ", parserError=" + this.parserError + ", parserException=" + this.parserException + '}';
    }
}

