/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.javaee.rules;

import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.Variables;
import org.jboss.windup.config.WindupRuleProvider;
import org.jboss.windup.config.operation.Iteration;
import org.jboss.windup.config.operation.ruleelement.AbstractIterationOperation;
import org.jboss.windup.config.phase.InitialAnalysis;
import org.jboss.windup.config.phase.RulePhase;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.model.resource.SourceFileModel;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.rules.apps.java.condition.JavaClass;
import org.jboss.windup.rules.apps.java.model.JavaClassFileModel;
import org.jboss.windup.rules.apps.java.model.JavaClassModel;
import org.jboss.windup.rules.apps.java.model.JavaSourceFileModel;
import org.jboss.windup.rules.apps.java.scan.ast.JavaAnnotationTypeReferenceModel;
import org.jboss.windup.rules.apps.java.scan.ast.JavaTypeReferenceModel;
import org.jboss.windup.rules.apps.java.scan.ast.TypeReferenceLocation;
import org.jboss.windup.rules.apps.java.scan.provider.AnalyzeJavaFilesRuleProvider;
import org.jboss.windup.rules.apps.javaee.model.EjbEntityBeanModel;
import org.jboss.windup.rules.apps.javaee.model.EjbMessageDrivenModel;
import org.jboss.windup.rules.apps.javaee.model.EjbSessionBeanModel;
import org.jboss.windup.util.Logging;
import org.ocpsoft.rewrite.config.Condition;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.config.ConfigurationBuilder;
import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.context.EvaluationContext;

public class DiscoverEjbAnnotationsRuleProvider
extends WindupRuleProvider {
    private static Logger LOG = Logging.get(DiscoverEjbAnnotationsRuleProvider.class);
    private static final String ENTITY_ANNOTATIONS = "entityAnnotations";
    private static final String TABLE_ANNOTATIONS_LIST = "tableAnnotations";

    public List<Class<? extends WindupRuleProvider>> getExecuteAfter() {
        return this.asClassList(new Class[]{AnalyzeJavaFilesRuleProvider.class});
    }

    public Class<? extends RulePhase> getPhase() {
        return InitialAnalysis.class;
    }

    public Configuration getConfiguration(GraphContext context) {
        String ruleIDPrefix = ((Object)((Object)this)).getClass().getSimpleName();
        return ConfigurationBuilder.begin().addRule().when((Condition)JavaClass.references((String)"javax.ejb.{annotationType}").at(new TypeReferenceLocation[]{TypeReferenceLocation.ANNOTATION})).perform((Operation)new AbstractIterationOperation<JavaTypeReferenceModel>(){

            public void perform(GraphRewrite event, EvaluationContext context, JavaTypeReferenceModel payload) {
                DiscoverEjbAnnotationsRuleProvider.this.extractEJBMetadata(event, payload);
            }
        }).where("annotationType").matches("Stateless|Stateful").withId(ruleIDPrefix + "_StatelessAndStatefulRule").addRule().when((Condition)JavaClass.references((String)"javax.ejb.MessageDriven").at(new TypeReferenceLocation[]{TypeReferenceLocation.ANNOTATION})).perform((Operation)new AbstractIterationOperation<JavaTypeReferenceModel>(){

            public void perform(GraphRewrite event, EvaluationContext context, JavaTypeReferenceModel payload) {
                DiscoverEjbAnnotationsRuleProvider.this.extractMessageDrivenMetadata(event, payload);
            }
        }).withId(ruleIDPrefix + "_MessageDrivenRule").addRule().when((Condition)JavaClass.references((String)"javax.persistence.Entity").at(new TypeReferenceLocation[]{TypeReferenceLocation.ANNOTATION}).as(ENTITY_ANNOTATIONS).or((Condition)JavaClass.references((String)"javax.persistence.Table").at(new TypeReferenceLocation[]{TypeReferenceLocation.ANNOTATION}).as(TABLE_ANNOTATIONS_LIST))).perform((Operation)Iteration.over((String)ENTITY_ANNOTATIONS).perform((Operation)new AbstractIterationOperation<JavaTypeReferenceModel>(){

            public void perform(GraphRewrite event, EvaluationContext context, JavaTypeReferenceModel payload) {
                DiscoverEjbAnnotationsRuleProvider.this.extractEntityBeanMetadata(event, payload);
            }
        }).endIteration()).withId(ruleIDPrefix + "_EntityBeanRule");
    }

    private void extractEJBMetadata(GraphRewrite event, JavaTypeReferenceModel javaTypeReference) {
        ((SourceFileModel)javaTypeReference.getFile()).setGenerateSourceReport(true);
        JavaAnnotationTypeReferenceModel annotationTypeReference = (JavaAnnotationTypeReferenceModel)javaTypeReference;
        JavaClassModel ejbClass = this.getJavaClass(javaTypeReference);
        String ejbName = (String)annotationTypeReference.getAnnotationValues().get("name");
        String sessionType = javaTypeReference.getSourceSnippit().substring(javaTypeReference.getSourceSnippit().lastIndexOf(".") + 1);
        GraphService sessionBeanService = new GraphService(event.getGraphContext(), EjbSessionBeanModel.class);
        EjbSessionBeanModel sessionBean = (EjbSessionBeanModel)sessionBeanService.create();
        sessionBean.setBeanName(ejbName);
        sessionBean.setEjbClass(ejbClass);
        sessionBean.setSessionType(sessionType);
    }

    private void extractEntityBeanMetadata(GraphRewrite event, JavaTypeReferenceModel entityTypeReference) {
        String tableName;
        ((SourceFileModel)entityTypeReference.getFile()).setGenerateSourceReport(true);
        JavaAnnotationTypeReferenceModel entityAnnotationTypeReference = (JavaAnnotationTypeReferenceModel)entityTypeReference;
        JavaAnnotationTypeReferenceModel tableAnnotationTypeReference = null;
        for (WindupVertexFrame annotationTypeReferenceBase : Variables.instance((GraphRewrite)event).findVariable(TABLE_ANNOTATIONS_LIST)) {
            JavaAnnotationTypeReferenceModel annotationTypeReference = (JavaAnnotationTypeReferenceModel)annotationTypeReferenceBase;
            if (!annotationTypeReference.getFile().equals(entityTypeReference.getFile())) continue;
            tableAnnotationTypeReference = annotationTypeReference;
            break;
        }
        JavaClassModel ejbClass = this.getJavaClass(entityTypeReference);
        String name = (String)entityAnnotationTypeReference.getAnnotationValues().get("name");
        if (name == null) {
            name = ejbClass.getClassName();
        }
        String string = tableName = tableAnnotationTypeReference == null ? name : (String)tableAnnotationTypeReference.getAnnotationValues().get("name");
        if (tableName == null) {
            tableName = name;
        }
        String persistenceType = "Container";
        GraphService entityBeanService = new GraphService(event.getGraphContext(), EjbEntityBeanModel.class);
        EjbEntityBeanModel entityBean = (EjbEntityBeanModel)entityBeanService.create();
        entityBean.setBeanName(name);
        entityBean.setEjbClass(ejbClass);
        entityBean.setTableName(tableName);
        entityBean.setPersistenceType(persistenceType);
    }

    private void extractMessageDrivenMetadata(GraphRewrite event, JavaTypeReferenceModel javaTypeReference) {
        ((SourceFileModel)javaTypeReference.getFile()).setGenerateSourceReport(true);
        JavaAnnotationTypeReferenceModel annotationTypeReference = (JavaAnnotationTypeReferenceModel)javaTypeReference;
        JavaClassModel ejbClass = this.getJavaClass(javaTypeReference);
        String ejbName = (String)annotationTypeReference.getAnnotationValues().get("name");
        String destination = (String)annotationTypeReference.getAnnotationValues().get("mappedName");
        if (StringUtils.isBlank((String)destination)) {
            String activationConfig = (String)annotationTypeReference.getAnnotationValues().get("activationConfig");
            Pattern p = Pattern.compile(".*propertyName[ \\t\\n]*=[ \\t\\n]*\"destination\"[ \\t\\n]*,[ \\t\\n]*propertyValue[ \\t\\n]*=[ \\t\\n]*\"(.*?)\".*");
            Matcher m = p.matcher(activationConfig);
            if (m.matches()) {
                destination = m.group(1);
            }
        }
        GraphService messageDrivenService = new GraphService(event.getGraphContext(), EjbMessageDrivenModel.class);
        EjbMessageDrivenModel messageDrivenBean = (EjbMessageDrivenModel)messageDrivenService.create();
        messageDrivenBean.setBeanName(ejbName);
        messageDrivenBean.setEjbClass(ejbClass);
        messageDrivenBean.setDestination(destination);
    }

    private JavaClassModel getJavaClass(JavaTypeReferenceModel javaTypeReference) {
        JavaClassModel result = null;
        FileModel originalFile = javaTypeReference.getFile();
        if (originalFile instanceof JavaSourceFileModel) {
            JavaSourceFileModel javaSource = (JavaSourceFileModel)originalFile;
            for (JavaClassModel javaClassModel : javaSource.getJavaClasses()) {
                if (javaClassModel.isPublic() == null || !javaClassModel.isPublic().booleanValue()) continue;
                result = javaClassModel;
                break;
            }
            if (result == null) {
                result = (JavaClassModel)javaSource.getJavaClasses().iterator().next();
            }
        } else if (originalFile instanceof JavaClassFileModel) {
            result = ((JavaClassFileModel)originalFile).getJavaClass();
        } else {
            LOG.warning("Unrecognized file type with annotation found at: \"" + originalFile.getFilePath() + "\"");
        }
        return result;
    }

    public String toString() {
        return "DiscoverEJBAnnotatedClasses";
    }
}

