/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.decompiler.procyon;

import com.strobel.assembler.InputTypeLoader;
import com.strobel.assembler.metadata.ClasspathTypeLoader;
import com.strobel.assembler.metadata.CompositeTypeLoader;
import com.strobel.assembler.metadata.IMetadataResolver;
import com.strobel.assembler.metadata.ITypeLoader;
import com.strobel.assembler.metadata.MetadataParser;
import com.strobel.assembler.metadata.MetadataSystem;
import com.strobel.assembler.metadata.NoRetryMetadataSystem;
import com.strobel.assembler.metadata.TypeDefinition;
import com.strobel.assembler.metadata.TypeReference;
import com.strobel.decompiler.DecompilationOptions;
import com.strobel.decompiler.DecompilerSettings;
import com.strobel.decompiler.ITextOutput;
import com.strobel.decompiler.PlainTextOutput;
import com.strobel.decompiler.languages.BytecodeLanguage;
import com.strobel.decompiler.languages.TypeDecompilationResults;
import com.strobel.decompiler.languages.java.JavaFormattingOptions;
import com.strobel.io.PathHelper;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import org.apache.commons.lang3.StringUtils;
import org.jboss.windup.decompiler.api.DecompilationException;
import org.jboss.windup.decompiler.api.DecompilationFailure;
import org.jboss.windup.decompiler.api.DecompilationListener;
import org.jboss.windup.decompiler.api.DecompilationResult;
import org.jboss.windup.decompiler.api.Decompiler;
import org.jboss.windup.decompiler.procyon.FileOutputWriter;
import org.jboss.windup.decompiler.procyon.LineNumberFormatter;
import org.jboss.windup.decompiler.procyon.ProcyonConfiguration;
import org.jboss.windup.decompiler.procyon.WindupJarTypeLoader;
import org.jboss.windup.decompiler.util.Filter;
import org.jboss.windup.util.Checks;
import org.jboss.windup.util.ExecutionStatistics;
import org.jboss.windup.util.exception.WindupException;

public class ProcyonDecompiler
implements Decompiler {
    private ExecutorService exService = Executors.newSingleThreadExecutor();
    private int numberOfThreads = 1;
    private static final Logger log = Logger.getLogger(ProcyonDecompiler.class.getName());
    private final ProcyonConfiguration procyonConf;

    public ProcyonDecompiler() {
        this.procyonConf = new ProcyonConfiguration();
    }

    public ProcyonDecompiler(ProcyonConfiguration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException("Configuration must not be null.");
        }
        this.procyonConf = configuration;
    }

    public void close() {
        this.exService.shutdown();
        try {
            this.exService.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Was not able to decompile in the given time limit.");
        }
    }

    public DecompilationResult decompileClassFile(File rootDir, Path classFilePath, File outputDir) throws DecompilationException {
        Checks.checkDirectoryToBeRead((File)rootDir, (String)"Classes root dir");
        File classFile = rootDir.toPath().resolve(classFilePath).toFile();
        Checks.checkFileToBeRead((File)classFile, (String)"Class file");
        Checks.checkDirectoryToBeFilled((File)outputDir, (String)"Output directory");
        log.info("Decompiling .class '" + classFilePath + "' to '" + outputDir.getPath() + "'");
        String name = classFilePath.toString();
        String typeName = StringUtils.removeEnd((String)name, (String)".class");
        DecompilationResult res = new DecompilationResult();
        try {
            DecompilerSettings settings = this.getDefaultSettings(outputDir);
            this.procyonConf.setDecompilerSettings(settings);
            CompositeTypeLoader typeLoader = new CompositeTypeLoader(new ITypeLoader[]{new ClasspathTypeLoader(rootDir.getPath()), new ClasspathTypeLoader()});
            MetadataSystem metadataSystem = new MetadataSystem((ITypeLoader)typeLoader);
            File outputFile = this.decompileType(metadataSystem, typeName);
            res.addDecompiled(classFilePath.toString(), outputFile.getAbsolutePath());
        }
        catch (Throwable e) {
            DecompilationFailure failure = new DecompilationFailure("Error during decompilation of " + classFilePath.toString() + ":\n    " + e.getMessage(), name, e);
            log.severe(failure.getMessage());
            res.addFailure(failure);
        }
        return res;
    }

    public DecompilationResult decompileDirectory(File rootDir, File outputDir) throws DecompilationException {
        log.info("Decompiling directory '" + rootDir.getAbsolutePath() + "' to '" + outputDir.getPath());
        DecompilationResult result = new DecompilationResult();
        Path subPath = Paths.get("", new String[0]);
        this.decompileDirectory(rootDir, outputDir, subPath, result);
        return result;
    }

    public void setExecutorService(ExecutorService service, int numberOfThreads) {
        this.exService.shutdown();
        try {
            this.exService.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Was not able to decompile in the given time limit.");
        }
        this.numberOfThreads = numberOfThreads;
        this.exService = service;
    }

    private void decompileDirectory(final File rootDir, File outputDir, Path subPath, final DecompilationResult result) throws DecompilationException {
        Checks.checkDirectoryToBeRead((File)rootDir, (String)"Directory to decompile");
        Checks.checkDirectoryToBeFilled((File)outputDir, (String)"Output directory");
        log.info("Decompiling subdir '" + subPath + "'");
        this.getDefaultSettings(outputDir);
        File curDirFull = rootDir.toPath().resolve(subPath).toFile();
        List<File> files = Arrays.asList(curDirFull.listFiles());
        ArrayList<1> tasks = new ArrayList<1>();
        for (File file : files) {
            final NoRetryMetadataSystem metadataSystem = new NoRetryMetadataSystem((ITypeLoader)new InputTypeLoader());
            if (file.isDirectory()) {
                Path subPathNew = subPath.resolve(file.getName());
                this.decompileDirectory(rootDir, outputDir, subPathNew, result);
                continue;
            }
            if (!file.getName().endsWith(".class") || file.getName().contains("$")) continue;
            final String fileSubPath = subPath.resolve(file.getName()).toString();
            final String fqcn = StringUtils.removeEnd((String)fileSubPath, (String)".class").replace('/', '.');
            final String fileAbsolutePath = file.getAbsolutePath();
            Callable<File> callable = new Callable<File>(){

                @Override
                public File call() throws Exception {
                    try {
                        File outputFile = ProcyonDecompiler.this.decompileType(metadataSystem, fqcn);
                        if (null == outputFile) {
                            throw new IllegalStateException("Unknown Procyon error, type not found.");
                        }
                        result.addDecompiled(fileAbsolutePath, outputFile.getAbsolutePath());
                        return outputFile;
                    }
                    catch (Exception e) {
                        DecompilationFailure failure = new DecompilationFailure("Error during decompilation of " + rootDir.getPath() + " / " + fileSubPath + ":\n    " + e.getMessage(), fileSubPath.toString(), (Throwable)e);
                        log.log(Level.SEVERE, failure.getMessage(), (Throwable)failure);
                        result.addFailure(failure);
                        return null;
                    }
                }
            };
            tasks.add(callable);
        }
        try {
            this.exService.invokeAll(tasks);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Was not able to decompile in the given time limit.");
        }
    }

    public DecompilationResult decompileArchive(File archive, File outputDir, DecompilationListener listener) throws DecompilationException {
        return this.decompileArchive(archive, outputDir, null, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DecompilationResult decompileArchive(final File archive, File outputDir, Filter<ZipEntry> filter, final DecompilationListener listener) throws DecompilationException {
        Checks.checkFileToBeRead((File)archive, (String)"Archive to decompile");
        Checks.checkDirectoryToBeFilled((File)outputDir, (String)"Output directory");
        log.info("Decompiling archive '" + archive.getAbsolutePath() + "' to '" + outputDir.getAbsolutePath() + "'");
        JarFile jar = this.loadJar(archive);
        try {
            final AtomicInteger jarEntryCount = new AtomicInteger(0);
            Enumeration<JarEntry> countEnum = jar.entries();
            while (countEnum.hasMoreElements()) {
                countEnum.nextElement();
                jarEntryCount.incrementAndGet();
            }
            final DecompilerSettings settings = this.getDefaultSettings(outputDir);
            settings.setTypeLoader((ITypeLoader)new CompositeTypeLoader(new ITypeLoader[]{new WindupJarTypeLoader(jar), settings.getTypeLoader()}));
            final DecompilationResult res = new DecompilationResult();
            Filter.Result filterRes = Filter.Result.ACCEPT;
            final AtomicInteger current = new AtomicInteger(0);
            Enumeration<JarEntry> entries = jar.entries();
            ArrayList<2> tasks = new ArrayList<2>();
            final LinkedList<MetadataSystem> metadataSystemCache = new LinkedList<MetadataSystem>();
            this.refreshMetadataCache(metadataSystemCache, settings);
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                if (filter != null) {
                    filterRes = filter.decide((Object)entry);
                }
                if (filterRes == Filter.Result.REJECT) {
                    jarEntryCount.decrementAndGet();
                    continue;
                }
                if (filterRes == Filter.Result.STOP) break;
                final String name = entry.getName();
                if (!name.endsWith(".class")) {
                    jarEntryCount.decrementAndGet();
                    continue;
                }
                final String typeName = StringUtils.removeEnd((String)name, (String)".class");
                Callable<File> callable = new Callable<File>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public File call() throws Exception {
                        MetadataSystem metadataSystem = null;
                        try {
                            Queue queue = metadataSystemCache;
                            synchronized (queue) {
                                if (current.incrementAndGet() % 50 == 0) {
                                    log.info("Decompiling " + current + " / " + jarEntryCount);
                                    ProcyonDecompiler.this.refreshMetadataCache(metadataSystemCache, settings);
                                }
                                metadataSystem = (MetadataSystem)metadataSystemCache.remove();
                            }
                            ExecutionStatistics.get().begin("ProcyonDecompiler.decompileIndividualItem");
                            DecompileExecutor t = new DecompileExecutor(metadataSystem, typeName);
                            t.start();
                            t.join(60000L);
                            if (!t.success) {
                                if (t.e == null) {
                                    t.cancelDecompilation();
                                    throw new RuntimeException("Failed to compile within one minute... attempting abort", t.e);
                                }
                                throw new RuntimeException(t.e);
                            }
                            File outputFile = t.outputFile;
                            if (outputFile != null) {
                                listener.fileDecompiled(name, outputFile.getAbsolutePath());
                                res.addDecompiled(name, outputFile.getAbsolutePath());
                            }
                            File file = outputFile;
                            return file;
                        }
                        catch (Throwable th) {
                            String msg = "Error during decompilation of " + archive.getPath() + "!" + name + ":\n    " + th.getMessage();
                            DecompilationFailure ex = new DecompilationFailure(msg, name, th);
                            log.log(Level.SEVERE, msg, (Throwable)ex);
                            res.addFailure(ex);
                        }
                        finally {
                            if (metadataSystem != null) {
                                Queue queue = metadataSystemCache;
                                synchronized (queue) {
                                    metadataSystemCache.add(metadataSystem);
                                }
                            }
                            ExecutionStatistics.get().end("ProcyonDecompiler.decompileIndividualItem");
                        }
                        return null;
                    }
                };
                tasks.add(callable);
            }
            try {
                this.exService.invokeAll(tasks);
            }
            catch (InterruptedException e) {
                throw new IllegalStateException("Decompilation was interrupted.");
            }
            finally {
                listener.decompilationProcessComplete();
            }
            DecompilationResult decompilationResult = res;
            return decompilationResult;
        }
        finally {
            try {
                jar.close();
            }
            catch (IOException e) {
                log.warning("Failed to close jar file: " + jar.getName());
            }
        }
    }

    private void refreshMetadataCache(Queue<MetadataSystem> metadataSystemCache, DecompilerSettings settings) {
        metadataSystemCache.clear();
        for (int i = 0; i < this.numberOfThreads; ++i) {
            metadataSystemCache.add(new NoRetryMetadataSystem(settings.getTypeLoader()));
        }
    }

    private File decompileType(MetadataSystem metadataSystem, String typeName) throws IOException {
        boolean nested;
        TypeReference type;
        log.fine("Decompiling " + typeName);
        if (typeName.length() == 1) {
            MetadataParser parser = new MetadataParser(IMetadataResolver.EMPTY);
            TypeReference reference = parser.parseTypeDescriptor(typeName);
            type = metadataSystem.resolve(reference);
        } else {
            type = metadataSystem.lookupType(typeName);
        }
        if (type == null) {
            log.severe("Failed to load class: " + typeName);
            return null;
        }
        TypeDefinition resolvedType = type.resolve();
        if (resolvedType == null) {
            log.severe("Failed to resolve type: " + typeName);
            return null;
        }
        boolean bl = nested = resolvedType.isNested() || resolvedType.isAnonymous() || resolvedType.isSynthetic();
        if (!this.procyonConf.isIncludeNested() && nested) {
            return null;
        }
        DecompilerSettings settings = this.procyonConf.getDecompilerSettings();
        settings.setFormattingOptions(new JavaFormattingOptions());
        FileOutputWriter writer = ProcyonDecompiler.createFileWriter(resolvedType, settings);
        PlainTextOutput output = new PlainTextOutput((Writer)writer);
        output.setUnicodeOutputEnabled(settings.isUnicodeOutputEnabled());
        if (settings.getLanguage() instanceof BytecodeLanguage) {
            output.setIndentToken("  ");
        }
        DecompilationOptions options = new DecompilationOptions();
        options.setSettings(settings);
        TypeDecompilationResults results = settings.getLanguage().decompileType(resolvedType, (ITextOutput)output, options);
        writer.flush();
        writer.close();
        List lineNumberPositions = results.getLineNumberPositions();
        if (!this.procyonConf.getLineNumberOptions().isEmpty()) {
            LineNumberFormatter lineFormatter = new LineNumberFormatter(writer.getFile(), lineNumberPositions, this.procyonConf.getLineNumberOptions());
            lineFormatter.reformatFile();
        }
        return writer.getFile();
    }

    private DecompilerSettings getDefaultSettings(File outputDir) {
        DecompilerSettings settings = this.procyonConf.getDecompilerSettings();
        if (settings == null) {
            settings = new DecompilerSettings();
            this.procyonConf.setDecompilerSettings(settings);
        }
        settings.setOutputDirectory(outputDir.getPath());
        settings.setShowSyntheticMembers(false);
        settings.setForceExplicitImports(true);
        if (settings.getTypeLoader() == null) {
            settings.setTypeLoader((ITypeLoader)new ClasspathTypeLoader());
        }
        return settings;
    }

    private JarFile loadJar(File archive) throws DecompilationException {
        JarFile jar;
        try {
            jar = new JarFile(archive);
        }
        catch (IOException ex) {
            throw new DecompilationException("Can't load .jar: " + archive.getPath(), (Throwable)ex);
        }
        return jar;
    }

    private static synchronized FileOutputWriter createFileWriter(TypeDefinition type, DecompilerSettings settings) throws IOException {
        String outputDirectory = settings.getOutputDirectory();
        String fileName = type.getName() + settings.getLanguage().getFileExtension();
        String packageName = type.getPackageName();
        String subDir = ((String)StringUtils.defaultIfEmpty((CharSequence)packageName, (CharSequence)"")).replace('.', File.separatorChar);
        String outputPath = PathHelper.combine((String)outputDirectory, (String)subDir, (String)fileName);
        File outputFile = new File(outputPath);
        File parentDir = outputFile.getParentFile();
        if (parentDir != null && !parentDir.exists() && !parentDir.mkdirs()) {
            throw new IllegalStateException("Could not create directory:" + parentDir);
        }
        if (!outputFile.exists() && !outputFile.createNewFile()) {
            throw new IllegalStateException("Could not create output file: " + outputPath);
        }
        return new FileOutputWriter(outputFile, settings);
    }

    private class DecompileExecutor
    extends Thread {
        private MetadataSystem metadataSystem;
        private String typeName;
        private Exception e;
        private File outputFile;
        private boolean success;

        public DecompileExecutor(MetadataSystem metadataSystem, String typeName) {
            this.metadataSystem = metadataSystem;
            this.typeName = typeName;
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                this.outputFile = ProcyonDecompiler.this.decompileType(this.metadataSystem, this.typeName);
                this.success = true;
            }
            catch (Exception e) {
                this.e = e;
            }
        }

        public void cancelDecompilation() {
            this.interrupt();
            for (int i = 0; i < 10; ++i) {
                if (!this.isAlive()) continue;
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException e) {
                    throw new WindupException("Interrupted while attempting to abort thread", (Throwable)e);
                }
            }
            if (this.isAlive()) {
                this.stop();
            }
        }
    }
}

