/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.code.cfg;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.java.decompiler.code.CodeConstants;
import org.jetbrains.java.decompiler.code.ExceptionHandler;
import org.jetbrains.java.decompiler.code.Instruction;
import org.jetbrains.java.decompiler.code.InstructionSequence;
import org.jetbrains.java.decompiler.code.JumpInstruction;
import org.jetbrains.java.decompiler.code.SwitchInstruction;
import org.jetbrains.java.decompiler.code.cfg.BasicBlock;
import org.jetbrains.java.decompiler.code.cfg.ExceptionRangeCFG;
import org.jetbrains.java.decompiler.code.interpreter.InstructionImpact;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.modules.code.DeadCodeHelper;
import org.jetbrains.java.decompiler.struct.StructMethod;
import org.jetbrains.java.decompiler.struct.consts.ConstantPool;
import org.jetbrains.java.decompiler.struct.gen.DataPoint;
import org.jetbrains.java.decompiler.struct.gen.VarType;
import org.jetbrains.java.decompiler.util.ListStack;
import org.jetbrains.java.decompiler.util.VBStyleCollection;

public class ControlFlowGraph
implements CodeConstants {
    public int last_id = 0;
    private VBStyleCollection<BasicBlock, Integer> blocks;
    private BasicBlock first;
    private BasicBlock last;
    private List<ExceptionRangeCFG> exceptions;
    private Map<BasicBlock, BasicBlock> subroutines;
    private Set<BasicBlock> finallyExits = new HashSet<BasicBlock>();

    public ControlFlowGraph(InstructionSequence seq) {
        this.buildBlocks(seq);
    }

    public void free() {
        for (BasicBlock block : this.blocks) {
            block.free();
        }
        this.blocks.clear();
        this.first = null;
        this.last = null;
        this.exceptions.clear();
        this.finallyExits.clear();
    }

    public void removeMarkers() {
        for (BasicBlock block : this.blocks) {
            block.mark = 0;
        }
    }

    public String toString() {
        if (this.blocks == null) {
            return "Empty";
        }
        String new_line_separator = DecompilerContext.getNewLineSeparator();
        StringBuilder buf = new StringBuilder();
        for (BasicBlock block : this.blocks) {
            int j;
            buf.append("----- Block ").append(block.id).append(" -----").append(new_line_separator);
            buf.append(block.toString());
            buf.append("----- Edges -----").append(new_line_separator);
            List<BasicBlock> suc = block.getSuccs();
            for (j = 0; j < suc.size(); ++j) {
                buf.append(">>>>>>>>(regular) Block ").append(suc.get((int)j).id).append(new_line_separator);
            }
            suc = block.getSuccExceptions();
            for (j = 0; j < suc.size(); ++j) {
                BasicBlock handler = suc.get(j);
                ExceptionRangeCFG range = this.getExceptionRange(handler, block);
                if (range == null) {
                    buf.append(">>>>>>>>(exception) Block ").append(handler.id).append("\t").append("ERROR: range not found!").append(new_line_separator);
                    continue;
                }
                List<String> exceptionTypes = range.getExceptionTypes();
                if (exceptionTypes == null) {
                    buf.append(">>>>>>>>(exception) Block ").append(handler.id).append("\t").append("NULL").append(new_line_separator);
                    continue;
                }
                for (String exceptionType : exceptionTypes) {
                    buf.append(">>>>>>>>(exception) Block ").append(handler.id).append("\t").append(exceptionType).append(new_line_separator);
                }
            }
            buf.append("----- ----- -----").append(new_line_separator);
        }
        return buf.toString();
    }

    public void inlineJsr(StructMethod mt) {
        this.processJsr();
        this.removeJsr(mt);
        this.removeMarkers();
        DeadCodeHelper.removeEmptyBlocks(this);
    }

    public void removeBlock(BasicBlock block) {
        while (block.getSuccs().size() > 0) {
            block.removeSuccessor(block.getSuccs().get(0));
        }
        while (block.getSuccExceptions().size() > 0) {
            block.removeSuccessorException(block.getSuccExceptions().get(0));
        }
        while (block.getPreds().size() > 0) {
            block.getPreds().get(0).removeSuccessor(block);
        }
        while (block.getPredExceptions().size() > 0) {
            block.getPredExceptions().get(0).removeSuccessorException(block);
        }
        this.last.removePredecessor(block);
        this.blocks.removeWithKey(block.id);
        for (int i = this.exceptions.size() - 1; i >= 0; --i) {
            ExceptionRangeCFG range = this.exceptions.get(i);
            if (range.getHandler() == block) {
                this.exceptions.remove(i);
                continue;
            }
            List<BasicBlock> lstRange = range.getProtectedRange();
            lstRange.remove(block);
            if (!lstRange.isEmpty()) continue;
            this.exceptions.remove(i);
        }
        Iterator<Map.Entry<BasicBlock, BasicBlock>> it = this.subroutines.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<BasicBlock, BasicBlock> ent = it.next();
            if (ent.getKey() != block && ent.getValue() != block) continue;
            it.remove();
        }
    }

    public ExceptionRangeCFG getExceptionRange(BasicBlock handler, BasicBlock block) {
        for (int i = this.exceptions.size() - 1; i >= 0; --i) {
            ExceptionRangeCFG range = this.exceptions.get(i);
            if (range.getHandler() != handler || !range.getProtectedRange().contains(block)) continue;
            return range;
        }
        return null;
    }

    private void buildBlocks(InstructionSequence instrseq) {
        short[] states = ControlFlowGraph.findStartInstructions(instrseq);
        HashMap<Integer, BasicBlock> mapInstrBlocks = new HashMap<Integer, BasicBlock>();
        VBStyleCollection<BasicBlock, Integer> colBlocks = this.createBasicBlocks(states, instrseq, mapInstrBlocks);
        this.blocks = colBlocks;
        ControlFlowGraph.connectBlocks(colBlocks, mapInstrBlocks);
        this.setExceptionEdges(instrseq, mapInstrBlocks);
        this.setSubroutineEdges();
        this.setFirstAndLastBlocks();
    }

    private static short[] findStartInstructions(InstructionSequence seq) {
        int len = seq.length();
        short[] inststates = new short[len];
        HashSet<Integer> excSet = new HashSet<Integer>();
        for (ExceptionHandler handler : seq.getExceptionTable().getHandlers()) {
            excSet.add(handler.from_instr);
            excSet.add(handler.to_instr);
            excSet.add(handler.handler_instr);
        }
        block6: for (int i = 0; i < len; ++i) {
            if (excSet.contains(new Integer(i))) {
                inststates[i] = 1;
            }
            Instruction instr = seq.getInstr(i);
            switch (instr.group) {
                case 2: {
                    inststates[((JumpInstruction)instr).destination] = 1;
                }
                case 6: {
                    if (i + 1 >= len) continue block6;
                    inststates[i + 1] = 1;
                    continue block6;
                }
                case 3: {
                    SwitchInstruction swinstr = (SwitchInstruction)instr;
                    int[] dests = swinstr.getDestinations();
                    for (int j = dests.length - 1; j >= 0; --j) {
                        inststates[dests[j]] = 1;
                    }
                    inststates[swinstr.getDefaultdest()] = 1;
                    if (i + 1 >= len) continue block6;
                    inststates[i + 1] = 1;
                }
            }
        }
        inststates[0] = 1;
        return inststates;
    }

    private VBStyleCollection<BasicBlock, Integer> createBasicBlocks(short[] startblock, InstructionSequence instrseq, Map<Integer, BasicBlock> mapInstrBlocks) {
        VBStyleCollection<BasicBlock, Integer> col = new VBStyleCollection<BasicBlock, Integer>();
        InstructionSequence currseq = null;
        List<Integer> lstOffs = null;
        int len = startblock.length;
        int counter = 0;
        int blockoffset = 0;
        BasicBlock currentBlock = null;
        for (int i = 0; i < len; ++i) {
            if (startblock[i] == 1) {
                counter = (short)(counter + 1);
                currentBlock = new BasicBlock(counter);
                currseq = currentBlock.getSeq();
                lstOffs = currentBlock.getInstrOldOffsets();
                col.addWithKey(currentBlock, currentBlock.id);
                blockoffset = instrseq.getOffset(i);
            }
            startblock[i] = counter;
            mapInstrBlocks.put(i, currentBlock);
            currseq.addInstruction(instrseq.getInstr(i), instrseq.getOffset(i) - blockoffset);
            lstOffs.add(instrseq.getOffset(i));
        }
        this.last_id = counter;
        return col;
    }

    private static void connectBlocks(List<BasicBlock> lstbb, Map<Integer, BasicBlock> mapInstrBlocks) {
        for (int i = 0; i < lstbb.size(); ++i) {
            BasicBlock block = lstbb.get(i);
            Instruction instr = block.getLastInstruction();
            boolean fallthrough = instr.canFallthrough();
            switch (instr.group) {
                case 2: {
                    int dest = ((JumpInstruction)instr).destination;
                    BasicBlock bTemp = mapInstrBlocks.get(dest);
                    block.addSuccessor(bTemp);
                    break;
                }
                case 3: {
                    SwitchInstruction sinstr = (SwitchInstruction)instr;
                    int[] dests = sinstr.getDestinations();
                    BasicBlock bTemp = mapInstrBlocks.get(((SwitchInstruction)instr).getDefaultdest());
                    block.addSuccessor(bTemp);
                    for (int j = 0; j < dests.length; ++j) {
                        bTemp = mapInstrBlocks.get(dests[j]);
                        block.addSuccessor(bTemp);
                    }
                    break;
                }
            }
            if (!fallthrough || i >= lstbb.size() - 1) continue;
            BasicBlock defaultBlock = lstbb.get(i + 1);
            block.addSuccessor(defaultBlock);
        }
    }

    private void setExceptionEdges(InstructionSequence instrseq, Map<Integer, BasicBlock> instrBlocks) {
        this.exceptions = new ArrayList<ExceptionRangeCFG>();
        HashMap<String, ExceptionRangeCFG> mapRanges = new HashMap<String, ExceptionRangeCFG>();
        for (ExceptionHandler handler : instrseq.getExceptionTable().getHandlers()) {
            BasicBlock from = instrBlocks.get(handler.from_instr);
            BasicBlock to = instrBlocks.get(handler.to_instr);
            BasicBlock handle = instrBlocks.get(handler.handler_instr);
            String key = from.id + ":" + to.id + ":" + handle.id;
            if (mapRanges.containsKey(key)) {
                ExceptionRangeCFG range = (ExceptionRangeCFG)mapRanges.get(key);
                range.addExceptionType(handler.exceptionClass);
                continue;
            }
            ArrayList<BasicBlock> protectedRange = new ArrayList<BasicBlock>();
            for (int j = from.id; j < to.id; ++j) {
                BasicBlock block = this.blocks.getWithKey(j);
                protectedRange.add(block);
                block.addSuccessorException(handle);
            }
            ExceptionRangeCFG range = new ExceptionRangeCFG(protectedRange, handle, handler.exceptionClass == null ? null : Collections.singletonList(handler.exceptionClass));
            mapRanges.put(key, range);
            this.exceptions.add(range);
        }
    }

    private void setSubroutineEdges() {
        HashMap<BasicBlock, BasicBlock> subroutines = new HashMap<BasicBlock, BasicBlock>();
        for (BasicBlock block : this.blocks) {
            if (block.getSeq().getLastInstr().opcode != 168) continue;
            LinkedList<BasicBlock> stack = new LinkedList<BasicBlock>();
            LinkedList stackJsrStacks = new LinkedList();
            HashSet<BasicBlock> setVisited = new HashSet<BasicBlock>();
            stack.add(block);
            stackJsrStacks.add(new LinkedList());
            while (!stack.isEmpty()) {
                BasicBlock node = (BasicBlock)stack.removeFirst();
                LinkedList jsrstack = (LinkedList)stackJsrStacks.removeFirst();
                setVisited.add(node);
                switch (node.getSeq().getLastInstr().opcode) {
                    case 168: {
                        jsrstack.add(node);
                        break;
                    }
                    case 169: {
                        BasicBlock enter = (BasicBlock)jsrstack.getLast();
                        BasicBlock exit = this.blocks.getWithKey(enter.id + 1);
                        if (exit != null) {
                            if (!node.isSuccessor(exit)) {
                                node.addSuccessor(exit);
                            }
                            jsrstack.removeLast();
                            subroutines.put(enter, exit);
                            break;
                        }
                        throw new RuntimeException("ERROR: last instruction jsr");
                    }
                }
                if (jsrstack.isEmpty()) continue;
                for (BasicBlock succ : node.getSuccs()) {
                    if (setVisited.contains(succ)) continue;
                    stack.add(succ);
                    stackJsrStacks.add(new LinkedList(jsrstack));
                }
            }
        }
        this.subroutines = subroutines;
    }

    private void processJsr() {
        while (this.processJsrRanges() != 0) {
        }
    }

    private int processJsrRanges() {
        ArrayList<JsrRecord> lstJsrAll = new ArrayList<JsrRecord>();
        for (Map.Entry<BasicBlock, BasicBlock> ent : this.subroutines.entrySet()) {
            BasicBlock jsr = ent.getKey();
            BasicBlock ret = ent.getValue();
            lstJsrAll.add(new JsrRecord(jsr, this.getJsrRange(jsr, ret), ret));
        }
        ArrayList<JsrRecord> lstJsr = new ArrayList<JsrRecord>();
        for (JsrRecord arr : lstJsrAll) {
            JsrRecord arrJsr;
            int i;
            for (i = 0; i < lstJsr.size() && !(arrJsr = (JsrRecord)lstJsr.get(i)).range.contains(arr.jsr); ++i) {
            }
            lstJsr.add(i, arr);
        }
        for (int i = 0; i < lstJsr.size(); ++i) {
            JsrRecord arr;
            arr = (JsrRecord)lstJsr.get(i);
            Set set = arr.range;
            for (int j = i + 1; j < lstJsr.size(); ++j) {
                JsrRecord arr1 = (JsrRecord)lstJsr.get(j);
                Set set1 = arr1.range;
                if (set.contains(arr1.jsr) || set1.contains(arr.jsr)) continue;
                HashSet<BasicBlock> setc = new HashSet<BasicBlock>(set);
                setc.retainAll(set1);
                if (setc.isEmpty()) continue;
                this.splitJsrRange(arr.jsr, arr.ret, setc);
                return 1;
            }
        }
        return 0;
    }

    private Set<BasicBlock> getJsrRange(BasicBlock jsr, BasicBlock ret) {
        HashSet<BasicBlock> blocks = new HashSet<BasicBlock>();
        LinkedList<BasicBlock> lstNodes = new LinkedList<BasicBlock>();
        lstNodes.add(jsr);
        BasicBlock dom = jsr.getSuccs().get(0);
        while (!lstNodes.isEmpty()) {
            BasicBlock node = (BasicBlock)lstNodes.remove(0);
            for (int j = 0; j < 2; ++j) {
                List<BasicBlock> lst;
                if (j == 0) {
                    if (node.getLastInstruction().opcode == 169 && node.getSuccs().contains(ret)) continue;
                    lst = node.getSuccs();
                } else {
                    if (node == jsr) continue;
                    lst = node.getSuccExceptions();
                }
                block2: for (int i = lst.size() - 1; i >= 0; --i) {
                    BasicBlock child = lst.get(i);
                    if (blocks.contains(child)) continue;
                    if (node != jsr) {
                        int k;
                        for (k = 0; k < child.getPreds().size(); ++k) {
                            if (!DeadCodeHelper.isDominator(this, child.getPreds().get(k), dom)) continue block2;
                        }
                        for (k = 0; k < child.getPredExceptions().size(); ++k) {
                            if (!DeadCodeHelper.isDominator(this, child.getPredExceptions().get(k), dom)) continue block2;
                        }
                    }
                    if (child != this.last) {
                        blocks.add(child);
                    }
                    lstNodes.add(child);
                }
            }
        }
        return blocks;
    }

    private void splitJsrRange(BasicBlock jsr, BasicBlock ret, Set<BasicBlock> common_blocks) {
        LinkedList<BasicBlock> lstNodes = new LinkedList<BasicBlock>();
        HashMap<Integer, BasicBlock> mapNewNodes = new HashMap<Integer, BasicBlock>();
        lstNodes.add(jsr);
        mapNewNodes.put(jsr.id, jsr);
        while (!lstNodes.isEmpty()) {
            BasicBlock node = (BasicBlock)lstNodes.remove(0);
            for (int j = 0; j < 2; ++j) {
                List<BasicBlock> lst;
                if (j == 0) {
                    if (node.getLastInstruction().opcode == 169 && node.getSuccs().contains(ret)) continue;
                    lst = node.getSuccs();
                } else {
                    if (node == jsr) continue;
                    lst = node.getSuccExceptions();
                }
                for (int i = lst.size() - 1; i >= 0; --i) {
                    BasicBlock child = lst.get(i);
                    Integer childid = child.id;
                    if (mapNewNodes.containsKey(childid)) {
                        node.replaceSuccessor(child, (BasicBlock)mapNewNodes.get(childid));
                        continue;
                    }
                    if (common_blocks.contains(child)) {
                        int k;
                        BasicBlock copy = (BasicBlock)child.clone();
                        copy.id = ++this.last_id;
                        if (copy.getLastInstruction().opcode == 169 && child.getSuccs().contains(ret)) {
                            copy.addSuccessor(ret);
                            child.removeSuccessor(ret);
                        } else {
                            for (k = 0; k < child.getSuccs().size(); ++k) {
                                copy.addSuccessor(child.getSuccs().get(k));
                            }
                        }
                        for (k = 0; k < child.getSuccExceptions().size(); ++k) {
                            copy.addSuccessorException(child.getSuccExceptions().get(k));
                        }
                        lstNodes.add(copy);
                        mapNewNodes.put(childid, copy);
                        if (this.last.getPreds().contains(child)) {
                            this.last.addPredecessor(copy);
                        }
                        node.replaceSuccessor(child, copy);
                        this.blocks.addWithKey(copy, copy.id);
                        continue;
                    }
                    mapNewNodes.put(childid, child);
                }
            }
        }
        this.splitJsrExceptionRanges(common_blocks, mapNewNodes);
    }

    private void splitJsrExceptionRanges(Set<BasicBlock> common_blocks, Map<Integer, BasicBlock> mapNewNodes) {
        for (int i = this.exceptions.size() - 1; i >= 0; --i) {
            List<BasicBlock> lstNewRange;
            ExceptionRangeCFG range = this.exceptions.get(i);
            List<BasicBlock> lstRange = range.getProtectedRange();
            HashSet<BasicBlock> setBoth = new HashSet<BasicBlock>(common_blocks);
            setBoth.retainAll(lstRange);
            if (setBoth.size() <= 0) continue;
            if (setBoth.size() == lstRange.size()) {
                lstNewRange = new ArrayList<BasicBlock>();
                ExceptionRangeCFG newRange = new ExceptionRangeCFG(lstNewRange, mapNewNodes.get(range.getHandler().id), range.getExceptionTypes());
                this.exceptions.add(newRange);
            } else {
                lstNewRange = lstRange;
            }
            for (BasicBlock block : setBoth) {
                lstNewRange.add(mapNewNodes.get(block.id));
            }
        }
    }

    private void removeJsr(StructMethod mt) {
        ControlFlowGraph.removeJsrInstructions(mt.getClassStruct().getPool(), this.first, DataPoint.getInitialDataPoint(mt));
    }

    private static void removeJsrInstructions(ConstantPool pool, BasicBlock block, DataPoint data) {
        BasicBlock suc;
        int i;
        ListStack<VarType> stack = data.getStack();
        InstructionSequence seq = block.getSeq();
        block4: for (i = 0; i < seq.length(); ++i) {
            Instruction instr = seq.getInstr(i);
            VarType var = null;
            if (instr.opcode == 58 || instr.opcode == 87) {
                var = stack.getByOffset(-1);
            }
            InstructionImpact.stepTypes(data, instr, pool);
            switch (instr.opcode) {
                case 168: 
                case 169: {
                    seq.removeInstruction(i);
                    --i;
                    continue block4;
                }
                case 58: 
                case 87: {
                    if (var.type != 9) continue block4;
                    seq.removeInstruction(i);
                    --i;
                }
            }
        }
        block.mark = 1;
        for (i = 0; i < block.getSuccs().size(); ++i) {
            suc = block.getSuccs().get(i);
            if (suc.mark == 1) continue;
            ControlFlowGraph.removeJsrInstructions(pool, suc, data.copy());
        }
        for (i = 0; i < block.getSuccExceptions().size(); ++i) {
            suc = block.getSuccExceptions().get(i);
            if (suc.mark == 1) continue;
            DataPoint point = new DataPoint();
            point.setLocalVariables(new ArrayList<VarType>(data.getLocalVariables()));
            point.getStack().push(new VarType(8, 0, null));
            ControlFlowGraph.removeJsrInstructions(pool, suc, point);
        }
    }

    private void setFirstAndLastBlocks() {
        this.first = (BasicBlock)this.blocks.get(0);
        this.last = new BasicBlock(++this.last_id);
        for (BasicBlock block : this.blocks) {
            if (!block.getSuccs().isEmpty()) continue;
            this.last.addPredecessor(block);
        }
    }

    public List<BasicBlock> getReversePostOrder() {
        LinkedList<BasicBlock> res = new LinkedList<BasicBlock>();
        ControlFlowGraph.addToReversePostOrderListIterative(this.first, res);
        return res;
    }

    private static void addToReversePostOrderListIterative(BasicBlock root, List<BasicBlock> lst) {
        LinkedList<BasicBlock> stackNode = new LinkedList<BasicBlock>();
        LinkedList<Integer> stackIndex = new LinkedList<Integer>();
        HashSet<BasicBlock> setVisited = new HashSet<BasicBlock>();
        stackNode.add(root);
        stackIndex.add(0);
        while (!stackNode.isEmpty()) {
            int index;
            BasicBlock node = (BasicBlock)stackNode.getLast();
            setVisited.add(node);
            ArrayList<BasicBlock> lstSuccs = new ArrayList<BasicBlock>(node.getSuccs());
            lstSuccs.addAll(node.getSuccExceptions());
            for (index = ((Integer)stackIndex.removeLast()).intValue(); index < lstSuccs.size(); ++index) {
                BasicBlock succ = (BasicBlock)lstSuccs.get(index);
                if (setVisited.contains(succ)) continue;
                stackIndex.add(index + 1);
                stackNode.add(succ);
                stackIndex.add(0);
                break;
            }
            if (index != lstSuccs.size()) continue;
            lst.add(0, node);
            stackNode.removeLast();
        }
    }

    public VBStyleCollection<BasicBlock, Integer> getBlocks() {
        return this.blocks;
    }

    public void setBlocks(VBStyleCollection<BasicBlock, Integer> blocks) {
        this.blocks = blocks;
    }

    public BasicBlock getFirst() {
        return this.first;
    }

    public void setFirst(BasicBlock first) {
        this.first = first;
    }

    public List<BasicBlock> getEndBlocks() {
        return this.last.getPreds();
    }

    public List<ExceptionRangeCFG> getExceptions() {
        return this.exceptions;
    }

    public void setExceptions(List<ExceptionRangeCFG> exceptions) {
        this.exceptions = exceptions;
    }

    public BasicBlock getLast() {
        return this.last;
    }

    public void setLast(BasicBlock last) {
        this.last = last;
    }

    public Map<BasicBlock, BasicBlock> getSubroutines() {
        return this.subroutines;
    }

    public void setSubroutines(Map<BasicBlock, BasicBlock> subroutines) {
        this.subroutines = subroutines;
    }

    public Set<BasicBlock> getFinallyExits() {
        return this.finallyExits;
    }

    public void setFinallyExits(HashSet<BasicBlock> finallyExits) {
        this.finallyExits = finallyExits;
    }

    private static class JsrRecord {
        private final BasicBlock jsr;
        private final Set<BasicBlock> range;
        private final BasicBlock ret;

        private JsrRecord(BasicBlock jsr, Set<BasicBlock> range, BasicBlock ret) {
            this.jsr = jsr;
            this.range = range;
            this.ret = ret;
        }
    }
}

