/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.javaee.rules;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.metadata.MetadataBuilder;
import org.jboss.windup.config.metadata.RuleProviderMetadata;
import org.jboss.windup.config.phase.InitialAnalysisPhase;
import org.jboss.windup.config.query.Query;
import org.jboss.windup.config.ruleprovider.IteratingRuleProvider;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.reporting.model.TechnologyTagLevel;
import org.jboss.windup.reporting.service.TechnologyTagService;
import org.jboss.windup.rules.apps.java.model.JavaClassModel;
import org.jboss.windup.rules.apps.java.service.JavaClassService;
import org.jboss.windup.rules.apps.javaee.model.JNDIResourceModel;
import org.jboss.windup.rules.apps.javaee.model.SpringBeanModel;
import org.jboss.windup.rules.apps.javaee.model.SpringConfigurationFileModel;
import org.jboss.windup.rules.apps.javaee.model.association.JNDIReferenceModel;
import org.jboss.windup.rules.apps.javaee.service.JNDIResourceService;
import org.jboss.windup.rules.apps.javaee.service.SpringBeanService;
import org.jboss.windup.rules.apps.javaee.service.SpringConfigurationFileService;
import org.jboss.windup.rules.apps.xml.model.XmlFileModel;
import org.jboss.windup.rules.apps.xml.service.XmlFileService;
import org.joox.Filter;
import org.joox.JOOX;
import org.ocpsoft.rewrite.config.ConditionBuilder;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DiscoverSpringConfigurationFilesRuleProvider
extends IteratingRuleProvider<XmlFileModel> {
    private static final Logger LOG = Logger.getLogger(DiscoverSpringConfigurationFilesRuleProvider.class.getSimpleName());
    private static final String TECH_TAG = "Spring XML";
    private static final TechnologyTagLevel TECH_TAG_LEVEL = TechnologyTagLevel.IMPORTANT;

    public DiscoverSpringConfigurationFilesRuleProvider() {
        super((RuleProviderMetadata)MetadataBuilder.forProvider(DiscoverSpringConfigurationFilesRuleProvider.class).setPhase(InitialAnalysisPhase.class));
    }

    public String toStringPerform() {
        return "Discover Spring Config Files";
    }

    public ConditionBuilder when() {
        return Query.fromType(XmlFileModel.class).withProperty("rootTagName", (Object)"beans");
    }

    public void perform(GraphRewrite event, EvaluationContext context, XmlFileModel payload) {
        JavaClassModel classReference;
        SpringBeanModel springBeanRef;
        String id;
        String id2;
        JavaClassService javaClassService = new JavaClassService(event.getGraphContext());
        XmlFileService xmlFileService = new XmlFileService(event.getGraphContext());
        TechnologyTagService technologyTagService = new TechnologyTagService(event.getGraphContext());
        SpringConfigurationFileService springConfigurationFileService = new SpringConfigurationFileService(event.getGraphContext());
        SpringBeanService springBeanService = new SpringBeanService(event.getGraphContext());
        JNDIResourceService jndiResourceService = new JNDIResourceService(event.getGraphContext());
        Document doc = xmlFileService.loadDocumentQuiet(payload);
        if (doc == null) {
            return;
        }
        List beansElements = JOOX.$((Document)doc).namespace("s", "http://www.springframework.org/schema/beans").xpath("/s:beans").get();
        if (beansElements.size() == 0) {
            LOG.log(Level.WARNING, "Found [beans] XML without namespace at: " + payload.getFilePath() + ".");
            return;
        }
        technologyTagService.addTagToFileModel((FileModel)payload, TECH_TAG, TECH_TAG_LEVEL);
        Element element = (Element)beansElements.get(0);
        SpringConfigurationFileModel springConfigurationModel = (SpringConfigurationFileModel)springConfigurationFileService.addTypeToModel((WindupVertexFrame)payload);
        List beans = JOOX.$((Element)element).children("bean").get();
        for (Element bean : beans) {
            String clz = JOOX.$((Element)bean).attr("class");
            id2 = JOOX.$((Element)bean).attr("id");
            String name = JOOX.$((Element)bean).attr("name");
            if (StringUtils.isBlank((String)id2) && StringUtils.isNotBlank((String)name)) {
                id2 = name;
            }
            if (StringUtils.isBlank((String)clz)) {
                LOG.log(Level.WARNING, "Spring Bean did not include class:" + JOOX.$((Element)bean).toString());
                continue;
            }
            SpringBeanModel springBeanRef2 = (SpringBeanModel)springBeanService.create();
            if (StringUtils.isNotBlank((String)id2)) {
                springBeanRef2.setSpringBeanName(id2);
            }
            JavaClassModel classReference2 = javaClassService.getOrCreatePhantom(clz);
            springBeanRef2.setJavaClass(classReference2);
            springConfigurationModel.addSpringBeanReference(springBeanRef2);
            if (!StringUtils.isNotBlank((String)clz) || !StringUtils.equals((String)"org.springframework.jndi.JndiObjectFactoryBean", (String)clz)) continue;
            String expectedType = JOOX.$((Element)bean).children("property").filter((Filter)JOOX.attr((String)"name", (String[])new String[]{"expectedType"})).first().attr("value");
            String jndiName = JOOX.$((Element)bean).children("property").filter((Filter)JOOX.attr((String)"name", (String[])new String[]{"jndiName"})).first().attr("value");
            LOG.info("Found JNDI in Bean Spring: " + jndiName);
            if (!StringUtils.isNotBlank((String)jndiName)) continue;
            JNDIResourceModel jndiResource = jndiResourceService.createUnique(jndiName);
            if (StringUtils.isNotBlank((String)expectedType)) {
                LOG.info(" -- Type: " + expectedType);
                jndiResourceService.associateTypeJndiResource(jndiResource, expectedType);
            }
            JNDIReferenceModel reference = (JNDIReferenceModel)GraphService.addTypeToModel((GraphContext)event.getGraphContext(), (WindupVertexFrame)springBeanRef2, JNDIReferenceModel.class);
            reference.setJndiReference(jndiResource);
        }
        for (Element map : JOOX.$((Element)element).children("map").get()) {
            id = JOOX.$((Element)map).attr("id");
            springBeanRef = (SpringBeanModel)springBeanService.create();
            springBeanRef.setSpringBeanName(id);
            springConfigurationModel.addSpringBeanReference(springBeanRef);
            classReference = javaClassService.getOrCreatePhantom("java.util.Map");
            springBeanRef.setJavaClass(classReference);
        }
        for (Element map : JOOX.$((Element)element).children("set").get()) {
            id = JOOX.$((Element)map).attr("id");
            springBeanRef = (SpringBeanModel)springBeanService.create();
            springBeanRef.setSpringBeanName(id);
            springConfigurationModel.addSpringBeanReference(springBeanRef);
            classReference = javaClassService.getOrCreatePhantom("java.util.Set");
            springBeanRef.setJavaClass(classReference);
        }
        List jndis = JOOX.$((Element)element).children("jndi-lookup").get();
        if (jndis.size() > 0) {
            for (Element jndi : jndis) {
                id2 = JOOX.$((Element)jndi).attr("id");
                String jndiName = JOOX.$((Element)jndi).attr("jndi-name");
                String expectedType = JOOX.$((Element)jndi).attr("expected-type");
                LOG.info("Found JNDI in JEE Spring: " + jndiName);
                SpringBeanModel springBeanRef3 = (SpringBeanModel)springBeanService.create();
                springBeanRef3.setSpringBeanName(id2);
                JNDIResourceModel jndiResource = null;
                if (StringUtils.isNotBlank((String)jndiName)) {
                    jndiResource = jndiResourceService.createUnique(jndiName);
                    if (StringUtils.isNotBlank((String)expectedType)) {
                        LOG.info(" -- Type: " + expectedType);
                        jndiResourceService.associateTypeJndiResource(jndiResource, expectedType);
                    }
                    JNDIReferenceModel reference = (JNDIReferenceModel)GraphService.addTypeToModel((GraphContext)event.getGraphContext(), (WindupVertexFrame)springBeanRef3, JNDIReferenceModel.class);
                    reference.setJndiReference(jndiResource);
                }
                String clz = "org.springframework.jndi.JndiObjectFactoryBean";
                JavaClassModel classReference3 = javaClassService.getOrCreatePhantom("org.springframework.jndi.JndiObjectFactoryBean");
                springBeanRef3.setJavaClass(classReference3);
                springConfigurationModel.addSpringBeanReference(springBeanRef3);
            }
        }
    }
}

