/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.ip;

import org.jboss.windup.config.AbstractRuleProvider;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.metadata.MetadataBuilder;
import org.jboss.windup.config.metadata.RuleProviderMetadata;
import org.jboss.windup.config.operation.iteration.AbstractIterationOperation;
import org.jboss.windup.config.phase.MigrationRulesPhase;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.rules.apps.java.ip.StaticIPLocationModel;
import org.jboss.windup.rules.files.condition.FileContent;
import org.jboss.windup.rules.files.model.FileLocationModel;
import org.ocpsoft.rewrite.config.Condition;
import org.ocpsoft.rewrite.config.Configuration;
import org.ocpsoft.rewrite.config.ConfigurationBuilder;
import org.ocpsoft.rewrite.config.Operation;
import org.ocpsoft.rewrite.context.EvaluationContext;

public class DiscoverStaticIPAddressRuleProvider
extends AbstractRuleProvider {
    public DiscoverStaticIPAddressRuleProvider() {
        super((RuleProviderMetadata)MetadataBuilder.forProvider(DiscoverStaticIPAddressRuleProvider.class).setPhase(MigrationRulesPhase.class));
    }

    public Configuration getConfiguration(GraphContext context) {
        return ConfigurationBuilder.begin().addRule().when((Condition)FileContent.matches((String)"{ip}").inFilesNamed("{*}.{type}")).perform((Operation)new AbstractIterationOperation<FileLocationModel>(){

            public void perform(GraphRewrite event, EvaluationContext context, FileLocationModel payload) {
                StaticIPLocationModel location = (StaticIPLocationModel)GraphService.addTypeToModel((GraphContext)event.getGraphContext(), (WindupVertexFrame)payload, StaticIPLocationModel.class);
                location.setTitle("Static IP: " + location.getSourceSnippit());
                location.setHint("When migrating environments, static IP addresses may need to be modified or eliminated.");
                location.setEffort(0);
            }
        }).where("ip").matches("\\b\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\b").where("type").matches("java|properties|xml");
    }
}

