/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.ui.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jboss.forge.addon.ui.context.UISelection;
import org.jboss.forge.furnace.util.Lists;

public final class Selections {
    public static <SELECTIONTYPE> UISelection<SELECTIONTYPE> from(SELECTIONTYPE ... type) {
        if (type == null || type.length == 0 || type[0] == null) {
            return Selections.emptySelection();
        }
        if (type.length == 1 && type[0] instanceof Iterable) {
            return new SelectionImpl((Iterable)type[0]);
        }
        return new SelectionImpl<SELECTIONTYPE>(type);
    }

    public static <SELECTIONTYPE> UISelection<SELECTIONTYPE> from(Iterable<SELECTIONTYPE> type) {
        if (type == null || Lists.toList(type).isEmpty()) {
            return Selections.emptySelection();
        }
        return new SelectionImpl<SELECTIONTYPE>(type);
    }

    public static <SELECTIONTYPE> UISelection<SELECTIONTYPE> emptySelection() {
        return EmptySelection.INSTANCE;
    }

    private static enum EmptySelection implements UISelection<Object>
    {
        INSTANCE;


        @Override
        public Iterator<Object> iterator() {
            return Collections.emptyList().iterator();
        }

        @Override
        public Object get() {
            return null;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }
    }

    private static class SelectionImpl<SELECTIONTYPE>
    implements UISelection<SELECTIONTYPE> {
        private final List<SELECTIONTYPE> selection;

        public SelectionImpl(SELECTIONTYPE ... type) {
            this.selection = type != null ? Arrays.asList(type) : Collections.emptyList();
        }

        public SelectionImpl(Iterable<SELECTIONTYPE> type) {
            this.selection = type != null ? Lists.toList(type) : Collections.emptyList();
        }

        @Override
        public Iterator<SELECTIONTYPE> iterator() {
            return this.selection.iterator();
        }

        @Override
        public SELECTIONTYPE get() {
            return this.selection.isEmpty() ? null : (SELECTIONTYPE)this.selection.get(0);
        }

        @Override
        public int size() {
            return this.selection.size();
        }

        @Override
        public boolean isEmpty() {
            return this.selection.isEmpty();
        }
    }
}

