/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.oupls.sail.pg;

import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.oupls.sail.pg.PropertyGraphSail;
import info.aduna.iteration.CloseableIteration;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import net.fortytwo.sesametools.SailConnectionTripleSource;
import org.openrdf.model.Literal;
import org.openrdf.model.Namespace;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.NamespaceImpl;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.XMLSchema;
import org.openrdf.query.BindingSet;
import org.openrdf.query.Dataset;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.algebra.TupleExpr;
import org.openrdf.query.algebra.UpdateExpr;
import org.openrdf.query.algebra.evaluation.TripleSource;
import org.openrdf.query.algebra.evaluation.impl.EvaluationStrategyImpl;
import org.openrdf.sail.SailConnection;
import org.openrdf.sail.SailException;
import org.openrdf.sail.helpers.SailBase;
import org.openrdf.sail.helpers.SailConnectionBase;

class PropertyGraphSailConnection
extends SailConnectionBase {
    private static final Map<String, Namespace> namespaces = new HashMap<String, Namespace>();
    private final PropertyGraphSail.PropertyGraphContext context;
    private boolean open = true;
    private final ElementGenerator<Vertex> allVertexStatements;
    private final ElementGenerator<Vertex> vertexIds;
    private final ElementGenerator<Vertex> vertexProps;
    private final ElementGenerator<Vertex> vertexTypes;
    private final ElementGenerator<Edge> allEdgeStatements;
    private final FirstClassEdgeGenerator labels;
    private final FirstClassEdgeGenerator heads;
    private final FirstClassEdgeGenerator tails;
    private final FirstClassEdgeGenerator edgeTypes;
    private final FirstClassEdgeGenerator edgeIds;
    private final FirstClassEdgeGenerator edgeProps;
    private final RelationGenerator allInRelations;
    private final RelationGenerator allOutRelations;
    private final boolean firstClassEdges;

    public PropertyGraphSailConnection(SailBase sailBase, PropertyGraphSail.PropertyGraphContext context, boolean firstClassEdges) {
        super(sailBase);
        this.context = context;
        this.firstClassEdges = firstClassEdges;
        this.allVertexStatements = new VertexGenerator();
        this.allVertexStatements.setDoId(true);
        this.allVertexStatements.setDoProperties(true);
        this.allVertexStatements.setDoType(true);
        if (firstClassEdges) {
            this.allEdgeStatements = new FirstClassEdgeGenerator();
            this.allEdgeStatements.setDoId(true);
            this.allEdgeStatements.setDoProperties(true);
            this.allEdgeStatements.setDoType(true);
            ((FirstClassEdgeGenerator)this.allEdgeStatements).setDoHead(true);
            ((FirstClassEdgeGenerator)this.allEdgeStatements).setDoTail(true);
            ((FirstClassEdgeGenerator)this.allEdgeStatements).setDoLabel(true);
            this.allInRelations = null;
            this.allOutRelations = null;
        } else {
            this.allEdgeStatements = new SimpleEdgeGenerator(null);
            this.allInRelations = new RelationGenerator(null, true);
            this.allOutRelations = new RelationGenerator(null, false);
        }
        this.vertexTypes = new VertexGenerator();
        this.vertexTypes.setDoType(true);
        this.vertexIds = new VertexGenerator();
        this.vertexIds.setDoId(true);
        this.vertexProps = new VertexGenerator();
        this.vertexProps.setDoProperties(true);
        if (firstClassEdges) {
            this.edgeTypes = new FirstClassEdgeGenerator();
            this.edgeTypes.setDoType(true);
            this.labels = new FirstClassEdgeGenerator();
            this.labels.setDoLabel(true);
            this.heads = new FirstClassEdgeGenerator();
            this.heads.setDoHead(true);
            this.tails = new FirstClassEdgeGenerator();
            this.tails.setDoTail(true);
            this.edgeIds = new FirstClassEdgeGenerator();
            this.edgeIds.setDoId(true);
            this.edgeProps = new FirstClassEdgeGenerator();
            this.edgeProps.setDoProperties(true);
        } else {
            this.edgeTypes = null;
            this.labels = null;
            this.heads = null;
            this.tails = null;
            this.edgeIds = null;
            this.edgeProps = null;
        }
    }

    private static void addNamespace(String prefix, String uri) {
        NamespaceImpl n = new NamespaceImpl(prefix, uri);
        namespaces.put(prefix, (Namespace)n);
    }

    protected boolean isOpenInternal() throws SailException {
        return this.open;
    }

    protected void closeInternal() throws SailException {
        this.open = false;
    }

    protected CloseableIteration<? extends BindingSet, QueryEvaluationException> evaluateInternal(TupleExpr query, Dataset dataset, BindingSet bindings, boolean includeInferred) throws SailException {
        try {
            SailConnectionTripleSource tripleSource = new SailConnectionTripleSource((SailConnection)this, this.context.valueFactory, includeInferred);
            EvaluationStrategyImpl strategy = new EvaluationStrategyImpl((TripleSource)tripleSource, dataset);
            return strategy.evaluate(query, bindings);
        }
        catch (QueryEvaluationException e) {
            throw new SailException((Throwable)e);
        }
    }

    public void executeUpdate(UpdateExpr updateExpr, Dataset dataset, BindingSet bindingSet, boolean b) throws SailException {
    }

    protected CloseableIteration<? extends Resource, SailException> getContextIDsInternal() throws SailException {
        throw new UnsupportedOperationException();
    }

    private boolean matchesNullContext(Resource ... contexts) {
        if (0 == contexts.length) {
            return true;
        }
        for (Resource c : contexts) {
            if (null != c) continue;
            return true;
        }
        return false;
    }

    protected CloseableIteration<? extends Statement, SailException> getStatementsInternal(Resource subject, URI predicate, Value object, boolean includeInferred, Resource ... contexts) throws SailException {
        if (!this.matchesNullContext(contexts)) {
            return new StatementIteration(new Source[0]);
        }
        if (null == subject) {
            if (null == object) {
                if (null == predicate) {
                    return this.getStatements_xxx();
                }
                return this.getStatements_xPx(predicate);
            }
            if (null == predicate) {
                return this.getStatements_xxO(object);
            }
            return this.getStatements_xPO(predicate, object);
        }
        if (null == object) {
            if (null == predicate) {
                return this.getStatements_Sxx(subject);
            }
            return this.getStatements_SPx(subject, predicate);
        }
        if (null == predicate) {
            return this.getStatements_SxO(subject, object);
        }
        return this.getStatements_SPO(subject, predicate, object);
    }

    private CloseableIteration<Statement, SailException> getStatements_xxx() throws SailException {
        Iterator edgeIterator = this.context.graph.getEdges().iterator();
        Iterator vertexIterator = this.context.graph.getVertices().iterator();
        Source<Edge> edges = new Source<Edge>(edgeIterator, this.allEdgeStatements);
        Source<Vertex> vertices = new Source<Vertex>(vertexIterator, this.allVertexStatements);
        return new StatementIteration(vertices, edges);
    }

    private CloseableIteration<Statement, SailException> getStatements_Sxx(Resource subject) throws SailException {
        if (subject instanceof URI) {
            Vertex v = this.vertexForURI((URI)subject);
            if (null == v) {
                if (!this.firstClassEdges) {
                    return new StatementIteration(new Source[0]);
                }
                Edge e = this.edgeForURI((URI)subject);
                if (null == e) {
                    return new StatementIteration(new Source[0]);
                }
                Source<Edge> s = new Source<Edge>(new SingleItemIterator<Edge>(e), this.allEdgeStatements);
                return new StatementIteration(s);
            }
            Source<Vertex> s = new Source<Vertex>(new SingleItemIterator<Vertex>(v), this.allVertexStatements);
            if (this.firstClassEdges) {
                return new StatementIteration(s);
            }
            Source<Vertex> s2 = new Source<Vertex>(new SingleItemIterator<Vertex>(v), this.allOutRelations);
            return new StatementIteration(s, s2);
        }
        return new StatementIteration(new Source[0]);
    }

    private CloseableIteration<Statement, SailException> getStatements_SPx(Resource subject, URI predicate) throws SailException {
        if (subject instanceof URI) {
            if (predicate.equals((Object)RDF.TYPE)) {
                Vertex v = this.vertexForURI((URI)subject);
                if (null == v) {
                    if (!this.firstClassEdges) {
                        return new StatementIteration(new Source[0]);
                    }
                    Edge e = this.edgeForURI((URI)subject);
                    if (null == e) {
                        return new StatementIteration(new Source[0]);
                    }
                    Source<Edge> s = new Source<Edge>(new SingleItemIterator<Edge>(e), this.edgeTypes);
                    return new StatementIteration(s);
                }
                Source<Vertex> s = new Source<Vertex>(new SingleItemIterator<Vertex>(v), this.vertexTypes);
                return new StatementIteration(s);
            }
            if (predicate.equals((Object)PropertyGraphSail.ID)) {
                Vertex v = this.vertexForURI((URI)subject);
                if (null == v) {
                    if (!this.firstClassEdges) {
                        return new StatementIteration(new Source[0]);
                    }
                    Edge e = this.edgeForURI((URI)subject);
                    if (null == e) {
                        return new StatementIteration(new Source[0]);
                    }
                    Source<Edge> s = new Source<Edge>(new SingleItemIterator<Edge>(e), this.edgeIds);
                    return new StatementIteration(s);
                }
                Source<Vertex> s = new Source<Vertex>(new SingleItemIterator<Vertex>(v), this.vertexIds);
                return new StatementIteration(s);
            }
            if (predicate.equals((Object)PropertyGraphSail.LABEL)) {
                if (!this.firstClassEdges) {
                    return new StatementIteration(new Source[0]);
                }
                Edge e = this.edgeForURI((URI)subject);
                if (null == e) {
                    return new StatementIteration(new Source[0]);
                }
                Source<Edge> s = new Source<Edge>(new SingleItemIterator<Edge>(e), this.labels);
                return new StatementIteration(s);
            }
            if (predicate.equals((Object)PropertyGraphSail.HEAD)) {
                if (!this.firstClassEdges) {
                    return new StatementIteration(new Source[0]);
                }
                Edge e = this.edgeForURI((URI)subject);
                if (null == e) {
                    return new StatementIteration(new Source[0]);
                }
                Source<Edge> s = new Source<Edge>(new SingleItemIterator<Edge>(e), this.heads);
                return new StatementIteration(s);
            }
            if (predicate.equals((Object)PropertyGraphSail.TAIL)) {
                if (!this.firstClassEdges) {
                    return new StatementIteration(new Source[0]);
                }
                Edge e = this.edgeForURI((URI)subject);
                if (null == e) {
                    return new StatementIteration(new Source[0]);
                }
                Source<Edge> s = new Source<Edge>(new SingleItemIterator<Edge>(e), this.tails);
                return new StatementIteration(s);
            }
            if (this.isPropertyPredicate(predicate)) {
                String key = this.keyFromPredicate(predicate);
                Vertex v = this.vertexForURI((URI)subject);
                if (null == v) {
                    if (!this.firstClassEdges) {
                        return new StatementIteration(new Source[0]);
                    }
                    Edge e = this.edgeForURI((URI)subject);
                    if (null == e) {
                        return new StatementIteration(new Source[0]);
                    }
                    Source<Edge> s = new Source<Edge>(new SingleItemIterator<Edge>(e), this.edgePropertiesWithKey(key, predicate));
                    return new StatementIteration(s);
                }
                Source<Vertex> s = new Source<Vertex>(new SingleItemIterator<Vertex>(v), this.vertexPropertiesWithKey(key, predicate));
                return new StatementIteration(s);
            }
            if (this.isRelationPredicate(predicate)) {
                Vertex v = this.vertexForURI((URI)subject);
                if (null != v) {
                    String label = this.labelForRelationPredicate(predicate);
                    Source<Vertex> s = new Source<Vertex>(new SingleItemIterator<Vertex>(v), new RelationGenerator(label, false));
                    return new StatementIteration(s);
                }
                return new StatementIteration(new Source[0]);
            }
            return new StatementIteration(new Source[0]);
        }
        return new StatementIteration(new Source[0]);
    }

    private CloseableIteration<Statement, SailException> getStatements_SxO(Resource subject, Value object) throws SailException {
        if (subject instanceof URI) {
            Object edges;
            Object s;
            Vertex vObj;
            LinkedList<Object> sources = new LinkedList<Object>();
            Vertex v = this.vertexForURI((URI)subject);
            Edge e = this.edgeForURI((URI)subject);
            Object val = this.literalToObject(object);
            Vertex vertex = vObj = object instanceof URI ? this.vertexForURI((URI)object) : null;
            if (null != val && null != v && v.getId().equals(val)) {
                s = new Source(new SingleItemIterator<Vertex>(v), this.vertexIds);
                sources.add(s);
            }
            if (null != v && object instanceof URI && ((URI)object).equals((Object)PropertyGraphSail.VERTEX)) {
                s = new Source<Vertex>(new SingleItemIterator<Vertex>(v), this.vertexTypes);
                sources.add(s);
            }
            if (null != val && null != v) {
                Source<Vertex> vertices = new Source<Vertex>(new SingleItemIterator<Vertex>(v), this.vertexPropertiesWithValue(val, (Literal)object));
                sources.add(vertices);
            }
            if (this.firstClassEdges) {
                if (null != val && null != e && e.getId().equals(val)) {
                    s = new Source<Edge>(new SingleItemIterator<Edge>(e), this.edgeIds);
                    sources.add(s);
                }
                if (null != val && val instanceof String && null != e && e.getLabel().equals(val)) {
                    s = new Source<Edge>(new SingleItemIterator<Edge>(e), this.labels);
                    sources.add(s);
                }
                if (null != e && null != vObj && e.getVertex(Direction.IN).equals(vObj)) {
                    s = new Source<Edge>(new SingleItemIterator<Edge>(e), this.heads);
                    sources.add(s);
                }
                if (null != e && null != vObj && e.getVertex(Direction.OUT).equals(vObj)) {
                    s = new Source<Edge>(new SingleItemIterator<Edge>(e), this.tails);
                    sources.add(s);
                }
                if (null != e && object instanceof URI && ((URI)object).equals((Object)PropertyGraphSail.VERTEX)) {
                    s = new Source<Edge>(new SingleItemIterator<Edge>(e), this.edgeTypes);
                    sources.add(s);
                }
                if (null != val && null != e) {
                    edges = new Source<Edge>(new SingleItemIterator<Edge>(e), this.edgePropertiesWithValue(val, (Literal)object));
                    sources.add(edges);
                }
            } else if (null != v && null != vObj) {
                edges = new LinkedList<Edge>();
                for (Edge ev : v.getEdges(Direction.OUT, new String[0])) {
                    if (!ev.getVertex(Direction.IN).equals(vObj)) continue;
                    edges.add(ev);
                }
                if (edges.size() > 0) {
                    sources.add(new Source<Edge>(edges.iterator(), this.allEdgeStatements));
                }
            }
            if (sources.size() > 0) {
                s = new Source[sources.size()];
                sources.toArray((T[])s);
                return new StatementIteration((Source)s);
            }
            return new StatementIteration(new Source[0]);
        }
        return new StatementIteration(new Source[0]);
    }

    private CloseableIteration<Statement, SailException> getStatements_SPO(Resource subject, URI predicate, Value object) throws SailException {
        if (predicate.equals((Object)RDF.TYPE)) {
            if (subject instanceof URI) {
                Vertex v = this.vertexForURI((URI)subject);
                if (null == v) {
                    if (!this.firstClassEdges) {
                        return new StatementIteration(new Source[0]);
                    }
                    Edge e = this.edgeForURI((URI)subject);
                    if (null == e) {
                        return new StatementIteration(new Source[0]);
                    }
                    if (object.equals(PropertyGraphSail.EDGE)) {
                        Source<Edge> s = new Source<Edge>(new SingleItemIterator<Edge>(e), this.edgeTypes);
                        return new StatementIteration(s);
                    }
                    return new StatementIteration(new Source[0]);
                }
                if (object.equals(PropertyGraphSail.VERTEX)) {
                    Source<Vertex> s = new Source<Vertex>(new SingleItemIterator<Vertex>(v), this.vertexTypes);
                    return new StatementIteration(s);
                }
                return new StatementIteration(new Source[0]);
            }
            return new StatementIteration(new Source[0]);
        }
        if (predicate.equals((Object)PropertyGraphSail.ID)) {
            Object id = this.literalToObject(object);
            if (null == id || !(subject instanceof URI)) {
                return new StatementIteration(new Source[0]);
            }
            Vertex v = this.vertexForURI((URI)subject);
            if (null == v) {
                if (!this.firstClassEdges) {
                    return new StatementIteration(new Source[0]);
                }
                Edge e = this.edgeForURI((URI)subject);
                if (null == e) {
                    return new StatementIteration(new Source[0]);
                }
                if (e.getId().equals(id)) {
                    Source<Edge> s = new Source<Edge>(new SingleItemIterator<Edge>(e), this.edgeIds);
                    return new StatementIteration(s);
                }
                return new StatementIteration(new Source[0]);
            }
            if (v.getId().equals(id)) {
                Source<Vertex> s = new Source<Vertex>(new SingleItemIterator<Vertex>(v), this.vertexIds);
                return new StatementIteration(s);
            }
            return new StatementIteration(new Source[0]);
        }
        if (predicate.equals((Object)PropertyGraphSail.LABEL)) {
            if (!this.firstClassEdges) {
                return new StatementIteration(new Source[0]);
            }
            Object label = this.literalToObject(object);
            if (null == label || !(label instanceof String) || !(subject instanceof URI)) {
                return new StatementIteration(new Source[0]);
            }
            Edge e = this.edgeForURI((URI)subject);
            if (null == e || !e.getLabel().equals(label)) {
                return new StatementIteration(new Source[0]);
            }
            Source<Edge> s = new Source<Edge>(new SingleItemIterator<Edge>(e), this.labels);
            return new StatementIteration(s);
        }
        if (predicate.equals((Object)PropertyGraphSail.HEAD)) {
            if (!this.firstClassEdges) {
                return new StatementIteration(new Source[0]);
            }
            if (!(subject instanceof URI) || !(object instanceof URI)) {
                return new StatementIteration(new Source[0]);
            }
            Edge e = this.edgeForURI((URI)subject);
            Vertex v = this.vertexForURI((URI)object);
            if (null == e || null == v || !e.getVertex(Direction.IN).equals(v)) {
                return new StatementIteration(new Source[0]);
            }
            Source<Edge> s = new Source<Edge>(new SingleItemIterator<Edge>(e), this.heads);
            return new StatementIteration(s);
        }
        if (predicate.equals((Object)PropertyGraphSail.TAIL)) {
            if (!this.firstClassEdges) {
                return new StatementIteration(new Source[0]);
            }
            if (!(subject instanceof URI) || !(object instanceof URI)) {
                return new StatementIteration(new Source[0]);
            }
            Edge e = this.edgeForURI((URI)subject);
            Vertex v = this.vertexForURI((URI)object);
            if (null == e || null == v || !e.getVertex(Direction.OUT).equals(v)) {
                return new StatementIteration(new Source[0]);
            }
            Source<Edge> s = new Source<Edge>(new SingleItemIterator<Edge>(e), this.tails);
            return new StatementIteration(s);
        }
        if (this.isPropertyPredicate(predicate)) {
            Object val = this.literalToObject(object);
            if (null == val || !(subject instanceof URI)) {
                return new StatementIteration(new Source[0]);
            }
            String key = this.keyFromPredicate(predicate);
            Vertex v = this.vertexForURI((URI)subject);
            if (null == v) {
                if (!this.firstClassEdges) {
                    return new StatementIteration(new Source[0]);
                }
                Edge e = this.edgeForURI((URI)subject);
                if (null == e) {
                    return new StatementIteration(new Source[0]);
                }
                Source<Edge> edges = new Source<Edge>(new SingleItemIterator<Edge>(e), this.edgePropertiesWithKeyAndValue(key, predicate, val, (Literal)object));
                return new StatementIteration(edges);
            }
            Source<Vertex> vertices = new Source<Vertex>(new SingleItemIterator<Vertex>(v), this.vertexPropertiesWithKeyAndValue(key, predicate, val, (Literal)object));
            return new StatementIteration(vertices);
        }
        if (this.isRelationPredicate(predicate)) {
            if (!(subject instanceof URI) || !(object instanceof URI)) {
                return new StatementIteration(new Source[0]);
            }
            String label = this.labelForRelationPredicate(predicate);
            Vertex vSubj = this.vertexForURI((URI)subject);
            Vertex vObj = this.vertexForURI((URI)object);
            if (null != vSubj && null != vObj) {
                LinkedList<Edge> edges = new LinkedList<Edge>();
                for (Edge ev : vSubj.getEdges(Direction.OUT, new String[]{label})) {
                    if (!ev.getVertex(Direction.IN).equals(vObj)) continue;
                    edges.add(ev);
                }
                if (edges.size() > 0) {
                    return new StatementIteration(new Source<Edge>(edges.iterator(), this.allEdgeStatements));
                }
                return new StatementIteration(new Source[0]);
            }
            return new StatementIteration(new Source[0]);
        }
        return new StatementIteration(new Source[0]);
    }

    private CloseableIteration<Statement, SailException> getStatements_xxO(Value object) throws SailException {
        Source[] s;
        Edge e;
        if (object instanceof URI) {
            Vertex v = this.vertexForURI((URI)object);
            if (null == v) {
                if (object.equals(PropertyGraphSail.VERTEX)) {
                    Source<Vertex> vertices = new Source<Vertex>(this.context.graph.getVertices().iterator(), this.vertexTypes);
                    return new StatementIteration(vertices);
                }
                if (object.equals(PropertyGraphSail.EDGE) && this.firstClassEdges) {
                    Source<Edge> edges = new Source<Edge>(this.context.graph.getEdges().iterator(), this.edgeTypes);
                    return new StatementIteration(edges);
                }
                return new StatementIteration(new Source[0]);
            }
            if (this.firstClassEdges) {
                Source<Edge> ins = new Source<Edge>(v.getEdges(Direction.IN, new String[0]).iterator(), this.heads);
                Source<Edge> outs = new Source<Edge>(v.getEdges(Direction.OUT, new String[0]).iterator(), this.tails);
                return new StatementIteration(ins, outs);
            }
            Source<Vertex> s2 = new Source<Vertex>(new SingleItemIterator<Vertex>(v), this.allInRelations);
            return new StatementIteration(s2);
        }
        Object val = this.literalToObject(object);
        if (null == val) {
            return new StatementIteration(new Source[0]);
        }
        LinkedList<Object> sources = new LinkedList<Object>();
        Vertex v = this.context.graph.getVertex(val);
        if (null != v) {
            sources.add(new Source<Vertex>(new SingleItemIterator<Vertex>(v), this.vertexIds));
        }
        if (this.firstClassEdges && null != (e = this.context.graph.getEdge(val))) {
            sources.add(new Source<Edge>(new SingleItemIterator<Edge>(e), this.edgeIds));
        }
        if (this.firstClassEdges && val instanceof String) {
            s = new Source(this.context.graph.getEdges().iterator(), this.matchingLabels((String)val, object));
            sources.add(s);
        }
        Source<Vertex> vertices = new Source<Vertex>(this.context.graph.getVertices().iterator(), this.vertexPropertiesWithValue(val, (Literal)object));
        sources.add(vertices);
        if (this.firstClassEdges) {
            Source<Edge> edges = new Source<Edge>(this.context.graph.getEdges().iterator(), this.edgePropertiesWithValue(val, (Literal)object));
            sources.add(edges);
        }
        if (sources.size() > 0) {
            s = new Source[sources.size()];
            sources.toArray(s);
            return new StatementIteration(s);
        }
        return new StatementIteration(new Source[0]);
    }

    private CloseableIteration<Statement, SailException> getStatements_xPO(URI predicate, Value object) throws SailException {
        if (predicate.equals((Object)RDF.TYPE)) {
            if (object.equals(PropertyGraphSail.VERTEX)) {
                Source<Vertex> s = new Source<Vertex>(this.context.graph.getVertices().iterator(), this.vertexTypes);
                return new StatementIteration(s);
            }
            if (object.equals(PropertyGraphSail.EDGE) && this.firstClassEdges) {
                Source<Edge> s = new Source<Edge>(this.context.graph.getEdges().iterator(), this.edgeTypes);
                return new StatementIteration(s);
            }
            return new StatementIteration(new Source[0]);
        }
        if (predicate.equals((Object)PropertyGraphSail.ID)) {
            Edge e;
            Object id = this.literalToObject(object);
            if (null == id) {
                return new StatementIteration(new Source[0]);
            }
            Vertex v = this.context.graph.getVertex(id);
            Edge edge = e = this.firstClassEdges ? this.context.graph.getEdge(id) : null;
            if (null == v && null == e) {
                return new StatementIteration(new Source[0]);
            }
            LinkedList<Statement> s = new LinkedList<Statement>();
            if (null != v) {
                this.vertexIds.generate(v, s);
            }
            if (null != e) {
                this.edgeIds.generate(e, (Collection<Statement>)s);
            }
            return new SimpleCloseableIteration<Statement, SailException>(s.iterator());
        }
        if (predicate.equals((Object)PropertyGraphSail.LABEL)) {
            if (!this.firstClassEdges) {
                return new StatementIteration(new Source[0]);
            }
            Object label = this.literalToObject(object);
            if (null == label || !(label instanceof String)) {
                return new StatementIteration(new Source[0]);
            }
            Source<Edge> edges = new Source<Edge>(this.context.graph.getEdges().iterator(), this.matchingLabels((String)label, object));
            return new StatementIteration(edges);
        }
        if (predicate.equals((Object)PropertyGraphSail.HEAD)) {
            Vertex v;
            if (!this.firstClassEdges) {
                return new StatementIteration(new Source[0]);
            }
            Vertex vertex = v = object instanceof URI ? this.vertexForURI((URI)object) : null;
            if (null == v) {
                return new StatementIteration(new Source[0]);
            }
            Iterator edgeIterator = v.getEdges(Direction.IN, new String[0]).iterator();
            Source<Edge> edges = new Source<Edge>(edgeIterator, this.heads);
            return new StatementIteration(edges);
        }
        if (predicate.equals((Object)PropertyGraphSail.TAIL)) {
            Vertex v;
            if (!this.firstClassEdges) {
                return new StatementIteration(new Source[0]);
            }
            Vertex vertex = v = object instanceof URI ? this.vertexForURI((URI)object) : null;
            if (null == v) {
                return new StatementIteration(new Source[0]);
            }
            Iterator edgeIterator = v.getEdges(Direction.OUT, new String[0]).iterator();
            Source<Edge> edges = new Source<Edge>(edgeIterator, this.tails);
            return new StatementIteration(edges);
        }
        if (this.isPropertyPredicate(predicate)) {
            Object value = this.literalToObject(object);
            if (null == value) {
                return new StatementIteration(new Source[0]);
            }
            String key = this.keyFromPredicate(predicate);
            Source<Vertex> vertices = new Source<Vertex>(this.context.graph.getVertices().iterator(), this.vertexPropertiesWithKeyAndValue(key, predicate, value, (Literal)object));
            if (this.firstClassEdges) {
                Source<Edge> edges = new Source<Edge>(this.context.graph.getEdges().iterator(), this.edgePropertiesWithKeyAndValue(key, predicate, value, (Literal)object));
                return new StatementIteration(vertices, edges);
            }
            return new StatementIteration(vertices);
        }
        if (this.isRelationPredicate(predicate)) {
            if (!(object instanceof URI)) {
                return new StatementIteration(new Source[0]);
            }
            String label = this.labelForRelationPredicate(predicate);
            Vertex vObj = this.vertexForURI((URI)object);
            if (null != vObj) {
                Source<Vertex> s = new Source<Vertex>(new SingleItemIterator<Vertex>(vObj), new RelationGenerator(label, true));
                return new StatementIteration(s);
            }
            return new StatementIteration(new Source[0]);
        }
        return new StatementIteration(new Source[0]);
    }

    private CloseableIteration<Statement, SailException> getStatements_xPx(URI predicate) throws SailException {
        if (predicate.equals((Object)RDF.TYPE)) {
            Source<Vertex> vertices = new Source<Vertex>(this.context.graph.getVertices().iterator(), this.vertexTypes);
            if (this.firstClassEdges) {
                Source<Edge> edges = new Source<Edge>(this.context.graph.getEdges().iterator(), this.edgeTypes);
                return new StatementIteration(vertices, edges);
            }
            return new StatementIteration(vertices);
        }
        if (predicate.equals((Object)PropertyGraphSail.ID)) {
            Source<Vertex> vertices = new Source<Vertex>(this.context.graph.getVertices().iterator(), this.vertexIds);
            if (this.firstClassEdges) {
                Source<Edge> edges = new Source<Edge>(this.context.graph.getEdges().iterator(), this.edgeIds);
                return new StatementIteration(vertices, edges);
            }
            return new StatementIteration(vertices);
        }
        if (predicate.equals((Object)PropertyGraphSail.LABEL)) {
            if (!this.firstClassEdges) {
                return new StatementIteration(new Source[0]);
            }
            Iterator edgeIterator = this.context.graph.getEdges().iterator();
            Source<Edge> edges = new Source<Edge>(edgeIterator, this.labels);
            return new StatementIteration(edges);
        }
        if (predicate.equals((Object)PropertyGraphSail.HEAD)) {
            if (!this.firstClassEdges) {
                return new StatementIteration(new Source[0]);
            }
            Iterator edgeIterator = this.context.graph.getEdges().iterator();
            Source<Edge> edges = new Source<Edge>(edgeIterator, this.heads);
            return new StatementIteration(edges);
        }
        if (predicate.equals((Object)PropertyGraphSail.TAIL)) {
            if (!this.firstClassEdges) {
                return new StatementIteration(new Source[0]);
            }
            Iterator edgeIterator = this.context.graph.getEdges().iterator();
            Source<Edge> edges = new Source<Edge>(edgeIterator, this.tails);
            return new StatementIteration(edges);
        }
        if (this.isPropertyPredicate(predicate)) {
            String key = this.keyFromPredicate(predicate);
            Source<Vertex> vertices = new Source<Vertex>(this.context.graph.getVertices().iterator(), this.vertexPropertiesWithKey(key, predicate));
            if (this.firstClassEdges) {
                Source<Edge> edges = new Source<Edge>(this.context.graph.getEdges().iterator(), this.edgePropertiesWithKey(key, predicate));
                return new StatementIteration(vertices, edges);
            }
            return new StatementIteration(vertices);
        }
        if (this.isRelationPredicate(predicate)) {
            String label = this.labelForRelationPredicate(predicate);
            Iterator edgeIterator = this.context.graph.getEdges().iterator();
            Source<Edge> edges = new Source<Edge>(edgeIterator, new SimpleEdgeGenerator(label));
            return new StatementIteration(edges);
        }
        return new StatementIteration(new Source[0]);
    }

    private boolean isPropertyPredicate(URI predicate) {
        return predicate.stringValue().startsWith("http://tinkerpop.com/pgm/property/");
    }

    private boolean isRelationPredicate(URI predicate) {
        return predicate.stringValue().startsWith("http://tinkerpop.com/pgm/relation/");
    }

    private String labelForRelationPredicate(URI predicate) {
        return predicate.stringValue().substring("http://tinkerpop.com/pgm/relation/".length());
    }

    private String keyFromPredicate(URI predicate) {
        return predicate.stringValue().substring("http://tinkerpop.com/pgm/property/".length());
    }

    protected long sizeInternal(Resource ... contexts) throws SailException {
        if (!this.matchesNullContext(contexts)) {
            return 0L;
        }
        long count = 0L;
        for (Edge e : this.context.graph.getEdges()) {
            if (this.firstClassEdges) {
                count += (long)(5 + e.getPropertyKeys().size());
                continue;
            }
            ++count;
        }
        for (Vertex v : this.context.graph.getVertices()) {
            count += (long)(2 + v.getPropertyKeys().size());
        }
        return count;
    }

    protected void startTransactionInternal() throws SailException {
    }

    protected void commitInternal() throws SailException {
    }

    protected void rollbackInternal() throws SailException {
    }

    protected void addStatementInternal(Resource resource, URI uri, Value value, Resource ... resources) throws SailException {
    }

    protected void removeStatementsInternal(Resource resource, URI uri, Value value, Resource ... resources) throws SailException {
    }

    protected void clearInternal(Resource ... resources) throws SailException {
    }

    protected CloseableIteration<? extends Namespace, SailException> getNamespacesInternal() throws SailException {
        return new SimpleCloseableIteration<Namespace, SailException>(namespaces.values().iterator());
    }

    protected String getNamespaceInternal(String prefix) throws SailException {
        Namespace n = namespaces.get(prefix);
        return null == n ? null : n.getName();
    }

    protected void setNamespaceInternal(String s, String s1) throws SailException {
    }

    protected void removeNamespaceInternal(String s) throws SailException {
    }

    protected void clearNamespacesInternal() throws SailException {
    }

    private Vertex vertexForURI(URI uri) {
        String s = uri.stringValue();
        return s.startsWith("http://tinkerpop.com/pgm/vertex/") ? this.context.graph.getVertex(this.idFromString(s.substring("http://tinkerpop.com/pgm/vertex/".length()))) : null;
    }

    private Edge edgeForURI(URI uri) {
        if (this.firstClassEdges) {
            String s = uri.stringValue();
            return s.startsWith("http://tinkerpop.com/pgm/edge/") ? this.context.graph.getEdge(this.idFromString(s.substring("http://tinkerpop.com/pgm/edge/".length()))) : null;
        }
        return null;
    }

    private Object literalToObject(Value v) {
        if (v instanceof Literal) {
            Literal l = (Literal)v;
            URI type = l.getDatatype();
            if (null == type) {
                return l.getLabel();
            }
            if (type.equals((Object)XMLSchema.STRING)) {
                return l.stringValue();
            }
            if (type.equals((Object)XMLSchema.LONG)) {
                return l.longValue();
            }
            if (type.equals((Object)XMLSchema.INT)) {
                return l.intValue();
            }
            if (type.equals((Object)XMLSchema.INTEGER)) {
                return l.integerValue();
            }
            if (type.equals((Object)XMLSchema.BYTE)) {
                return l.byteValue();
            }
            if (type.equals((Object)XMLSchema.BOOLEAN)) {
                return l.booleanValue();
            }
            if (type.equals((Object)XMLSchema.SHORT)) {
                return l.shortValue();
            }
            if (type.equals((Object)XMLSchema.FLOAT)) {
                return Float.valueOf(l.floatValue());
            }
            if (type.equals((Object)XMLSchema.DOUBLE)) {
                return l.doubleValue();
            }
            return null;
        }
        return null;
    }

    private URI uriForVertex(Vertex v) {
        return this.context.valueFactory.createURI("http://tinkerpop.com/pgm/vertex/" + this.idToString(v.getId()));
    }

    private URI uriForEdge(Edge e) {
        return this.context.valueFactory.createURI("http://tinkerpop.com/pgm/edge/" + this.idToString(e.getId()));
    }

    private Object idFromString(String s) {
        return s;
    }

    private String idToString(Object id) {
        return id.toString();
    }

    private void createEdgeStatement(Edge source, Collection<Statement> results) {
        URI headUri = this.uriForVertex(source.getVertex(Direction.IN));
        URI tailUri = this.uriForVertex(source.getVertex(Direction.OUT));
        URI predicate = this.context.valueFactory.createURI("http://tinkerpop.com/pgm/relation/" + source.getLabel());
        results.add(this.context.valueFactory.createStatement((Resource)tailUri, predicate, (Value)headUri));
    }

    private StatementGenerator<Edge> matchingLabels(final String label, final Value object) {
        return new StatementGenerator<Edge>(){

            @Override
            public void generate(Edge source, Collection<Statement> results) {
                if (source.getLabel().equals(label)) {
                    Statement s = ((PropertyGraphSailConnection)PropertyGraphSailConnection.this).context.valueFactory.createStatement((Resource)PropertyGraphSailConnection.this.uriForEdge(source), PropertyGraphSail.LABEL, object);
                    results.add(s);
                }
            }
        };
    }

    private StatementGenerator<Vertex> vertexPropertiesWithKey(final String key, final URI pred) {
        return new StatementGenerator<Vertex>(){

            @Override
            public void generate(Vertex source, Collection<Statement> results) {
                Literal object;
                Object o = source.getProperty(key);
                if (null != o && null != (object = PropertyGraphSailConnection.this.toLiteral(o))) {
                    Statement s = ((PropertyGraphSailConnection)PropertyGraphSailConnection.this).context.valueFactory.createStatement((Resource)PropertyGraphSailConnection.this.uriForVertex(source), pred, (Value)object);
                    results.add(s);
                }
            }
        };
    }

    private StatementGenerator<Edge> edgePropertiesWithKey(final String key, final URI pred) {
        return new StatementGenerator<Edge>(){

            @Override
            public void generate(Edge source, Collection<Statement> results) {
                Literal object;
                Object o = source.getProperty(key);
                if (null != o && null != (object = PropertyGraphSailConnection.this.toLiteral(o))) {
                    Statement s = ((PropertyGraphSailConnection)PropertyGraphSailConnection.this).context.valueFactory.createStatement((Resource)PropertyGraphSailConnection.this.uriForEdge(source), pred, (Value)object);
                    results.add(s);
                }
            }
        };
    }

    private StatementGenerator<Vertex> vertexPropertiesWithValue(final Object value, final Literal object) {
        return new StatementGenerator<Vertex>(){

            @Override
            public void generate(Vertex source, Collection<Statement> results) {
                for (String key : source.getPropertyKeys()) {
                    Object v = source.getProperty(key);
                    if (null == v || !v.equals(value)) continue;
                    URI predicate = PropertyGraphSailConnection.this.predicateForPropertyKey(key);
                    Statement s = ((PropertyGraphSailConnection)PropertyGraphSailConnection.this).context.valueFactory.createStatement((Resource)PropertyGraphSailConnection.this.uriForVertex(source), predicate, (Value)object);
                    results.add(s);
                }
            }
        };
    }

    private StatementGenerator<Edge> edgePropertiesWithValue(final Object value, final Literal object) {
        return new StatementGenerator<Edge>(){

            @Override
            public void generate(Edge source, Collection<Statement> results) {
                for (String key : source.getPropertyKeys()) {
                    Object v = source.getProperty(key);
                    if (null == v || !v.equals(value)) continue;
                    URI predicate = PropertyGraphSailConnection.this.predicateForPropertyKey(key);
                    Statement s = ((PropertyGraphSailConnection)PropertyGraphSailConnection.this).context.valueFactory.createStatement((Resource)PropertyGraphSailConnection.this.uriForEdge(source), predicate, (Value)object);
                    results.add(s);
                }
            }
        };
    }

    private StatementGenerator<Vertex> vertexPropertiesWithKeyAndValue(final String key, final URI pred, final Object value, final Literal object) {
        return new StatementGenerator<Vertex>(){

            @Override
            public void generate(Vertex source, Collection<Statement> results) {
                Object o = source.getProperty(key);
                if (null != o && o.equals(value)) {
                    Statement s = ((PropertyGraphSailConnection)PropertyGraphSailConnection.this).context.valueFactory.createStatement((Resource)PropertyGraphSailConnection.this.uriForVertex(source), pred, (Value)object);
                    results.add(s);
                }
            }
        };
    }

    private StatementGenerator<Edge> edgePropertiesWithKeyAndValue(final String key, final URI pred, final Object value, final Literal object) {
        return new StatementGenerator<Edge>(){

            @Override
            public void generate(Edge source, Collection<Statement> results) {
                Object o = source.getProperty(key);
                if (null != o && o.equals(value)) {
                    Statement s = ((PropertyGraphSailConnection)PropertyGraphSailConnection.this).context.valueFactory.createStatement((Resource)PropertyGraphSailConnection.this.uriForEdge(source), pred, (Value)object);
                    results.add(s);
                }
            }
        };
    }

    private URI predicateForPropertyKey(String key) {
        return this.context.valueFactory.createURI("http://tinkerpop.com/pgm/property/" + key);
    }

    private void generateVertexTypeStatement(URI uri, Collection<Statement> results) {
        Statement s = this.context.valueFactory.createStatement((Resource)uri, RDF.TYPE, (Value)PropertyGraphSail.VERTEX);
        results.add(s);
    }

    private void generateEdgeTypeStatement(URI uri, Collection<Statement> results) {
        Statement s = this.context.valueFactory.createStatement((Resource)uri, RDF.TYPE, (Value)PropertyGraphSail.EDGE);
        results.add(s);
    }

    private void generatePropertyStatements(Element e, URI uri, Collection<Statement> results, String ... keys) {
        if (0 == keys.length) {
            for (String k : e.getPropertyKeys()) {
                Object v = e.getProperty(k);
                Statement s = this.context.valueFactory.createStatement((Resource)uri, this.context.valueFactory.createURI("http://tinkerpop.com/pgm/property/" + k), (Value)this.toLiteral(v));
                results.add(s);
            }
        } else {
            for (String k : keys) {
                Object v = e.getProperty(k);
                if (null == v) continue;
                Statement s = this.context.valueFactory.createStatement((Resource)uri, this.context.valueFactory.createURI("http://tinkerpop.com/pgm/property/" + k), (Value)this.toLiteral(v));
                results.add(s);
            }
        }
    }

    private void generateIdStatement(Element e, URI uri, Collection<Statement> results) {
        Statement s = this.context.valueFactory.createStatement((Resource)uri, PropertyGraphSail.ID, (Value)this.toLiteral(e.getId()));
        results.add(s);
    }

    private void generateLabelStatement(Edge e, URI uri, Collection<Statement> results) {
        Statement s = this.context.valueFactory.createStatement((Resource)uri, PropertyGraphSail.LABEL, (Value)this.context.valueFactory.createLiteral(e.getLabel()));
        results.add(s);
    }

    private void generateHeadStatement(URI edgeUri, URI headUri, Collection<Statement> results) {
        Statement s = this.context.valueFactory.createStatement((Resource)edgeUri, PropertyGraphSail.HEAD, (Value)headUri);
        results.add(s);
    }

    private void generateTailStatement(URI edgeUri, URI tailUri, Collection<Statement> results) {
        Statement s = this.context.valueFactory.createStatement((Resource)edgeUri, PropertyGraphSail.TAIL, (Value)tailUri);
        results.add(s);
    }

    private Literal toLiteral(Object o) {
        if (o instanceof String) {
            return this.context.valueFactory.createLiteral((String)o);
        }
        if (o instanceof Integer) {
            return this.context.valueFactory.createLiteral(((Integer)o).intValue());
        }
        if (o instanceof Long) {
            return this.context.valueFactory.createLiteral(((Long)o).longValue());
        }
        if (o instanceof Boolean) {
            return this.context.valueFactory.createLiteral(((Boolean)o).booleanValue());
        }
        if (o instanceof Byte) {
            return this.context.valueFactory.createLiteral(((Byte)o).byteValue());
        }
        if (o instanceof Short) {
            return this.context.valueFactory.createLiteral(((Short)o).shortValue());
        }
        if (o instanceof Double) {
            return this.context.valueFactory.createLiteral(((Double)o).doubleValue());
        }
        if (o instanceof Float) {
            return this.context.valueFactory.createLiteral(((Float)o).floatValue());
        }
        return null;
    }

    static {
        PropertyGraphSailConnection.addNamespace("prop", "http://tinkerpop.com/pgm/property/");
        PropertyGraphSailConnection.addNamespace("pgm", "http://tinkerpop.com/pgm/ontology#");
        PropertyGraphSailConnection.addNamespace("vertex", "http://tinkerpop.com/pgm/vertex/");
        PropertyGraphSailConnection.addNamespace("edge", "http://tinkerpop.com/pgm/edge/");
        PropertyGraphSailConnection.addNamespace("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
    }

    private class SimpleCloseableIteration<T, E extends Exception>
    implements CloseableIteration<T, E> {
        private final Iterator<T> wrapped;

        public SimpleCloseableIteration(Iterator<T> wrapped) {
            this.wrapped = wrapped;
        }

        public void close() throws E {
        }

        public boolean hasNext() throws E {
            return this.wrapped.hasNext();
        }

        public T next() throws E {
            return this.wrapped.next();
        }

        public void remove() throws E {
            this.wrapped.remove();
        }
    }

    private class StatementIteration
    implements CloseableIteration<Statement, SailException> {
        private final Source[] sources;
        private int i = -1;
        private Collection<Statement> buffer = new LinkedList<Statement>();
        private Iterator<Statement> iter;
        private Source currentSource;

        public StatementIteration(Source ... sources) {
            this.sources = sources;
            this.advanceSource();
            this.advanceBuffer();
        }

        private boolean advanceSource() {
            ++this.i;
            if (this.i >= this.sources.length) {
                return false;
            }
            this.currentSource = this.sources[this.i];
            return true;
        }

        private void advanceBuffer() {
            this.buffer.clear();
            do {
                if (null != this.currentSource && this.currentSource.hasNext()) {
                    this.currentSource.generateNext(this.buffer);
                    this.iter = this.buffer.iterator();
                    continue;
                }
                if (this.advanceSource()) continue;
                this.iter = null;
                return;
            } while (this.buffer.isEmpty());
        }

        public void close() throws SailException {
        }

        public boolean hasNext() throws SailException {
            return null != this.iter;
        }

        public Statement next() throws SailException {
            Statement s = this.iter.next();
            if (!this.iter.hasNext()) {
                this.advanceBuffer();
            }
            return s;
        }

        public void remove() throws SailException {
            throw new UnsupportedOperationException();
        }
    }

    private class Source<T> {
        private final Iterator<T> iterator;
        private final StatementGenerator<T> generator;

        public Source(Iterator<T> iterator, StatementGenerator<T> generator) {
            this.iterator = iterator;
            this.generator = generator;
        }

        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public void generateNext(Collection<Statement> results) {
            this.generator.generate(this.iterator.next(), results);
        }
    }

    private class RelationGenerator
    extends ElementGenerator<Vertex> {
        private final String label;
        private final boolean inVsOut;

        private RelationGenerator(String label, boolean inVsOut) {
            this.label = label;
            this.inVsOut = inVsOut;
        }

        @Override
        public void generate(Vertex source, Collection<Statement> results) {
            if (this.inVsOut) {
                if (null == this.label) {
                    for (Edge e : source.getEdges(Direction.IN, new String[0])) {
                        PropertyGraphSailConnection.this.createEdgeStatement(e, results);
                    }
                } else {
                    for (Edge e : source.getEdges(Direction.IN, new String[]{this.label})) {
                        PropertyGraphSailConnection.this.createEdgeStatement(e, results);
                    }
                }
            } else if (null == this.label) {
                for (Edge e : source.getEdges(Direction.OUT, new String[0])) {
                    PropertyGraphSailConnection.this.createEdgeStatement(e, results);
                }
            } else {
                for (Edge e : source.getEdges(Direction.OUT, new String[]{this.label})) {
                    PropertyGraphSailConnection.this.createEdgeStatement(e, results);
                }
            }
        }
    }

    private class SimpleEdgeGenerator
    extends ElementGenerator<Edge> {
        private final String label;

        private SimpleEdgeGenerator(String label) {
            this.label = label;
        }

        @Override
        public void generate(Edge source, Collection<Statement> results) {
            if (null == this.label || source.getLabel().equals(this.label)) {
                PropertyGraphSailConnection.this.createEdgeStatement(source, results);
            }
        }
    }

    private class FirstClassEdgeGenerator
    extends ElementGenerator<Edge> {
        protected boolean doLabel;
        protected boolean doHead;
        protected boolean doTail;

        private FirstClassEdgeGenerator() {
        }

        public void setDoLabel(boolean doLabel) {
            this.doLabel = doLabel;
        }

        public void setDoHead(boolean doHead) {
            this.doHead = doHead;
        }

        public void setDoTail(boolean doTail) {
            this.doTail = doTail;
        }

        @Override
        public void generate(Edge source, Collection<Statement> results) {
            URI uri = PropertyGraphSailConnection.this.uriForEdge(source);
            this.generateCommon((Element)source, uri, results);
            if (this.doType) {
                PropertyGraphSailConnection.this.generateEdgeTypeStatement(uri, results);
            }
            if (this.doLabel) {
                PropertyGraphSailConnection.this.generateLabelStatement(source, uri, results);
            }
            if (this.doHead) {
                URI headUri = PropertyGraphSailConnection.this.uriForVertex(source.getVertex(Direction.IN));
                PropertyGraphSailConnection.this.generateHeadStatement(uri, headUri, results);
            }
            if (this.doTail) {
                URI tailUri = PropertyGraphSailConnection.this.uriForVertex(source.getVertex(Direction.OUT));
                PropertyGraphSailConnection.this.generateTailStatement(uri, tailUri, results);
            }
        }
    }

    private class VertexGenerator
    extends ElementGenerator<Vertex> {
        private VertexGenerator() {
        }

        @Override
        public void generate(Vertex source, Collection<Statement> results) {
            URI uri = PropertyGraphSailConnection.this.uriForVertex(source);
            if (this.doType) {
                PropertyGraphSailConnection.this.generateVertexTypeStatement(uri, results);
            }
            this.generateCommon((Element)source, uri, results);
        }
    }

    private abstract class ElementGenerator<T>
    implements StatementGenerator<T> {
        protected boolean doId = false;
        protected boolean doType = false;
        protected boolean doProperties = false;
        protected String[] properties = null;

        private ElementGenerator() {
        }

        public void setDoId(boolean doId) {
            this.doId = doId;
        }

        public void setDoType(boolean doType) {
            this.doType = doType;
        }

        public void setDoProperties(boolean doProperties) {
            this.doProperties = doProperties;
        }

        public void setProperties(String[] properties) {
            this.properties = properties;
        }

        protected void generateCommon(Element source, URI uri, Collection<Statement> results) {
            if (this.doProperties) {
                if (null != this.properties) {
                    PropertyGraphSailConnection.this.generatePropertyStatements(source, uri, results, this.properties);
                } else {
                    PropertyGraphSailConnection.this.generatePropertyStatements(source, uri, results, new String[0]);
                }
            }
            if (this.doId) {
                PropertyGraphSailConnection.this.generateIdStatement(source, uri, results);
            }
        }
    }

    private static interface StatementGenerator<T> {
        public void generate(T var1, Collection<Statement> var2);
    }

    private static class SingleItemIterator<T>
    implements Iterator<T> {
        private T item;

        public SingleItemIterator(T item) {
            this.item = item;
        }

        @Override
        public boolean hasNext() {
            return null != this.item;
        }

        @Override
        public T next() {
            T tmp = this.item;
            this.item = null;
            return tmp;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

