/*
 * Decompiled with CFR 0.152.
 */
package org.xadisk.filesystem.pools;

import java.io.IOException;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.xadisk.filesystem.pools.PooledSelector;
import org.xadisk.filesystem.pools.ResourcePool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectorPool
implements ResourcePool<PooledSelector> {
    private final ConcurrentLinkedQueue<PooledSelector> freeSelectors;
    private final int idleTime;

    public SelectorPool(int idleTime) {
        this.idleTime = idleTime;
        this.freeSelectors = new ConcurrentLinkedQueue();
    }

    @Override
    public PooledSelector checkOut() {
        PooledSelector temp = this.lookIntoCurrentPool();
        if (temp != null) {
            return temp;
        }
        temp = this.allocateNewInCurrentPool();
        if (temp != null) {
            return temp;
        }
        return null;
    }

    private PooledSelector lookIntoCurrentPool() {
        PooledSelector freeSelector = this.freeSelectors.poll();
        return freeSelector;
    }

    private PooledSelector allocateNewInCurrentPool() {
        PooledSelector newSelector = null;
        try {
            newSelector = new PooledSelector();
            return newSelector;
        }
        catch (IOException ioe) {
            return null;
        }
    }

    @Override
    public void checkIn(PooledSelector selector) {
        selector.markFree();
        this.freeSelectors.offer(selector);
    }

    @Override
    public void freeIdleMembers() {
        PooledSelector selector;
        long now = System.currentTimeMillis() / 1000L;
        while ((selector = this.freeSelectors.peek()) != null && now - selector.getLastFreed() > (long)this.idleTime) {
            this.freeSelectors.remove(selector);
        }
    }
}

