/*
 * Decompiled with CFR 0.152.
 */
package org.xadisk.filesystem.utilities;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.xadisk.filesystem.NativeXAFileSystem;
import org.xadisk.filesystem.utilities.MiscUtils;

public class FileIOUtility {
    public static void renameTo(File src, File dest) throws IOException {
        if (!src.renameTo(dest)) {
            if (FileIOUtility.renamePossible(src, dest)) {
                int retryCount = 1;
                while (!src.renameTo(dest)) {
                    FileIOUtility.doGCBeforeRetry(retryCount++, src);
                    if (!src.renameTo(dest)) {
                        if (src.isDirectory()) continue;
                        FileIOUtility.copyFile(src, dest, false);
                        dest.setLastModified(src.lastModified());
                        FileIOUtility.deleteFile(src);
                    }
                    break;
                }
            } else {
                throw new IOException("Rename not feasible from " + src + " to " + dest);
            }
        }
    }

    private static boolean renamePossible(File src, File dest) {
        return src.exists() && !dest.exists() && src.getParentFile().canWrite() && dest.getParentFile().canWrite();
    }

    public static void deleteFile(File f) throws IOException {
        if (f.delete()) {
            return;
        }
        if (!f.getParentFile().canWrite()) {
            throw new IOException("Parent directory not writable.");
        }
        if (!f.exists()) {
            throw new IOException("File does not exist.");
        }
        int retryCount = 1;
        while (!f.delete()) {
            FileIOUtility.doGCBeforeRetry(retryCount++, f);
        }
    }

    private static void deleteEmptyDirectory(File dir) throws IOException {
        FileIOUtility.deleteFile(dir);
    }

    public static void deleteDirectoryRecursively(File dir) throws IOException {
        if (!dir.exists()) {
            return;
        }
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                FileIOUtility.deleteDirectoryRecursively(files[i]);
                continue;
            }
            FileIOUtility.deleteFile(files[i]);
        }
        FileIOUtility.deleteEmptyDirectory(dir);
    }

    public static void createFile(File f) throws IOException {
        if (f.createNewFile()) {
            return;
        }
        if (f.exists()) {
            throw new IOException("File already exists.");
        }
        if (!f.getParentFile().canWrite()) {
            throw new IOException("Parent directory not writable.");
        }
        int retryCount = 1;
        while (!f.createNewFile()) {
            FileIOUtility.doGCBeforeRetry(retryCount++, f);
        }
    }

    public static void createDirectory(File dir) throws IOException {
        if (dir.mkdir()) {
            return;
        }
        if (dir.exists()) {
            throw new IOException("File already exists.");
        }
        if (!dir.getParentFile().canWrite()) {
            throw new IOException("Parent directory not writable.");
        }
        int retryCount = 1;
        while (!dir.mkdir()) {
            FileIOUtility.doGCBeforeRetry(retryCount++, dir);
        }
    }

    public static void createDirectoriesIfRequired(File dir) throws IOException {
        if (dir.isDirectory()) {
            return;
        }
        FileIOUtility.createDirectoriesIfRequired(dir.getParentFile());
        FileIOUtility.createDirectory(dir);
    }

    public static String[] listDirectoryContents(File dir) throws IOException {
        if (!dir.isDirectory()) {
            throw new IOException("The directory doesn't exist.");
        }
        if (!dir.canRead()) {
            throw new IOException("The directory is not readable.");
        }
        String[] children = dir.list();
        int retryCount = 1;
        while (children == null) {
            FileIOUtility.doGCBeforeRetry(retryCount++, dir);
            children = dir.list();
        }
        return children;
    }

    private static void doGCBeforeRetry(int retryCount, File f) throws IOException {
        if (retryCount == 5) {
            throw new IOException("The i/o operation could not be completed for the file/directory with path [" + f.getAbsolutePath() + "] due " + "to an unknown reason.");
        }
        System.gc();
        System.gc();
        System.gc();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw (IOException)new IOException().initCause(ie);
        }
    }

    public static void readFromChannel(FileChannel fc, ByteBuffer buffer, int bufferOffset, int num) throws IOException, EOFException {
        buffer.position(bufferOffset);
        if (buffer.remaining() < num) {
            throw new BufferUnderflowException();
        }
        buffer.limit(bufferOffset + num);
        int t = 0;
        for (int numRead = 0; numRead < num; numRead += t) {
            t = fc.read(buffer);
            if (t != -1) continue;
            throw new EOFException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File src, File dest, boolean append) throws IOException {
        FileInputStream srcFileInputStream = null;
        FileOutputStream destFileOutputStream = null;
        try {
            srcFileInputStream = new FileInputStream(src);
            destFileOutputStream = new FileOutputStream(dest, append);
            FileChannel srcChannel = srcFileInputStream.getChannel();
            FileChannel destChannel = destFileOutputStream.getChannel();
            long contentLength = srcChannel.size();
            for (long num = 0L; num < contentLength; num += srcChannel.transferTo(num, NativeXAFileSystem.maxTransferToChannel(contentLength - num), destChannel)) {
            }
            destChannel.force(false);
        }
        catch (Throwable throwable) {
            MiscUtils.closeAll(srcFileInputStream, destFileOutputStream);
            throw throwable;
        }
        MiscUtils.closeAll(srcFileInputStream, destFileOutputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(InputStream srcStream, File dest, boolean append) throws IOException {
        FileOutputStream destStream = null;
        try {
            destStream = new FileOutputStream(dest, append);
            byte[] b = new byte[1000];
            int numRead = 0;
            while ((numRead = srcStream.read(b)) != -1) {
                destStream.write(b, 0, numRead);
            }
            destStream.flush();
        }
        catch (Throwable throwable) {
            MiscUtils.closeAll(srcStream, destStream);
            throw throwable;
        }
        MiscUtils.closeAll(srcStream, destStream);
    }
}

