/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.dawg;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.query.Binding;
import org.openrdf.query.BindingSet;
import org.openrdf.query.QueryResultHandlerException;
import org.openrdf.query.TupleQueryResultHandler;
import org.openrdf.query.TupleQueryResultHandlerException;
import org.openrdf.query.dawg.DAWGTestResultSetSchema;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;

public class DAWGTestResultSetWriter
implements TupleQueryResultHandler {
    private final RDFHandler rdfHandler;
    private final ValueFactory vf;
    private BNode resultSetNode;
    private Map<BNode, BNode> bnodeMap = new HashMap<BNode, BNode>();

    public DAWGTestResultSetWriter(RDFHandler rdfHandler) {
        this(rdfHandler, (ValueFactory)new ValueFactoryImpl());
    }

    public DAWGTestResultSetWriter(RDFHandler rdfHandler, ValueFactory vf) {
        this.rdfHandler = rdfHandler;
        this.vf = vf;
    }

    @Override
    public void startQueryResult(List<String> bindingNames) throws TupleQueryResultHandlerException {
        try {
            this.rdfHandler.startRDF();
            this.resultSetNode = this.vf.createBNode();
            this.bnodeMap.clear();
            this.reportStatement((Resource)this.resultSetNode, RDF.TYPE, (Value)DAWGTestResultSetSchema.RESULTSET);
            for (String bindingName : bindingNames) {
                Literal bindingNameLit = this.vf.createLiteral(bindingName);
                this.reportStatement((Resource)this.resultSetNode, DAWGTestResultSetSchema.RESULTVARIABLE, (Value)bindingNameLit);
            }
        }
        catch (RDFHandlerException e) {
            throw new TupleQueryResultHandlerException(e);
        }
    }

    @Override
    public void endQueryResult() throws TupleQueryResultHandlerException {
        this.resultSetNode = null;
        try {
            this.rdfHandler.endRDF();
        }
        catch (RDFHandlerException e) {
            throw new TupleQueryResultHandlerException(e);
        }
    }

    @Override
    public void handleSolution(BindingSet bindingSet) throws TupleQueryResultHandlerException {
        try {
            BNode solutionNode = this.vf.createBNode();
            this.reportStatement((Resource)this.resultSetNode, DAWGTestResultSetSchema.SOLUTION, (Value)solutionNode);
            for (Binding binding : bindingSet) {
                BNode bindingNode = this.vf.createBNode();
                this.reportStatement((Resource)solutionNode, DAWGTestResultSetSchema.BINDING, (Value)bindingNode);
                this.reportStatement((Resource)bindingNode, DAWGTestResultSetSchema.VARIABLE, (Value)this.vf.createLiteral(binding.getName()));
                Value value = binding.getValue();
                if (value instanceof BNode) {
                    BNode mappedBNode = this.bnodeMap.get(value);
                    if (mappedBNode == null) {
                        mappedBNode = this.vf.createBNode();
                        this.bnodeMap.put((BNode)value, mappedBNode);
                    }
                    value = mappedBNode;
                }
                this.reportStatement((Resource)bindingNode, DAWGTestResultSetSchema.VALUE, value);
            }
        }
        catch (RDFHandlerException e) {
            throw new TupleQueryResultHandlerException(e);
        }
    }

    private void reportStatement(Resource subject, URI predicate, Value object) throws RDFHandlerException {
        this.rdfHandler.handleStatement(this.vf.createStatement(subject, predicate, object));
    }

    @Override
    public void handleBoolean(boolean value) throws QueryResultHandlerException {
        throw new UnsupportedOperationException("Cannot handle boolean results");
    }

    @Override
    public void handleLinks(List<String> linkUrls) throws QueryResultHandlerException {
    }
}

