/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.apps.java.archives.listener;

import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.util.wrappers.event.listener.GraphChangedListener;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.commons.codec.digest.DigestUtils;
import org.jboss.forge.addon.dependencies.Coordinate;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.ArchiveModel;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.jboss.windup.graph.service.ArchiveService;
import org.jboss.windup.graph.service.GraphService;
import org.jboss.windup.rules.apps.java.archives.identify.ArchiveIdentificationService;
import org.jboss.windup.rules.apps.java.archives.model.ArchiveCoordinateModel;
import org.jboss.windup.rules.apps.java.archives.model.IdentifiedArchiveModel;
import org.jboss.windup.rules.apps.java.archives.model.IgnoredArchiveModel;
import org.jboss.windup.util.exception.WindupException;

public class ArchiveIdentificationGraphChangedListener
implements GraphChangedListener {
    private static final Logger log = Logger.getLogger(ArchiveIdentificationGraphChangedListener.class.getName());
    private final ArchiveIdentificationService identifier;
    private GraphContext context;

    public ArchiveIdentificationGraphChangedListener setGraphContext(GraphContext context) {
        this.context = context;
        return this;
    }

    public ArchiveIdentificationGraphChangedListener(GraphContext context, ArchiveIdentificationService identifier) {
        this.identifier = identifier;
        this.context = context;
    }

    public void vertexPropertyChanged(Vertex vertex, String key, Object oldValue, Object setValue) {
        if ("ArchiveModel:archiveName".equals(key)) {
            ArchiveService archiveService = new ArchiveService(this.context);
            ArchiveModel archive = (ArchiveModel)archiveService.frame(vertex);
            this.setArchiveHashes(archive);
            Coordinate coordinate = this.identifier.getCoordinate(archive.getSHA1Hash());
            if (coordinate != null) {
                log.info("Identified archive: [" + archive.getFilePath() + "] as [" + coordinate + "] will not be unzipped or analyzed.");
                IdentifiedArchiveModel identifiedArchive = (IdentifiedArchiveModel)GraphService.addTypeToModel((GraphContext)this.context, (WindupVertexFrame)archive, IdentifiedArchiveModel.class);
                ArchiveCoordinateModel coordinateModel = (ArchiveCoordinateModel)new GraphService(this.context, ArchiveCoordinateModel.class).create();
                coordinateModel.setArtifactId(coordinate.getArtifactId());
                coordinateModel.setGroupId(coordinate.getGroupId());
                coordinateModel.setVersion(coordinate.getVersion());
                coordinateModel.setClassifier(coordinate.getClassifier());
                identifiedArchive.setCoordinate(coordinateModel);
                IgnoredArchiveModel ignoredArchive = (IgnoredArchiveModel)GraphService.addTypeToModel((GraphContext)this.context, (WindupVertexFrame)archive, IgnoredArchiveModel.class);
                ignoredArchive.setIgnoredRegex("Known open-source library");
            } else {
                log.info("Archive not identified: " + archive.getFilePath());
            }
        }
    }

    private void setArchiveHashes(ArchiveModel payload) {
        Throwable throwable;
        InputStream is;
        if (payload.getMD5Hash() == null) {
            try {
                is = payload.asInputStream();
                throwable = null;
                try {
                    String md5 = DigestUtils.md5Hex((InputStream)is);
                    payload.setMD5Hash(md5);
                }
                catch (Throwable x2) {
                    throwable = x2;
                    throw x2;
                }
                finally {
                    if (is != null) {
                        if (throwable != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                        } else {
                            is.close();
                        }
                    }
                }
            }
            catch (IOException e) {
                throw new WindupException("Failed to read archive file at: " + payload.getFilePath() + " due to: " + e.getMessage(), (Throwable)e);
            }
        }
        if (payload.getSHA1Hash() == null) {
            try {
                is = payload.asInputStream();
                throwable = null;
                try {
                    String sha1 = DigestUtils.sha1Hex((InputStream)is);
                    payload.setSHA1Hash(sha1);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (is != null) {
                        if (throwable != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                        } else {
                            is.close();
                        }
                    }
                }
            }
            catch (IOException e) {
                throw new WindupException("Failed to read archive file at: " + payload.getFilePath() + " due to: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public void vertexPropertyRemoved(Vertex vertex, String key, Object removedValue) {
    }

    public void vertexAdded(Vertex vertex) {
    }

    public void vertexRemoved(Vertex vertex, Map<String, Object> props) {
    }

    public void edgeAdded(Edge edge) {
    }

    public void edgePropertyChanged(Edge edge, String key, Object oldValue, Object setValue) {
    }

    public void edgePropertyRemoved(Edge edge, String key, Object removedValue) {
    }

    public void edgeRemoved(Edge edge, Map<String, Object> props) {
    }
}

