/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.bootstrap;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.jboss.forge.furnace.Furnace;
import org.jboss.forge.furnace.impl.addons.AddonRepositoryImpl;
import org.jboss.forge.furnace.repositories.AddonRepository;
import org.jboss.forge.furnace.repositories.AddonRepositoryMode;
import org.jboss.forge.furnace.repositories.MutableAddonRepository;
import org.jboss.forge.furnace.se.FurnaceFactory;
import org.jboss.forge.furnace.spi.ContainerLifecycleListener;
import org.jboss.forge.furnace.util.OperatingSystemUtils;
import org.jboss.forge.furnace.versions.EmptyVersion;
import org.jboss.forge.furnace.versions.SingleVersion;
import org.jboss.forge.furnace.versions.Version;
import org.jboss.windup.bootstrap.BootstrapCommand;
import org.jboss.windup.bootstrap.BootstrapFurnaceService;
import org.jboss.windup.bootstrap.ConsoleProgressMonitor;
import org.jboss.windup.bootstrap.GreetingListener;
import org.jboss.windup.config.ConfigurationOption;
import org.jboss.windup.config.InputType;
import org.jboss.windup.config.ValidationResult;
import org.jboss.windup.config.metadata.RuleProviderRegistryCache;
import org.jboss.windup.exec.WindupProcessor;
import org.jboss.windup.exec.WindupProgressMonitor;
import org.jboss.windup.exec.configuration.WindupConfiguration;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.GraphContextFactory;
import org.jboss.windup.util.PathUtil;

public class Bootstrap {
    private static final long MAX_COMPLETION_AGE = 864000000L;
    private BootstrapFurnaceService furnaceService = null;
    private boolean batchMode = false;

    public static void main(String[] args) {
        ArrayList<String> bootstrapArgs = new ArrayList<String>();
        for (String arg : args) {
            if (Bootstrap.handleAsSystemProperty(arg)) continue;
            bootstrapArgs.add(arg);
        }
        File rulesDir = new File(Bootstrap.getUserWindupDir(), "rules");
        if (!rulesDir.exists()) {
            rulesDir.mkdirs();
        }
        String defaultLog = new File(Bootstrap.getUserWindupDir(), "log/windup.log").getAbsolutePath();
        String logDir = System.getProperty("org.jboss.forge.log.file", defaultLog);
        System.setProperty("org.jboss.forge.log.file", logDir);
        String logManagerName = Bootstrap.getServiceName(Bootstrap.class.getClassLoader(), "java.util.logging.LogManager");
        if (logManagerName != null) {
            System.setProperty("java.util.logging.manager", logManagerName);
        }
        new Bootstrap().run(bootstrapArgs);
    }

    private void run(List<String> args) {
        try {
            Furnace furnace = FurnaceFactory.getInstance();
            this.furnaceService = new BootstrapFurnaceService(furnace);
            this.processArguments(args, this.furnaceService);
            this.furnaceService.getFurnace().stop();
        }
        catch (Throwable t) {
            System.err.println("Windup execution failed due to: " + t.getMessage());
            t.printStackTrace();
        }
    }

    private static boolean handleAsSystemProperty(String argument) {
        String value;
        String name;
        if (!argument.startsWith("-D")) {
            return false;
        }
        int index = argument.indexOf("=");
        if (index == -1) {
            name = argument.substring(2);
            value = "true";
        } else {
            name = argument.substring(2, index);
            value = argument.substring(index + 1);
        }
        System.setProperty(name, value);
        return true;
    }

    private void processArguments(List<String> arguments, BootstrapFurnaceService furnaceService) {
        String arg;
        int i;
        Furnace furnace = furnaceService.getFurnace();
        System.setProperty("forge.standalone", "false");
        BootstrapCommand command = null;
        if (arguments.contains("-help") || arguments.contains("--help") || arguments.contains("-h") || arguments.contains("/?") || arguments.contains("/help")) {
            command = BootstrapCommand.DISPLAY_HELP;
        }
        String addonID = null;
        ArrayList<String> unknownArgs = new ArrayList<String>();
        ArrayList<File> mutableRepos = new ArrayList<File>();
        ArrayList<File> immutableRepos = new ArrayList<File>();
        for (i = 0; i < arguments.size(); ++i) {
            arg = arguments.get(i);
            if ("--install".equals(arg) || "-i".equals(arg)) {
                command = BootstrapCommand.INSTALL_ADDON;
                addonID = arguments.get(++i);
                continue;
            }
            if ("--remove".equals(arg) || "-r".equals(arg)) {
                command = BootstrapCommand.REMOVE_ADDON;
                addonID = arguments.get(++i);
                continue;
            }
            if ("--list".equals(arg) || "-l".equals(arg)) {
                command = BootstrapCommand.LIST_INSTALLED_ADDONS;
                continue;
            }
            if ("--addonDir".equals(arg) || "-a".equals(arg)) {
                mutableRepos.add(new File(arguments.get(++i)));
                continue;
            }
            if ("--immutableAddonDir".equals(arg) || "-m".equals(arg)) {
                immutableRepos.add(new File(arguments.get(++i)));
                continue;
            }
            if ("--batchMode".equals(arg) || "-b".equals(arg)) {
                this.batchMode = true;
                continue;
            }
            if ("--evaluate".equals(arg) || "-e".equals(arg)) {
                System.out.println("\"" + arg + "\" is no longer required!");
                ++i;
                continue;
            }
            if ("--debug".equals(arg) || "-d".equals(arg)) continue;
            if ("--version".equals(arg) || "-v".equals(arg)) {
                System.out.println(Bootstrap.getVersionString());
                continue;
            }
            if ("--listTags".equals(arg)) {
                command = BootstrapCommand.LIST_TAGS;
                continue;
            }
            if ("--listSourceTechnologies".equals(arg)) {
                command = BootstrapCommand.LIST_SOURCE_TECHNOLOGIES;
                continue;
            }
            if ("--listTargetTechnologies".equals(arg)) {
                command = BootstrapCommand.LIST_TARGET_TECHNOLOGIES;
                continue;
            }
            if ("--generateCompletionData".equals(arg)) {
                command = BootstrapCommand.GENERATE_COMPLETION_DATA;
                continue;
            }
            unknownArgs.add(arg);
        }
        Bootstrap.addReposToFurnace(furnace, mutableRepos, immutableRepos);
        Bootstrap.setupNonInteractive(furnace);
        for (i = 0; i < arguments.size(); ++i) {
            arg = arguments.get(i);
            if (!unknownArgs.contains(arg)) continue;
            arguments.set(i, null);
        }
        ArrayList<String> argsList = new ArrayList<String>(arguments.size() + 2);
        for (String arg2 : arguments) {
            if (arg2 == null) continue;
            argsList.add(arg2);
        }
        ArrayList<String> windupArguments = new ArrayList<String>();
        if (!unknownArgs.isEmpty()) {
            Bootstrap.setupNonInteractive(furnace);
            for (String windupArg : unknownArgs) {
                windupArguments.add(windupArg);
            }
        }
        if (!Bootstrap.containsMutableRepository(furnace.getRepositories())) {
            furnaceService.getFurnace().addRepository(AddonRepositoryMode.MUTABLE, new File(Bootstrap.getUserWindupDir(), "addons"));
        }
        if (command == null && !windupArguments.isEmpty()) {
            command = BootstrapCommand.RUN_WINDUP;
        } else if (command == null) {
            command = BootstrapCommand.DISPLAY_HELP;
        }
        switch (command) {
            case LIST_INSTALLED_ADDONS: {
                furnaceService.list();
                break;
            }
            case INSTALL_ADDON: {
                furnaceService.install(addonID, this.batchMode);
                break;
            }
            case REMOVE_ADDON: {
                furnaceService.remove(addonID, this.batchMode);
                break;
            }
            case GENERATE_COMPLETION_DATA: {
                break;
            }
        }
        try {
            if (command == BootstrapCommand.RUN_WINDUP) {
                furnace.addContainerLifecycleListener((ContainerLifecycleListener)new GreetingListener());
            }
            Future<Furnace> future = furnaceService.start(true);
            future.get();
        }
        catch (Exception e) {
            System.out.println("Failed to start Windup!");
            if (e.getMessage() != null) {
                System.out.println("Failure reason: " + e.getMessage());
            }
            e.printStackTrace();
        }
        switch (command) {
            case GENERATE_COMPLETION_DATA: {
                this.generateCompletionData(true);
                break;
            }
            case DISPLAY_HELP: {
                this.displayHelp();
                break;
            }
            case LIST_TAGS: {
                this.listTags();
                break;
            }
            case LIST_SOURCE_TECHNOLOGIES: {
                this.listSourceTechnologies();
                break;
            }
            case LIST_TARGET_TECHNOLOGIES: {
                this.listTargetTechnologies();
                break;
            }
            case RUN_WINDUP: {
                this.runWindup(windupArguments);
                break;
            }
            default: {
                this.displayHelp();
            }
        }
    }

    private void listTags() {
        this.printValuesSorted("Available tags", this.getRuleProviderRegistryCache().getAvailableTags());
    }

    private void listSourceTechnologies() {
        this.printValuesSorted("Available source technologies", this.getRuleProviderRegistryCache().getAvailableSourceTechnologies());
    }

    private void listTargetTechnologies() {
        this.printValuesSorted("Available target technologies", this.getRuleProviderRegistryCache().getAvailableTargetTechnologies());
    }

    private void printValuesSorted(String message, Set<String> values) {
        System.out.println();
        System.out.println(message + ":");
        ArrayList<String> sorted = new ArrayList<String>(values);
        Collections.sort(sorted);
        for (String value : sorted) {
            System.out.println("\t" + value);
        }
    }

    private void generateCompletionData(boolean force) {
        Path completionPath = PathUtil.getWindupHome().resolve("cache").resolve("bash-completion").resolve("bash-completion.data");
        if (!force && Files.isRegularFile(completionPath, new LinkOption[0])) {
            try {
                FileTime modifiedTime = Files.getLastModifiedTime(completionPath, new LinkOption[0]);
                long age = System.currentTimeMillis() - modifiedTime.to(TimeUnit.MILLISECONDS);
                if (age <= 864000000L) {
                    return;
                }
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        try {
            if (!Files.isDirectory(completionPath.getParent(), new LinkOption[0])) {
                Files.createDirectories(completionPath.getParent(), new FileAttribute[0]);
            }
            try (FileWriter writer = new FileWriter(completionPath.toFile());){
                writer.write("listTags:none" + OperatingSystemUtils.getLineSeparator());
                writer.write("listSourceTechnologies:none" + OperatingSystemUtils.getLineSeparator());
                writer.write("listTargetTechnologies:none" + OperatingSystemUtils.getLineSeparator());
                writer.write("install:none" + OperatingSystemUtils.getLineSeparator());
                writer.write("remote:none" + OperatingSystemUtils.getLineSeparator());
                writer.write("addonDir:file" + OperatingSystemUtils.getLineSeparator());
                writer.write("immutableAddonDir:file" + OperatingSystemUtils.getLineSeparator());
                writer.write("batchMode:none" + OperatingSystemUtils.getLineSeparator());
                writer.write("debug:none" + OperatingSystemUtils.getLineSeparator());
                writer.write("help:none" + OperatingSystemUtils.getLineSeparator());
                writer.write("version:none" + OperatingSystemUtils.getLineSeparator());
                Iterable optionIterable = WindupConfiguration.getWindupConfigurationOptions((Furnace)this.furnaceService.getFurnace());
                for (ConfigurationOption option : optionIterable) {
                    StringBuilder line = new StringBuilder();
                    line.append(option.getName()).append(":");
                    if (File.class.isAssignableFrom(option.getType())) {
                        line.append("file");
                    } else if (option.getUIType() == InputType.SELECT_MANY || option.getUIType() == InputType.SELECT_ONE) {
                        line.append("list").append(":");
                        for (Object availableValue : option.getAvailableValues()) {
                            line.append(availableValue).append(" ");
                        }
                    } else {
                        line.append("none");
                    }
                    line.append(OperatingSystemUtils.getLineSeparator());
                    writer.write(line.toString());
                }
            }
        }
        catch (IOException e) {
            System.err.println("WARNING: Unable to create bash completion file in \"" + completionPath + "\" due to: " + e.getMessage());
        }
    }

    private void runWindup(List<String> arguments) {
        String promptMsg;
        Iterable optionIterable = WindupConfiguration.getWindupConfigurationOptions((Furnace)this.furnaceService.getFurnace());
        HashMap<String, ConfigurationOption> options = new HashMap<String, ConfigurationOption>();
        for (ConfigurationOption option : optionIterable) {
            options.put(option.getName().toUpperCase(), option);
        }
        HashMap<String, Object> optionValues = new HashMap<String, Object>();
        for (int i = 0; i < arguments.size(); ++i) {
            String argument = arguments.get(i);
            String optionName = this.getOptionName(argument);
            if (optionName == null) {
                System.err.println("WARNING: Unrecognized command-line argument: " + argument);
                continue;
            }
            ConfigurationOption option = (ConfigurationOption)options.get(optionName.toUpperCase());
            if (option == null) {
                System.err.println("WARNING: Unrecognized command-line argument: " + argument);
                continue;
            }
            if (option.getUIType() == InputType.MANY || option.getUIType() == InputType.SELECT_MANY) {
                ArrayList<Object> values = new ArrayList<Object>();
                ++i;
                while (i < arguments.size()) {
                    if (this.getOptionName(arguments.get(i)) != null && options.containsKey(this.getOptionName(arguments.get(i).toUpperCase()))) {
                        --i;
                        break;
                    }
                    String valueString = arguments.get(i);
                    if (valueString.contains(" ")) {
                        for (String value : valueString.split(" ")) {
                            values.add(this.convertType(option.getType(), value));
                        }
                    } else {
                        values.add(this.convertType(option.getType(), valueString));
                    }
                    ++i;
                }
                if (optionValues.containsKey(option.getName())) {
                    ((List)optionValues.get(option.getName())).addAll(values);
                    continue;
                }
                optionValues.put(option.getName(), values);
                continue;
            }
            if (Boolean.class.isAssignableFrom(option.getType())) {
                optionValues.put(option.getName(), true);
                continue;
            }
            String valueString = arguments.get(++i);
            optionValues.put(option.getName(), this.convertType(option.getType(), valueString));
        }
        this.setDefaultOutputPath(optionValues);
        boolean validationSuccess = this.validateOptionValues(options, optionValues);
        if (!validationSuccess) {
            return;
        }
        WindupConfiguration windupConfiguration = new WindupConfiguration();
        for (Map.Entry optionEntry : options.entrySet()) {
            ConfigurationOption option = (ConfigurationOption)optionEntry.getValue();
            windupConfiguration.setOptionValue(option.getName(), optionValues.get(option.getName()));
        }
        try {
            windupConfiguration.useDefaultDirectories();
        }
        catch (IOException e) {
            System.err.println("ERROR: Failed to create default directories due to: " + e.getMessage());
            return;
        }
        Boolean overwrite = (Boolean)windupConfiguration.getOptionMap().get("overwrite");
        if (overwrite == null) {
            overwrite = false;
        }
        if (!overwrite.booleanValue() && this.pathNotEmpty(windupConfiguration.getOutputDirectory().toFile()) && !this.prompt(promptMsg = "Overwrite all contents of \"" + windupConfiguration.getOutputDirectory().toString() + "\" (anything already in the directory will be deleted)?", false)) {
            String outputPath = windupConfiguration.getOutputDirectory().toString();
            System.err.println("Files exist in " + outputPath + ", but --overwrite not specified. Aborting!");
            return;
        }
        this.generateCompletionData(false);
        FileUtils.deleteQuietly((File)windupConfiguration.getOutputDirectory().toFile());
        Path graphPath = windupConfiguration.getOutputDirectory().resolve("graph");
        try (GraphContext graphContext = this.getGraphContextFactory().create(graphPath);){
            ConsoleProgressMonitor progressMonitor = new ConsoleProgressMonitor();
            windupConfiguration.setProgressMonitor((WindupProgressMonitor)progressMonitor).setGraphContext(graphContext);
            this.getWindupProcessor().execute(windupConfiguration);
            Path indexHtmlPath = windupConfiguration.getOutputDirectory().resolve("index.html").normalize().toAbsolutePath();
            System.out.println("Windup report created: " + indexHtmlPath + System.getProperty("line.separator") + "              Access it at this URL: " + indexHtmlPath.toUri());
        }
        catch (Exception e) {
            System.err.println("Windup Execution failed due to: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private boolean validateOptionValues(Map<String, ConfigurationOption> options, Map<String, Object> optionValues) {
        for (Map.Entry<String, ConfigurationOption> optionEntry : options.entrySet()) {
            ConfigurationOption option = optionEntry.getValue();
            ValidationResult result = option.validate(optionValues.get(option.getName()));
            switch (result.getLevel()) {
                case ERROR: {
                    System.err.println("ERROR: " + result.getMessage());
                    return false;
                }
                case PROMPT_TO_CONTINUE: {
                    if (this.prompt(result.getMessage(), result.getPromptDefault())) break;
                    return false;
                }
                case WARNING: {
                    System.err.println("WARNING: " + result.getMessage());
                    break;
                }
            }
        }
        return true;
    }

    private void setDefaultOutputPath(Map<String, Object> optionValues) {
        File inputFile;
        if (!optionValues.containsKey("output") && (inputFile = (File)optionValues.get("input")) != null) {
            File outputFile = new File(inputFile.getAbsoluteFile().getParentFile(), inputFile.getName() + ".report");
            optionValues.put("output", outputFile);
        }
    }

    private Object convertType(Class<?> type, String input) {
        if (File.class.isAssignableFrom(type)) {
            return new File(input);
        }
        if (Boolean.class.isAssignableFrom(type)) {
            return Boolean.valueOf(input);
        }
        if (String.class.isAssignableFrom(type)) {
            return input;
        }
        throw new RuntimeException("Internal Error! Unrecognized type " + type.getCanonicalName());
    }

    private boolean prompt(String message, boolean defaultValue) {
        if (this.batchMode) {
            return defaultValue;
        }
        String defaultMessage = defaultValue ? " [Y,n] " : " [y,N] ";
        String line = System.console().readLine(message + defaultMessage, new Object[0]).trim();
        if ("y".equalsIgnoreCase(line)) {
            return true;
        }
        if ("n".equalsIgnoreCase(line)) {
            return false;
        }
        return defaultValue;
    }

    private boolean pathNotEmpty(File f) {
        if (f.exists() && !f.isDirectory()) {
            return true;
        }
        return f.isDirectory() && f.listFiles() != null && f.listFiles().length > 0;
    }

    private RuleProviderRegistryCache getRuleProviderRegistryCache() {
        return (RuleProviderRegistryCache)this.furnaceService.getFurnace().getAddonRegistry(new AddonRepository[0]).getServices(RuleProviderRegistryCache.class).get();
    }

    private WindupProcessor getWindupProcessor() {
        return (WindupProcessor)this.furnaceService.getFurnace().getAddonRegistry(new AddonRepository[0]).getServices(WindupProcessor.class).get();
    }

    private GraphContextFactory getGraphContextFactory() {
        return (GraphContextFactory)this.furnaceService.getFurnace().getAddonRegistry(new AddonRepository[0]).getServices(GraphContextFactory.class).get();
    }

    private String getOptionName(String argument) {
        if (argument.startsWith("--")) {
            return argument.substring(2);
        }
        if (argument.startsWith("-")) {
            return argument.substring(1);
        }
        return null;
    }

    private void displayHelp() {
        Iterable windupOptions = WindupConfiguration.getWindupConfigurationOptions((Furnace)this.furnaceService.getFurnace());
        StringBuilder sb = new StringBuilder();
        sb.append("Usage: windup [OPTION]... PARAMETER ... \n");
        sb.append("Extendable migration analysis, at your fingertips. \n");
        sb.append("\n");
        sb.append("\nWindup Options:\n");
        for (ConfigurationOption option : windupOptions) {
            sb.append("--").append(option.getName()).append("\n");
            sb.append("\t").append(option.getDescription()).append("\n");
        }
        sb.append("--listTags\n");
        sb.append("\t List all available tags\n");
        sb.append("--listSourceTechnologies\n");
        sb.append("\t List all available source technologies\n");
        sb.append("--listTargetTechnologies\n");
        sb.append("\t List all available target technologies\n");
        sb.append("\nForge Options:\n");
        sb.append("-i, --install GROUP_ID:ARTIFACT_ID[:VERSION]\n");
        sb.append("\t install the required addons and exit. ex: `windup -i core-addon-x` or `windup -i org.example.addon:example,1.0.0` \n");
        sb.append("-r, --remove GROUP_ID:ARTIFACT_ID[:VERSION]\n");
        sb.append("\t remove the required addons and exit. ex: `windup -r core-addon-x` or `windup -r org.example.addon:example,1.0.0` \n");
        sb.append("-l, --list\n");
        sb.append("\t list installed addons and exit \n");
        sb.append("-a, --addonDir DIR\n");
        sb.append("\t add the given directory for use as a custom addon repository \n");
        sb.append("-m, --immutableAddonDir DIR\n");
        sb.append("\t add the given directory for use as a custom immutable addon repository (read only) \n");
        sb.append("-b, --batchMode\n");
        sb.append("\t run Forge in batch mode and does not prompt for confirmation (exits immediately after running) \n");
        sb.append("-d, --debug\n");
        sb.append("\t run Forge in debug mode (wait on port 8000 for a debugger to attach) \n");
        sb.append("-h, --help\n");
        sb.append("\t display this help and exit \n");
        sb.append("-v, --version\n");
        sb.append("\t output version information and exit \n");
        System.out.println(sb.toString());
        this.furnaceService.getFurnace().stop();
    }

    private static void addReposToFurnace(Furnace furnace, List<File> mutableRepos, List<File> immutableRepos) {
        for (File repo : mutableRepos) {
            furnace.addRepository(AddonRepositoryMode.MUTABLE, repo);
        }
        for (File repo : immutableRepos) {
            furnace.addRepository(AddonRepositoryMode.IMMUTABLE, repo);
        }
    }

    private static void setupNonInteractive(Furnace furnace) {
        furnace.setServerMode(true);
        System.setProperty("INTERACTIVE", "false");
        System.setProperty("forge.shell.evaluate", "true");
    }

    private static boolean containsMutableRepository(List<AddonRepository> repositories) {
        boolean result = false;
        for (AddonRepository repository : repositories) {
            if (!(repository instanceof MutableAddonRepository)) continue;
            result = true;
            break;
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getServiceName(ClassLoader classLoader, String className) {
        try (InputStream stream = classLoader.getResourceAsStream("META-INF/services/" + className);){
            if (stream == null) {
                String string = null;
                return string;
            }
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream));){
                String line;
                do {
                    if ((line = reader.readLine()) == null) return null;
                    int i = line.indexOf(35);
                    if (i == -1) continue;
                    line = line.substring(0, i);
                } while ((line = line.trim()).length() == 0);
                String string = line;
                return string;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public static File getUserWindupDir() {
        return new File(OperatingSystemUtils.getUserHomeDir(), ".windup").getAbsoluteFile();
    }

    public static String getVersion() {
        return Bootstrap.getRuntimeAPIVersion().toString();
    }

    public static String getVersionString() {
        return "> JBoss Windup, version " + Bootstrap.getRuntimeAPIVersion() + ". JBoss Forge, version " + AddonRepositoryImpl.getRuntimeAPIVersion();
    }

    public static Version getRuntimeAPIVersion() {
        String version = Bootstrap.class.getPackage().getImplementationVersion();
        if (version != null) {
            return new SingleVersion(version);
        }
        return EmptyVersion.getInstance();
    }
}

