/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.furnace.impl.addons;

import java.util.LinkedHashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.forge.furnace.Furnace;
import org.jboss.forge.furnace.addons.Addon;
import org.jboss.forge.furnace.addons.AddonDependency;
import org.jboss.forge.furnace.addons.AddonId;
import org.jboss.forge.furnace.addons.AddonView;
import org.jboss.forge.furnace.exception.ContainerException;
import org.jboss.forge.furnace.impl.addons.AddonDependencyImpl;
import org.jboss.forge.furnace.impl.addons.AddonLifecycleManager;
import org.jboss.forge.furnace.impl.addons.AddonState;
import org.jboss.forge.furnace.impl.addons.AddonStateManager;
import org.jboss.forge.furnace.impl.addons.MissingAddonDependencyImpl;
import org.jboss.forge.furnace.impl.modules.AddonModuleLoader;
import org.jboss.forge.furnace.lock.LockManager;
import org.jboss.forge.furnace.repositories.AddonDependencyEntry;
import org.jboss.forge.furnace.repositories.AddonRepository;
import org.jboss.forge.furnace.util.Assert;
import org.jboss.modules.Module;

public class AddonLoader {
    private static final Logger logger = Logger.getLogger(AddonLoader.class.getName());
    private LockManager lock;
    private AddonLifecycleManager lifecycleManager;
    private AddonStateManager stateManager;
    private AddonModuleLoader loader;

    public AddonLoader(Furnace furnace, AddonLifecycleManager lifecycleManager, AddonStateManager stateManager, AddonModuleLoader loader) {
        this.lock = furnace.getLockManager();
        this.lifecycleManager = lifecycleManager;
        this.stateManager = stateManager;
        this.loader = loader;
    }

    public void dispose() {
        this.lock = null;
        this.lifecycleManager = null;
        this.stateManager = null;
        this.loader = null;
    }

    public void loadAddon(Addon addon) {
        Assert.notNull((Object)addon, (String)"Addon to load must not be null.");
        if (!addon.getStatus().isLoaded()) {
            this.stateManager.cancel(addon);
            this.loader.releaseAddonModule(addon);
            Set<AddonView> views = this.stateManager.getViewsOf(addon);
            Set repositories = views.iterator().next().getRepositories();
            for (AddonRepository repository : repositories) {
                if (addon.getStatus().isLoaded() || !repository.isEnabled(addon.getId()) || !repository.isDeployed(addon.getId())) continue;
                Set<AddonDependency> dependencies = this.fromAddonDependencyEntries(addon, repository.getAddonDependencies(addon.getId()));
                LinkedHashSet<AddonDependency> missingRequiredDependencies = new LinkedHashSet<AddonDependency>();
                for (AddonDependency addonDependency : dependencies) {
                    if (!(addonDependency instanceof MissingAddonDependencyImpl) || addonDependency.isOptional()) continue;
                    missingRequiredDependencies.add(addonDependency);
                }
                if (!missingRequiredDependencies.isEmpty()) {
                    if (this.stateManager.getMissingDependenciesOf(addon).size() != missingRequiredDependencies.size()) {
                        logger.warning("Addon [" + addon + "] has [" + missingRequiredDependencies.size() + "] missing dependencies: " + missingRequiredDependencies + " and will be not be loaded until all required" + " dependencies are available.");
                    }
                    this.stateManager.setState(addon, new AddonState(missingRequiredDependencies));
                    continue;
                }
                try {
                    Module module = this.loader.loadAddonModule(addon);
                    this.stateManager.setState(addon, new AddonState(dependencies, repository, (ClassLoader)module.getClassLoader()));
                }
                catch (RuntimeException e) {
                    logger.log(Level.FINE, "Failed to load addon [" + addon.getId() + "]", e);
                    throw e;
                }
                catch (Exception e) {
                    logger.log(Level.FINE, "Failed to load addon [" + addon.getId() + "]", e);
                    throw new ContainerException("Failed to load addon [" + addon.getId() + "]", (Throwable)e);
                }
            }
        }
    }

    private Set<AddonDependency> fromAddonDependencyEntries(Addon addon, Set<AddonDependencyEntry> entries) {
        LinkedHashSet<AddonDependency> result = new LinkedHashSet<AddonDependency>();
        for (AddonDependencyEntry entry : entries) {
            Set<AddonView> views = this.stateManager.getViewsOf(addon);
            AddonId dependencyId = this.stateManager.resolveAddonId(views, entry.getName());
            Addon dependency = null;
            if (dependencyId != null) {
                dependency = this.lifecycleManager.getAddon(views.iterator().next(), dependencyId);
            }
            if (dependency == null || dependency.getStatus().isMissing()) {
                if (entry.isOptional()) continue;
                result.add(new MissingAddonDependencyImpl(entry));
                continue;
            }
            result.add(new AddonDependencyImpl(this.lock, dependency, entry.isExported(), entry.isOptional()));
        }
        return result;
    }

    public AddonModuleLoader getAddonModuleLoader() {
        return this.loader;
    }
}

