/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.furnace.versions;

import java.util.ArrayList;
import java.util.Arrays;
import org.jboss.forge.furnace.util.Assert;
import org.jboss.forge.furnace.versions.ComparableVersion;
import org.jboss.forge.furnace.versions.Version;

public class SingleVersion
implements Version {
    private String version;
    private Integer majorVersion;
    private Integer minorVersion;
    private Integer incrementalVersion;
    private Integer buildNumber;
    private String qualifier;
    private ComparableVersion comparable;

    public SingleVersion(String version) {
        this.parseVersion(version);
    }

    public int hashCode() {
        return 11 + this.comparable.hashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Version)) {
            return false;
        }
        return this.compareTo((Version)other) == 0;
    }

    @Override
    public int compareTo(Version otherVersion) {
        if (otherVersion == null) {
            throw new NullPointerException("Cannot compare against null.");
        }
        if (otherVersion instanceof SingleVersion) {
            return this.comparable.compareTo(((SingleVersion)otherVersion).comparable);
        }
        return this.compareTo(new SingleVersion(otherVersion.toString()));
    }

    @Override
    public int getMajorVersion() {
        return this.majorVersion != null ? this.majorVersion : 0;
    }

    @Override
    public int getMinorVersion() {
        return this.minorVersion != null ? this.minorVersion : 0;
    }

    @Override
    public int getIncrementalVersion() {
        return this.incrementalVersion != null ? this.incrementalVersion : 0;
    }

    @Override
    public int getBuildNumber() {
        return this.buildNumber != null ? this.buildNumber : 0;
    }

    @Override
    public String getQualifier() {
        return this.qualifier;
    }

    private final void parseVersion(String version) {
        Assert.notNull(version, "Version must not be null.");
        this.version = version.trim();
        this.comparable = new ComparableVersion(version);
        ArrayList<String> parts = new ArrayList<String>(Arrays.asList(version.split("[\\._-]")));
        try {
            this.majorVersion = Integer.valueOf((String)parts.remove(0));
            if (!parts.isEmpty()) {
                this.minorVersion = Integer.valueOf((String)parts.remove(0));
            }
            if (!parts.isEmpty()) {
                this.incrementalVersion = Integer.valueOf((String)parts.remove(0));
            }
            if (!parts.isEmpty()) {
                this.qualifier = (String)parts.remove(0);
                try {
                    if (parts.isEmpty()) {
                        this.buildNumber = Integer.valueOf(this.qualifier);
                        this.qualifier = null;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (!parts.isEmpty()) {
                this.buildNumber = Integer.valueOf((String)parts.remove(0));
            }
        }
        catch (NumberFormatException e) {
            this.majorVersion = 0;
            this.minorVersion = 0;
            this.incrementalVersion = 0;
            this.buildNumber = 0;
            this.qualifier = null;
        }
    }

    public String toString() {
        return this.version;
    }
}

