/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.rules.files;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.jboss.windup.config.parser.ElementHandler;
import org.jboss.windup.config.parser.NamespaceElementHandler;
import org.jboss.windup.config.parser.ParserContext;
import org.jboss.windup.graph.GraphTypeManager;
import org.jboss.windup.rules.files.FileMapping;
import org.jboss.windup.util.exception.WindupException;
import org.joox.JOOX;
import org.w3c.dom.Element;

@NamespaceElementHandler(elementName="file-mapping", namespace="http://windup.jboss.org/schema/jboss-ruleset")
public class FileMappingHandler
implements ElementHandler<Void> {
    protected static final String ELEM_NAME = "file-mapping";
    private static final String FROM = "from";
    private static final String TO = "to";
    @Inject
    private GraphTypeManager typeManager;

    public Void processElement(ParserContext context, Element element) {
        String from = JOOX.$((Element)element).attr(FROM);
        String to = JOOX.$((Element)element).attr(TO);
        if (StringUtils.isBlank((String)from)) {
            throw new WindupException("The 'file-mapping' element must have a non-empty 'from' attribute");
        }
        if (StringUtils.isBlank((String)to)) {
            throw new WindupException("The 'file-mapping' element must have a non-empty 'to' attribute");
        }
        ArrayList types = new ArrayList();
        List<String> typeNames = Arrays.asList(to.trim().split("\\s*,\\s*"));
        for (String name : typeNames) {
            ArrayList<Class> matchingTypes = new ArrayList<Class>();
            for (Class modelType : this.typeManager.getRegisteredTypes()) {
                if (!modelType.getName().equals(name) && !modelType.getSimpleName().equals(name + ".class") && !modelType.getSimpleName().equals(name + "Model") && !modelType.getSimpleName().equals(name)) continue;
                matchingTypes.add(modelType);
            }
            if (matchingTypes.isEmpty()) {
                throw new WindupException("A 'file-mapping' element specifies a file mapping type [" + name + "] that could not be found in any installed addons.");
            }
            if (matchingTypes.size() > 1) {
                throw new WindupException("A 'file-mapping' element specifies a file mapping type [" + name + "] that matched multiple file types. Please select one of matches and " + "update the configuration to use the fully qualified name: [" + ((Object)matchingTypes).toString().replaceAll(",", "\n") + "]");
            }
            types.addAll(matchingTypes);
        }
        context.getBuilder().addRule(FileMapping.from((String)from).to(types.toArray(new Class[types.size()])));
        return null;
    }
}

