/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tattletale.reporting;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.jboss.tattletale.core.Archive;
import org.jboss.tattletale.core.NestableArchive;
import org.jboss.tattletale.reporting.CLSReport;
import org.jboss.tattletale.reporting.Dump;
import org.jboss.tattletale.reporting.Filter;
import org.jboss.tattletale.reporting.KeyFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CircularDependencyReport
extends CLSReport {
    private static final String NAME = "Circular Dependency";
    private static final String DIRECTORY = "circulardependency";

    public CircularDependencyReport() {
        super(DIRECTORY, 2, NAME, DIRECTORY);
    }

    @Override
    public void writeHtmlBodyContent(BufferedWriter bw) throws IOException {
        bw.write("<table>" + Dump.newLine());
        bw.write("  <tr>" + Dump.newLine());
        bw.write("     <th>Archive</th>" + Dump.newLine());
        bw.write("     <th>Circular Dependencies</th>" + Dump.newLine());
        bw.write("  </tr>" + Dump.newLine());
        SortedMap<String, SortedSet<String>> dependsOnMap = this.recursivelyBuildDependsOnFromArchive(this.archives);
        TreeMap<String, TreeSet<String>> transitiveDependsOnMap = new TreeMap<String, TreeSet<String>>();
        for (Map.Entry<String, SortedSet<String>> entry : dependsOnMap.entrySet()) {
            String string = entry.getKey();
            SortedSet<String> value = entry.getValue();
            TreeSet<String> result = new TreeSet<String>();
            if (value != null && value.size() > 0) {
                for (String aValue : value) {
                    this.resolveDependsOn(aValue, string, dependsOnMap, result);
                }
            }
            transitiveDependsOnMap.put(string, result);
        }
        boolean odd = true;
        for (Map.Entry<String, SortedSet<String>> entry : transitiveDependsOnMap.entrySet()) {
            String archive = entry.getKey();
            SortedSet<String> value = entry.getValue();
            int finalDot = archive.lastIndexOf(".");
            String extension = archive.substring(finalDot + 1);
            if (value.size() == 0) continue;
            TreeSet<String> circular = new TreeSet<String>();
            for (String r : value) {
                SortedSet td = (SortedSet)transitiveDependsOnMap.get(r);
                if (td == null || !td.contains(archive)) continue;
                circular.add(r);
            }
            if (circular.size() <= 0) continue;
            boolean filtered = this.isFiltered(archive);
            if (!filtered) {
                this.status = 2;
            }
            if (odd) {
                bw.write("  <tr class=\"rowodd\">" + Dump.newLine());
            } else {
                bw.write("  <tr class=\"roweven\">" + Dump.newLine());
            }
            bw.write("     <td><a href=\"../" + extension + "/" + archive + ".html\">" + archive + "</a></td>" + Dump.newLine());
            if (!filtered) {
                bw.write("     <td>");
            } else {
                bw.write("     <td style=\"text-decoration: line-through;\">");
            }
            Iterator valueIt = value.iterator();
            while (valueIt.hasNext()) {
                String r = (String)valueIt.next();
                if (circular.contains(r)) {
                    bw.write("<a href=\"../" + extension + "/" + r + ".html\">" + r + " (*)</a>");
                } else {
                    bw.write("<a href=\"../" + extension + "/" + r + ".html\">" + r + "</a>");
                }
                if (!valueIt.hasNext()) continue;
                bw.write(", ");
            }
            bw.write("</td>" + Dump.newLine());
            bw.write("  </tr>" + Dump.newLine());
            odd = !odd;
        }
        bw.write("</table>" + Dump.newLine());
    }

    private SortedMap<String, SortedSet<String>> recursivelyBuildDependsOnFromArchive(Collection<Archive> archives) {
        TreeMap<String, SortedSet<String>> dependsOnMap = new TreeMap<String, SortedSet<String>>();
        for (Archive archive : archives) {
            if (archive instanceof NestableArchive) {
                NestableArchive nestableArchive = (NestableArchive)archive;
                SortedMap<String, SortedSet<String>> subMap = this.recursivelyBuildDependsOnFromArchive(nestableArchive.getSubArchives());
                dependsOnMap.putAll(subMap);
                continue;
            }
            TreeSet<String> result = (TreeSet<String>)dependsOnMap.get(archive.getName());
            if (result == null) {
                result = new TreeSet<String>();
            }
            for (String require : archive.getRequires()) {
                boolean found = false;
                Iterator<Archive> ait = archives.iterator();
                while (!found && ait.hasNext()) {
                    Archive a = ait.next();
                    if (a.getType() != 1 || !a.doesProvide(require) || this.getCLS() != null && !this.getCLS().isVisible(archive, a)) continue;
                    result.add(a.getName());
                    found = true;
                }
            }
            dependsOnMap.put(archive.getName(), result);
        }
        return dependsOnMap;
    }

    @Override
    public void writeHtmlBodyHeader(BufferedWriter bw) throws IOException {
        bw.write("<body>" + Dump.newLine());
        bw.write(Dump.newLine());
        bw.write("<h1>Circular Dependency</h1>" + Dump.newLine());
        bw.write("<a href=\"../index.html\">Main</a>" + Dump.newLine());
        bw.write("<p>" + Dump.newLine());
    }

    private void resolveDependsOn(String scanArchive, String archive, SortedMap<String, SortedSet<String>> map, SortedSet<String> result) {
        if (!archive.equals(scanArchive) && !result.contains(scanArchive)) {
            result.add(scanArchive);
            SortedSet value = (SortedSet)map.get(scanArchive);
            if (value != null) {
                for (String aValue : value) {
                    this.resolveDependsOn(aValue, archive, map, result);
                }
            }
        }
    }

    @Override
    protected Filter createFilter() {
        return new KeyFilter();
    }
}

