/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.ui;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.jboss.forge.addon.dependencies.Coordinate;
import org.jboss.forge.addon.dependencies.DependencyException;
import org.jboss.forge.addon.dependencies.builder.CoordinateBuilder;
import org.jboss.forge.furnace.util.OperatingSystemUtils;
import org.jboss.windup.exec.updater.RulesetsUpdater;
import org.jboss.windup.util.PathUtil;
import org.jboss.windup.util.exception.WindupException;

public class DistributionUpdater {
    private static final Logger log = Logger.getLogger(DistributionUpdater.class.getName());
    @Inject
    private RulesetsUpdater updater;

    public void replaceWindupDirectoryWithLatestDistribution() {
        CoordinateBuilder coords = CoordinateBuilder.create().setGroupId("org.jboss.windup").setArtifactId("windup-distribution").setClassifier("offline").setPackaging("zip");
        Coordinate coord = this.updater.getLatestReleaseOf(coords);
        if (coord == null) {
            throw new WindupException("No Windup release found.");
        }
        log.info("Latest windup version available: " + coord.getVersion());
        log.fine("Latest windup version available: " + coord);
        this.replaceWindupDirectoryWithDistribution(coord);
    }

    public void replaceWindupDirectoryWithDistribution(Coordinate distCoordinate) throws WindupException {
        try {
            CoordinateBuilder coord = CoordinateBuilder.create((Coordinate)distCoordinate);
            File tempFolder = OperatingSystemUtils.createTempDir();
            this.updater.extractArtifact((Coordinate)coord, tempFolder);
            File newDistWindupDir = DistributionUpdater.getWindupDistributionSubdir(tempFolder);
            if (null == newDistWindupDir) {
                throw new WindupException("Distribution update failed: The distribution archive did not contain the windup-distribution-* directory: " + coord.toString());
            }
            Path addonsDir = PathUtil.getWindupAddonsDir();
            Path binDir = PathUtil.getWindupHome().resolve(PathUtil.BINARY_DIRECTORY_NAME);
            Path libDir = PathUtil.getWindupHome().resolve(PathUtil.LIBRARY_DIRECTORY_NAME);
            FileUtils.deleteDirectory((File)addonsDir.toFile());
            FileUtils.deleteDirectory((File)libDir.toFile());
            FileUtils.deleteDirectory((File)binDir.toFile());
            FileUtils.moveDirectory((File)new File(newDistWindupDir, "addons"), (File)addonsDir.toFile());
            FileUtils.moveDirectory((File)new File(newDistWindupDir, PathUtil.BINARY_DIRECTORY_NAME), (File)binDir.toFile());
            FileUtils.moveDirectory((File)new File(newDistWindupDir, PathUtil.LIBRARY_DIRECTORY_NAME), (File)libDir.toFile());
            Path rulesDir = PathUtil.getWindupHome().resolve("rules");
            File coreDir = rulesDir.resolve("migration-core").toFile();
            if (coreDir.exists()) {
                FileUtils.deleteDirectory((File)coreDir);
                File coreDirNew = newDistWindupDir.toPath().resolve("rules").resolve("migration-core").toFile();
                FileUtils.moveDirectory((File)coreDirNew, (File)rulesDir.resolve("migration-core").toFile());
            } else {
                String newName = "rules-" + new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss").format(new Date());
                FileUtils.moveDirectory((File)rulesDir.toFile(), (File)rulesDir.getParent().resolve(newName).toFile());
                FileUtils.moveDirectory((File)new File(newDistWindupDir, "rules"), (File)rulesDir.toFile());
            }
            FileUtils.deleteDirectory((File)tempFolder);
        }
        catch (IOException | IllegalStateException | DependencyException ex) {
            throw new WindupException("Distribution update failed: " + ex.getMessage(), ex);
        }
    }

    public static File getWindupDistributionSubdir(File tempFolder) throws WindupException {
        File[] matchingDirs = tempFolder.listFiles((FilenameFilter)FileFilterUtils.prefixFileFilter((String)"windup-distribution-", (IOCase)IOCase.INSENSITIVE));
        if (matchingDirs.length == 0) {
            return null;
        }
        return matchingDirs[0];
    }
}

