/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.furnace.impl.event;

import java.lang.annotation.Annotation;
import java.util.concurrent.Callable;
import org.jboss.forge.furnace.addons.Addon;
import org.jboss.forge.furnace.addons.AddonView;
import org.jboss.forge.furnace.event.EventException;
import org.jboss.forge.furnace.event.EventManager;
import org.jboss.forge.furnace.lock.LockManager;
import org.jboss.forge.furnace.lock.LockMode;

public class AddonViewEventManager
implements EventManager {
    private final AddonView addonView;
    private final LockManager lockManager;

    public AddonViewEventManager(AddonView addonView, LockManager lockManager) {
        this.addonView = addonView;
        this.lockManager = lockManager;
    }

    public void fireEvent(final Object event, final Annotation ... qualifiers) throws EventException {
        this.lockManager.performLocked(LockMode.READ, (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                for (Addon addon : AddonViewEventManager.this.addonView.getAddons()) {
                    if (!addon.getStatus().isStarted()) continue;
                    EventManager eventManager = addon.getEventManager();
                    eventManager.fireEvent(event, qualifiers);
                }
                return null;
            }
        });
    }
}

