/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.reflection;

import com.strobel.annotations.NotNull;
import com.strobel.core.VerifyArgument;
import com.strobel.reflection.ConstructorList;
import com.strobel.reflection.FieldList;
import com.strobel.reflection.Helper;
import com.strobel.reflection.MemberType;
import com.strobel.reflection.MethodList;
import com.strobel.reflection.RuntimeType;
import com.strobel.reflection.Type;
import com.strobel.reflection.TypeBinder;
import com.strobel.reflection.TypeBindings;
import com.strobel.reflection.TypeList;
import com.strobel.reflection.TypeMapping;
import com.strobel.reflection.TypeVisitor;
import java.lang.annotation.Annotation;

final class GenericType<T>
extends Type<T> {
    static final TypeBinder GenericBinder = new TypeBinder();
    private final Type _genericTypeDefinition;
    private final TypeBindings _typeBindings;
    private TypeList _interfaces;
    private Type _baseType;
    private FieldList _fields;
    private ConstructorList _constructors;
    private MethodList _methods;
    private TypeList _nestedTypes;

    GenericType(Type genericTypeDefinition, TypeBindings typeBindings) {
        this._genericTypeDefinition = (Type)VerifyArgument.notNull((Object)genericTypeDefinition, (String)"genericTypeDefinition");
        this._typeBindings = (TypeBindings)VerifyArgument.notNull((Object)typeBindings, (String)"typeBindings");
    }

    GenericType(Type genericTypeDefinition, TypeList typeArguments) {
        this._genericTypeDefinition = (Type)VerifyArgument.notNull((Object)genericTypeDefinition, (String)"genericTypeDefinition");
        this._typeBindings = TypeBindings.create(genericTypeDefinition.getTypeBindings().getGenericParameters(), (TypeList)((Object)VerifyArgument.notNull((Object)((Object)typeArguments), (String)"typeArguments")));
    }

    GenericType(Type genericTypeDefinition, Type ... typeArguments) {
        this._genericTypeDefinition = (Type)VerifyArgument.notNull((Object)genericTypeDefinition, (String)"genericTypeDefinition");
        this._typeBindings = TypeBindings.create(genericTypeDefinition.getTypeBindings().getGenericParameters(), (Type[])VerifyArgument.notNull((Object)typeArguments, (String)"typeArguments"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureBaseType() {
        if (this._baseType == null) {
            Object object = CACHE_LOCK;
            synchronized (object) {
                if (this._baseType == null) {
                    Type genericBaseType = this._genericTypeDefinition.getBaseType();
                    this._baseType = genericBaseType == null || genericBaseType == NullType ? NullType : (Type)GenericBinder.visit(genericBaseType, this._typeBindings);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureInterfaces() {
        if (this._interfaces == null) {
            Object object = CACHE_LOCK;
            synchronized (object) {
                if (this._interfaces == null) {
                    this._interfaces = GenericBinder.visit(this._genericTypeDefinition.getExplicitInterfaces(), this._typeBindings);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureFields() {
        if (this._fields == null) {
            Object object = CACHE_LOCK;
            synchronized (object) {
                if (this._fields == null) {
                    this._fields = GenericBinder.visit(this, this._genericTypeDefinition.getDeclaredFields(), this._typeBindings);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureConstructors() {
        if (this._constructors == null) {
            Object object = CACHE_LOCK;
            synchronized (object) {
                if (this._constructors == null) {
                    this._constructors = GenericBinder.visit(this, this._genericTypeDefinition.getDeclaredConstructors(), this._typeBindings);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureMethods() {
        if (this._methods == null) {
            Object object = CACHE_LOCK;
            synchronized (object) {
                if (this._methods == null) {
                    this._methods = GenericBinder.visit(this, this._genericTypeDefinition.getDeclaredMethods(), this._typeBindings);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureNestedTypes() {
        if (this._nestedTypes == null) {
            Object object = CACHE_LOCK;
            synchronized (object) {
                if (this._nestedTypes == null) {
                    this._nestedTypes = Helper.map(this._genericTypeDefinition.getDeclaredTypes(), new TypeMapping(){

                        public Type<?> apply(Type<?> type) {
                            return new RuntimeType(GenericType.this, type, GenericType.this._typeBindings);
                        }
                    });
                }
            }
        }
    }

    @Override
    public Class<T> getErasedClass() {
        return this._genericTypeDefinition.getErasedClass();
    }

    @Override
    public TypeList getExplicitInterfaces() {
        this.ensureInterfaces();
        return this._interfaces;
    }

    @Override
    public Type<? super T> getBaseType() {
        this.ensureBaseType();
        Type baseType = this._baseType;
        return baseType == NullType ? null : baseType;
    }

    @Override
    public Type getGenericTypeDefinition() {
        return this._genericTypeDefinition;
    }

    @Override
    public MemberType getMemberType() {
        return MemberType.TypeInfo;
    }

    @Override
    public Type getDeclaringType() {
        return this._genericTypeDefinition.getDeclaringType();
    }

    @Override
    public final boolean isGenericType() {
        return true;
    }

    @Override
    public TypeBindings getTypeBindings() {
        return this._typeBindings;
    }

    @Override
    public int getModifiers() {
        return this._genericTypeDefinition.getModifiers();
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        return this._genericTypeDefinition.isAnnotationPresent(annotationClass);
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return this._genericTypeDefinition.getAnnotation(annotationClass);
    }

    @Override
    @NotNull
    public Annotation[] getAnnotations() {
        return this._genericTypeDefinition.getAnnotations();
    }

    @Override
    @NotNull
    public Annotation[] getDeclaredAnnotations() {
        return this._genericTypeDefinition.getDeclaredAnnotations();
    }

    @Override
    public <P, R> R accept(TypeVisitor<P, R> typeVisitor, P parameter) {
        return typeVisitor.visitClassType(this, parameter);
    }

    @Override
    protected ConstructorList getDeclaredConstructors() {
        this.ensureConstructors();
        return this._constructors;
    }

    @Override
    protected MethodList getDeclaredMethods() {
        this.ensureMethods();
        return this._methods;
    }

    @Override
    protected FieldList getDeclaredFields() {
        this.ensureFields();
        return this._fields;
    }

    @Override
    protected TypeList getDeclaredTypes() {
        this.ensureNestedTypes();
        return this._nestedTypes;
    }
}

