/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.reflection.emit;

import com.strobel.annotations.NotNull;
import com.strobel.compilerservices.CallerResolver;
import com.strobel.compilerservices.RuntimeHelpers;
import com.strobel.core.ArrayUtilities;
import com.strobel.core.ExceptionUtilities;
import com.strobel.core.Pair;
import com.strobel.core.ReadOnlyList;
import com.strobel.core.StringUtilities;
import com.strobel.core.VerifyArgument;
import com.strobel.io.PathHelper;
import com.strobel.reflection.BindingFlags;
import com.strobel.reflection.CallingConvention;
import com.strobel.reflection.ConstructorInfo;
import com.strobel.reflection.ConstructorList;
import com.strobel.reflection.FieldInfo;
import com.strobel.reflection.FieldList;
import com.strobel.reflection.MemberFilter;
import com.strobel.reflection.MemberInfo;
import com.strobel.reflection.MemberList;
import com.strobel.reflection.MemberType;
import com.strobel.reflection.MethodBase;
import com.strobel.reflection.MethodInfo;
import com.strobel.reflection.MethodList;
import com.strobel.reflection.ParameterInfo;
import com.strobel.reflection.PrimitiveTypes;
import com.strobel.reflection.Type;
import com.strobel.reflection.TypeBindings;
import com.strobel.reflection.TypeList;
import com.strobel.reflection.TypeVisitor;
import com.strobel.reflection.Types;
import com.strobel.reflection.emit.AnnotationBuilder;
import com.strobel.reflection.emit.ClassWriter;
import com.strobel.reflection.emit.CodeGenerator;
import com.strobel.reflection.emit.ConstantPool;
import com.strobel.reflection.emit.ConstructorBuilder;
import com.strobel.reflection.emit.Error;
import com.strobel.reflection.emit.FieldBuilder;
import com.strobel.reflection.emit.GenericParameterBuilder;
import com.strobel.reflection.emit.MethodBuilder;
import com.strobel.reflection.emit.ParameterBuilder;
import com.strobel.reflection.emit.TypeBuilderInstantiation;
import com.strobel.util.ContractUtils;
import com.strobel.util.TypeUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import sun.misc.Unsafe;

public final class TypeBuilder<T>
extends Type<T> {
    private static final String DumpGeneratedClassesProperty = "com.strobel.reflection.emit.TypeBuilder.DumpGeneratedClasses";
    private static final String GeneratedClassOutputPathProperty = "com.strobel.reflection.emit.TypeBuilder.GeneratedClassOutputPath";
    final ConstantPool constantPool = new ConstantPool();
    final ArrayList<ConstructorBuilder> constructorBuilders = new ArrayList();
    final ArrayList<MethodBuilder> methodBuilders = new ArrayList();
    final ArrayList<FieldBuilder> fieldBuilders = new ArrayList();
    final ArrayList<GenericParameterBuilder<?>> genericParameterBuilders = new ArrayList();
    final ArrayList<MethodOverride> methodOverrides = new ArrayList();
    private String _name;
    private String _fullName;
    private String _internalName;
    private Package _package;
    private Type<? super T> _baseType;
    private ConstructorList _constructors = ConstructorList.empty();
    private MethodList _methods = MethodList.empty();
    private FieldList _fields = FieldList.empty();
    private TypeList _interfaces;
    private TypeBuilder _declaringType;
    private MethodBuilder _declaringMethod;
    private int _modifiers;
    private boolean _hasBeenCreated;
    private Class<T> _generatedClass;
    private Type<T> _generatedType;
    private Type<?> _extendsBound;
    private int _genericParameterPosition;
    private boolean _isGenericParameter;
    private boolean _isGenericTypeDefinition;
    private TypeBindings _typeBindings = TypeBindings.empty();
    private ReadOnlyList<AnnotationBuilder<? extends Annotation>> _annotations = ReadOnlyList.emptyList();
    private final ProtectionDomain _protectionDomain = CallerResolver.getCallerClass((int)1).getProtectionDomain();
    private static final MemberFilter RawMethodMatcher = new MemberFilter(){

        @Override
        public boolean apply(MemberInfo m, Object filterCriteria) {
            return ((MethodInfo)m).getRawMethod() == filterCriteria;
        }
    };
    private static Unsafe _unsafe;

    public TypeBuilder(String name, int modifiers, Type baseType, TypeList interfaces) {
        this();
        super.initialize(name, modifiers, baseType, interfaces, null);
    }

    TypeBuilder() {
    }

    TypeBuilder(String name, int genericParameterPosition, TypeBuilder declaringType) {
        this();
        this._declaringType = (TypeBuilder)VerifyArgument.notNull((Object)declaringType, (String)"declaringType");
        super.initializeAsGenericParameter((String)VerifyArgument.notNull((Object)name, (String)"name"), VerifyArgument.isNonNegative((int)genericParameterPosition, (String)"genericParameterPosition"));
    }

    TypeBuilder(String name, int genericParameterPosition, MethodBuilder declaringMethod) {
        this();
        this._declaringMethod = (MethodBuilder)VerifyArgument.notNull((Object)declaringMethod, (String)"declaringMethod");
        this._declaringType = this._declaringMethod.getDeclaringType();
        super.initializeAsGenericParameter((String)VerifyArgument.notNull((Object)name, (String)"name"), VerifyArgument.isNonNegative((int)genericParameterPosition, (String)"genericParameterPosition"));
    }

    TypeBuilder(String name, int modifiers, Type baseType, TypeBuilder declaringType) {
        this();
        super.initialize(name, modifiers, baseType, TypeList.empty(), declaringType);
    }

    TypeBuilder(String name, int modifiers, Type<? super T> baseType, TypeList interfaces, TypeBuilder declaringType) {
        this();
        super.initialize(name, modifiers, baseType, interfaces, declaringType);
    }

    private void initializeAsGenericParameter(String name, int position) {
        this._name = name;
        this._fullName = name;
        this._internalName = name.replace('.', '/');
        this._genericParameterPosition = position;
        this._isGenericParameter = true;
        this._isGenericTypeDefinition = false;
        this._interfaces = TypeList.empty();
    }

    private void initialize(String fullName, int modifiers, Type baseType, TypeList interfaces, TypeBuilder declaringType) {
        VerifyArgument.notNullOrWhitespace((String)fullName, (String)"fullName");
        if (fullName.length() > 1023) {
            throw Error.typeNameTooLong();
        }
        this._fullName = fullName;
        this._internalName = fullName.replace('.', '/');
        this._isGenericTypeDefinition = false;
        this._isGenericParameter = false;
        this._hasBeenCreated = false;
        this._declaringType = declaringType;
        int lastDotIndex = fullName.lastIndexOf(46);
        if (lastDotIndex == -1 || lastDotIndex == 0) {
            this._package = Package.getPackage("");
            this._name = this._fullName;
        } else {
            this._package = Package.getPackage(fullName.substring(0, lastDotIndex));
            this._name = fullName.substring(lastDotIndex + 1);
        }
        this._modifiers = Modifier.isInterface(modifiers) ? modifiers & (Modifier.interfaceModifiers() | 0x200) | 0x400 : modifiers & Modifier.classModifiers();
        this.setBaseType(baseType);
        this.setInterfaces(interfaces);
    }

    final void setInterfaces(TypeList interfaces) {
        this.verifyNotCreated();
        this._interfaces = interfaces != null ? interfaces : TypeList.empty();
        this.updateExtendsBound();
    }

    final void setBaseType(Type baseType) {
        this.verifyNotGeneric();
        this.verifyNotCreated();
        if (baseType != null) {
            if (baseType.isInterface()) {
                throw Error.baseTypeCannotBeInterface();
            }
            this._baseType = baseType;
            this.updateExtendsBound();
            return;
        }
        this._baseType = Modifier.isInterface(this._modifiers) ? null : Types.Object;
        this.updateExtendsBound();
    }

    private void updateExtendsBound() {
        if (!this.isGenericParameter()) {
            return;
        }
        Type<Object> type = this._extendsBound = this._baseType == Types.Object ? null : this._baseType;
        if (this._interfaces.isEmpty()) {
            return;
        }
        if (this._interfaces.size() == 1 && this._extendsBound == null) {
            this._extendsBound = (Type)this._interfaces.get(0);
            return;
        }
        this._extendsBound = Type.makeCompoundType(this._baseType, this._interfaces);
    }

    final void verifyNotCreated() {
        if (this.isCreated()) {
            throw Error.typeHasBeenCreated();
        }
    }

    final void verifyCreated() {
        if (!this.isCreated()) {
            throw Error.typeHasNotBeenCreated();
        }
    }

    final void verifyNotGeneric() {
        if (this.isGenericType() && !this.isGenericTypeDefinition()) {
            throw new IllegalStateException();
        }
    }

    @Override
    public Package getPackage() {
        return this._package;
    }

    @Override
    public Type<?> getReflectedType() {
        return this._declaringType;
    }

    @Override
    public MethodBase getDeclaringMethod() {
        return this._declaringMethod;
    }

    @Override
    protected String getClassFullName() {
        return this._fullName;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public String getFullName() {
        return this._fullName;
    }

    @Override
    public String getInternalName() {
        return this._internalName;
    }

    @Override
    public StringBuilder appendErasedDescription(StringBuilder sb) {
        if (this.isGenericParameter()) {
            return this.getExtendsBound().appendErasedDescription(sb);
        }
        return super.appendErasedDescription(sb);
    }

    @Override
    public StringBuilder appendErasedSignature(StringBuilder sb) {
        if (this.isGenericParameter()) {
            return this.getExtendsBound().appendErasedSignature(sb);
        }
        return super.appendErasedSignature(sb);
    }

    @Override
    protected String getClassSimpleName() {
        return this._name;
    }

    @Override
    public Type<? super T> getBaseType() {
        return this._baseType;
    }

    @Override
    protected TypeList getExplicitInterfaces() {
        return this._interfaces;
    }

    @Override
    public Type<?> getDeclaringType() {
        return this._declaringType;
    }

    @Override
    public int getModifiers() {
        return this._modifiers;
    }

    @Override
    public boolean isEquivalentTo(Type<?> other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        Type<?> runtimeType = other instanceof TypeBuilder ? ((TypeBuilder)other)._generatedType : other;
        return this._generatedType != null && runtimeType != null && this._generatedType.isEquivalentTo(runtimeType);
    }

    @Override
    public boolean isInstance(Object o) {
        return this._hasBeenCreated && this._generatedClass.isInstance(o);
    }

    @Override
    public boolean isGenericParameter() {
        return this._isGenericParameter;
    }

    @Override
    public boolean isGenericType() {
        return this._isGenericTypeDefinition;
    }

    @Override
    public boolean isGenericTypeDefinition() {
        return this._isGenericTypeDefinition;
    }

    @Override
    public int getGenericParameterPosition() {
        if (this.isGenericParameter()) {
            return this._genericParameterPosition;
        }
        return super.getGenericParameterPosition();
    }

    @Override
    public Type<?> getGenericTypeDefinition() {
        if (this.isGenericTypeDefinition()) {
            return this;
        }
        throw Error.notGenericType(this);
    }

    @Override
    protected TypeBindings getTypeBindings() {
        return this._typeBindings;
    }

    @Override
    public Type<?> getExtendsBound() {
        if (this._isGenericParameter) {
            return this._extendsBound != null ? this._extendsBound : Types.Object;
        }
        return super.getExtendsBound();
    }

    @Override
    public boolean isAssignableFrom(Type type) {
        if (this._hasBeenCreated) {
            return this._generatedType.isAssignableFrom(type);
        }
        return super.isAssignableFrom(type);
    }

    @Override
    public ConstructorInfo getConstructor(Set<BindingFlags> bindingFlags, CallingConvention callingConvention, Type ... parameterTypes) {
        this.verifyCreated();
        return this._generatedType.getConstructor(bindingFlags, callingConvention, parameterTypes);
    }

    @Override
    public ConstructorList getConstructors(Set<BindingFlags> bindingFlags) {
        this.verifyCreated();
        return this._generatedType.getConstructors(bindingFlags);
    }

    @Override
    public MemberList getMembers(Set<BindingFlags> bindingFlags, Set<MemberType> memberTypes) {
        this.verifyCreated();
        return this._generatedType.getMembers(bindingFlags, memberTypes);
    }

    @Override
    public MemberList getMember(String name, Set<BindingFlags> bindingFlags, Set<MemberType> memberTypes) {
        this.verifyCreated();
        return this._generatedType.getMember(name, bindingFlags, memberTypes);
    }

    @Override
    public MethodInfo getMethod(String name, Set<BindingFlags> bindingFlags, CallingConvention callingConvention, Type ... parameterTypes) {
        this.verifyCreated();
        return this._generatedType.getMethod(name, bindingFlags, callingConvention, parameterTypes);
    }

    @Override
    public MethodList getMethods(Set<BindingFlags> bindingFlags, CallingConvention callingConvention) {
        this.verifyCreated();
        return this._generatedType.getMethods(bindingFlags, callingConvention);
    }

    @Override
    public Type<?> getNestedType(String fullName, Set<BindingFlags> bindingFlags) {
        this.verifyCreated();
        return this._generatedType.getNestedType(fullName, bindingFlags);
    }

    @Override
    public TypeList getNestedTypes(Set<BindingFlags> bindingFlags) {
        this.verifyCreated();
        return this._generatedType.getNestedTypes(bindingFlags);
    }

    @Override
    public FieldList getFields(Set<BindingFlags> bindingFlags) {
        this.verifyCreated();
        return this._generatedType.getFields(bindingFlags);
    }

    @Override
    public FieldInfo getField(String name, Set<BindingFlags> bindingFlags) {
        this.verifyCreated();
        return this._generatedType.getField(name, bindingFlags);
    }

    @Override
    public Class<T> getErasedClass() {
        this.verifyCreated();
        return this._generatedClass;
    }

    @Override
    public <P, R> R accept(TypeVisitor<P, R> visitor, P parameter) {
        if (this.isGenericParameter()) {
            return visitor.visitTypeParameter(this, parameter);
        }
        return visitor.visitClassType(this, parameter);
    }

    public void addCustomAnnotation(AnnotationBuilder<? extends Annotation> annotation) {
        VerifyArgument.notNull(annotation, (String)"annotation");
        Object[] newAnnotations = new AnnotationBuilder[this._annotations.size() + 1];
        this._annotations.toArray(newAnnotations);
        newAnnotations[this._annotations.size()] = annotation;
        this._annotations = new ReadOnlyList(newAnnotations);
    }

    public ReadOnlyList<AnnotationBuilder<? extends Annotation>> getCustomAnnotations() {
        return this._annotations;
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        this.verifyCreated();
        return this._generatedType.getAnnotation(annotationClass);
    }

    @Override
    @NotNull
    public Annotation[] getAnnotations() {
        this.verifyCreated();
        return this._generatedType.getAnnotations();
    }

    @Override
    @NotNull
    public Annotation[] getDeclaredAnnotations() {
        this.verifyCreated();
        return this._generatedType.getDeclaredAnnotations();
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        this.verifyCreated();
        return this._generatedType.isAnnotationPresent(annotationClass);
    }

    @Override
    protected Type<?> makeGenericTypeCore(TypeList typeArguments) {
        if (!this.isGenericTypeDefinition()) {
            throw Error.notGenericTypeDefinition(this);
        }
        return TypeBuilderInstantiation.makeGenericType(this, typeArguments);
    }

    public boolean isCreated() {
        return this._hasBeenCreated;
    }

    public synchronized Type<T> createType() {
        try {
            return this.createTypeNoLock(null);
        }
        catch (IOException e) {
            throw ExceptionUtilities.asRuntimeException((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized Type<T> createType(File outputFile) {
        try (FileOutputStream outputStream = new FileOutputStream(outputFile);){
            Type<T> type = this.createTypeNoLock(outputStream);
            return type;
        }
        catch (IOException e) {
            throw ExceptionUtilities.asRuntimeException((Throwable)e);
        }
    }

    public synchronized Type<T> createType(OutputStream outputStream) {
        try {
            return this.createTypeNoLock(outputStream);
        }
        catch (IOException e) {
            throw ExceptionUtilities.asRuntimeException((Throwable)e);
        }
    }

    public ConstructorBuilder defineConstructor(int modifiers, TypeList parameterTypes) {
        return this.defineConstructor(modifiers, parameterTypes, TypeList.empty());
    }

    public ConstructorBuilder defineConstructor(int modifiers, TypeList parameterTypes, TypeList thrownTypes) {
        this.verifyNotGeneric();
        this.verifyNotCreated();
        ConstructorBuilder constructor = new ConstructorBuilder(modifiers & Modifier.constructorModifiers(), parameterTypes, thrownTypes, this);
        this.constructorBuilders.add(constructor);
        this._constructors = new ConstructorList((ConstructorInfo[])ArrayUtilities.append((Object[])this._constructors.toArray(), (Object)constructor));
        return constructor;
    }

    public ConstructorBuilder defineDefaultConstructor() {
        return this.defineDefaultConstructor(this.isAbstract() ? 4 : 1);
    }

    public ConstructorBuilder defineDefaultConstructor(int modifiers) {
        this.verifyNotGeneric();
        this.verifyNotCreated();
        if (this.isInterface()) {
            throw Error.interfacesCannotDefineConstructors();
        }
        ConstructorInfo baseConstructor = this._baseType.getConstructor(BindingFlags.AllExact, new Type[0]);
        if (baseConstructor == null || baseConstructor.isPrivate()) {
            throw Error.baseTypeHasNoDefaultConstructor(this._baseType);
        }
        ConstructorBuilder constructor = new ConstructorBuilder(modifiers & Modifier.constructorModifiers(), baseConstructor.getParameters().getParameterTypes(), TypeList.empty(), this);
        CodeGenerator code = constructor.getCodeGenerator();
        code.emitThis();
        Iterator iterator = baseConstructor.getParameters().iterator();
        while (iterator.hasNext()) {
            ParameterInfo parameter = (ParameterInfo)iterator.next();
            code.emitLoadArgument(parameter.getPosition());
        }
        code.call(baseConstructor);
        code.emitReturn();
        constructor.returnCodeGenerator = false;
        this.constructorBuilders.add(constructor);
        this._constructors = new ConstructorList((ConstructorInfo[])ArrayUtilities.append((Object[])this._constructors.toArray(), (Object)constructor));
        return constructor;
    }

    final void addMethodToList(MethodBuilder methodBuilder) {
        this.methodBuilders.add(methodBuilder);
    }

    public void defineMethodOverride(MethodInfo override, MethodInfo baseMethod) {
        VerifyArgument.notNull((Object)override, (String)"override");
        VerifyArgument.notNull((Object)baseMethod, (String)"baseMethod");
        if (override.getDeclaringType() != this) {
            throw Error.methodBuilderBelongsToAnotherType();
        }
        if (override.isStatic() || baseMethod.isStatic()) {
            throw Error.staticInstanceMethodMismatch();
        }
        if (baseMethod.isFinal()) {
            throw Error.cannotOverrideFinalMethod();
        }
        if (!StringUtilities.equals((String)override.getName(), (String)baseMethod.getName())) {
            throw Error.methodNameMismatch();
        }
        int baseParameterCount = baseMethod instanceof MethodBuilder ? ((MethodBuilder)baseMethod).parameterBuilders.length : baseMethod.getParameters().size();
        MethodBuilder overrideBuilder = (MethodBuilder)override;
        if (overrideBuilder.parameterBuilders.length != baseParameterCount) {
            throw Error.parameterCountMismatch();
        }
        if (overrideBuilder.getReturnType() == PrimitiveTypes.Void != (baseMethod.getReturnType() == PrimitiveTypes.Void)) {
            throw Error.incompatibleReturnTypes();
        }
        this.verifyNotGeneric();
        this.verifyNotCreated();
        Type<?> baseDeclaringType = baseMethod.getDeclaringType().isGenericType() ? baseMethod.getDeclaringType().getGenericTypeDefinition() : baseMethod.getDeclaringType().getErasedType();
        MemberList<MemberInfo> m = baseDeclaringType.findMembers(MemberType.methodsOnly(), BindingFlags.AllDeclared, RawMethodMatcher, baseMethod.getRawMethod());
        assert (m != null && m.size() == 1);
        MethodInfo base = (MethodInfo)m.get(0);
        this.methodOverrides.add(new MethodOverride(overrideBuilder, base));
    }

    public MethodBuilder defineMethod(String name, int modifiers, Type<?> returnType) {
        return this.defineMethod(name, modifiers, returnType, TypeList.empty(), TypeList.empty());
    }

    public MethodBuilder defineMethod(String name, int modifiers, Type<?> returnType, TypeList parameterTypes) {
        return this.defineMethod(name, modifiers, returnType, parameterTypes, TypeList.empty());
    }

    public MethodBuilder defineMethod(String name, int modifiers, Type<?> returnType, TypeList parameterTypes, TypeList thrownTypes) {
        return this.defineMethodCore(name, modifiers & Modifier.methodModifiers(), returnType, parameterTypes, thrownTypes);
    }

    private MethodBuilder defineMethodCore(String name, int modifiers, Type<?> returnType, TypeList parameterTypes, TypeList thrownTypes) {
        VerifyArgument.notNullOrWhitespace((String)name, (String)"name");
        this.verifyNotGeneric();
        this.verifyNotCreated();
        MethodBuilder method = new MethodBuilder(name, modifiers, returnType, parameterTypes, thrownTypes, this);
        this.methodBuilders.add(method);
        this._methods = new MethodList((MethodInfo[])ArrayUtilities.append((Object[])this._methods.toArray(), (Object)method));
        return method;
    }

    public MethodBuilder defineTypeInitializer() {
        return this.defineMethod("<clinit>", 8, PrimitiveTypes.Void);
    }

    public FieldBuilder defineConstant(String name, Type<?> type, int modifiers, Object constantValue) {
        VerifyArgument.notNullOrWhitespace((String)name, (String)"name");
        VerifyArgument.notNull((Object)constantValue, (String)"constantValue");
        this.verifyNotGeneric();
        this.verifyNotCreated();
        return this.defineFieldCore(name, type, modifiers, constantValue);
    }

    public FieldBuilder defineField(String name, Type<?> type, int modifiers) {
        return this.defineFieldCore(name, type, modifiers, null);
    }

    private FieldBuilder defineFieldCore(String name, Type<?> type, int modifiers, Object constantValue) {
        VerifyArgument.notNullOrWhitespace((String)name, (String)"name");
        this.verifyNotGeneric();
        this.verifyNotCreated();
        if (constantValue != null && !TypeUtils.isAutoUnboxed(Type.of(constantValue.getClass()))) {
            throw Error.valueMustBeConstant();
        }
        FieldBuilder field = new FieldBuilder(this, name, type, modifiers & Modifier.fieldModifiers(), constantValue);
        this.fieldBuilders.add(field);
        this._fields = new FieldList((FieldInfo[])ArrayUtilities.append((Object[])this._fields.toArray(), (Object)field));
        return field;
    }

    public GenericParameterBuilder<?>[] defineGenericParameters(String ... names) {
        if (!this._typeBindings.isEmpty()) {
            throw Error.defineGenericParametersAlreadyCalled();
        }
        VerifyArgument.notEmpty((Object[])names, (String)"names");
        Object[] defensiveCopy = Arrays.copyOf(names, names.length);
        VerifyArgument.noNullElements((Object[])defensiveCopy, (String)"names");
        this._isGenericTypeDefinition = true;
        Type[] genericParameters = new GenericParameterBuilder[names.length];
        int n = names.length;
        for (int i = 0; i < n; ++i) {
            genericParameters[i] = new GenericParameterBuilder(new TypeBuilder<T>(names[i], i, this));
        }
        this._typeBindings = TypeBindings.createUnbound(Type.list(genericParameters));
        return genericParameters;
    }

    short getTypeToken(Type<?> type) {
        VerifyArgument.notNull(type, (String)"type");
        return (short)(this.constantPool.getTypeInfo(TypeBuilder.erase(type)).index & 0xFFFF);
    }

    short getMethodToken(MethodBase method) {
        VerifyArgument.notNull((Object)method, (String)"method");
        if (method.getDeclaringType().isInterface()) {
            return (short)(this.constantPool.getInterfaceMethodReference((MethodInfo)((MethodInfo)TypeBuilder.erase((MethodBase)method))).index & 0xFFFF);
        }
        return (short)(this.constantPool.getMethodReference((MethodBase)TypeBuilder.erase((MethodBase)method)).index & 0xFFFF);
    }

    short getFieldToken(FieldInfo field) {
        VerifyArgument.notNull((Object)field, (String)"field");
        return (short)(this.constantPool.getFieldReference((FieldInfo)TypeBuilder.erase((FieldInfo)field)).index & 0xFFFF);
    }

    short getConstantToken(int value) {
        return (short)(this.constantPool.getIntegerConstant((int)value).index & 0xFFFF);
    }

    short getConstantToken(long value) {
        return (short)(this.constantPool.getLongConstant((long)value).index & 0xFFFF);
    }

    short getConstantToken(float value) {
        return (short)(this.constantPool.getFloatConstant((float)value).index & 0xFFFF);
    }

    short getConstantToken(double value) {
        return (short)(this.constantPool.getDoubleConstant((double)value).index & 0xFFFF);
    }

    short getStringToken(String value) {
        return (short)(this.constantPool.getStringConstant((String)value).index & 0xFFFF);
    }

    short getUtf8StringToken(String value) {
        return (short)(this.constantPool.getUtf8StringConstant((String)value).index & 0xFFFF);
    }

    private static Type<?> erase(Type<?> t) {
        Type def = t.isGenericType() ? t.getGenericTypeDefinition() : t;
        return def.getErasedType();
    }

    private static MethodBase erase(MethodBase m) {
        if (m instanceof MethodInfo) {
            return ((MethodInfo)m).getErasedMethodDefinition();
        }
        if (!m.getDeclaringType().isGenericType()) {
            return m;
        }
        Type<?> erasedType = TypeBuilder.erase(m.getDeclaringType());
        Constructor<?> rawMethod = ((ConstructorInfo)m).getRawConstructor();
        MemberList<MemberInfo> members = erasedType.findMembers(MemberType.constructorsOnly(), BindingFlags.AllDeclared, Type.FilterRawMember, rawMethod);
        if (!members.isEmpty()) {
            return (MethodBase)members.get(0);
        }
        throw ContractUtils.unreachable();
    }

    private static FieldInfo erase(FieldInfo f) {
        if (!f.getDeclaringType().isGenericType()) {
            return f;
        }
        Type<?> erasedType = TypeBuilder.erase(f.getDeclaringType());
        Field rawField = f.getRawField();
        MemberList<MemberInfo> members = erasedType.findMembers(MemberType.fieldsOnly(), BindingFlags.AllDeclared, Type.FilterRawMember, rawField);
        if (!members.isEmpty()) {
            return (FieldInfo)members.get(0);
        }
        throw ContractUtils.unreachable();
    }

    private Type<T> createTypeNoLock(OutputStream writeTo) throws IOException {
        if (this.isCreated()) {
            return this._generatedType;
        }
        this.verifyNotGeneric();
        this.verifyNotCreated();
        if (this.isGenericParameter()) {
            this._hasBeenCreated = true;
            for (AnnotationBuilder annotation : this._annotations) {
                annotation.bake();
            }
            return this;
        }
        if (!this.genericParameterBuilders.isEmpty()) {
            int n = this.genericParameterBuilders.size();
            for (int i = 0; i < n; ++i) {
                this.genericParameterBuilders.get((int)i).typeBuilder.createType();
            }
        }
        if (this._constructors.size() == 0 && !this.isInterface()) {
            this.defineDefaultConstructor();
        }
        this.createBridgeMethods();
        int methodCount = this.methodBuilders.size();
        for (int i = 0; i < methodCount; ++i) {
            MethodBuilder method = this.methodBuilders.get(i);
            if (method.isAbstract() && !this.isAbstract()) {
                throw Error.abstractMethodDeclaredOnNonAbstractType();
            }
            byte[] body = method.getBody();
            if (method.isAbstract()) {
                if (body == null) continue;
                throw Error.abstractMethodCannotHaveBody();
            }
            if (method.generator != null) {
                method.createMethodBodyHelper(method.getCodeGenerator());
                body = method.getBody();
            }
            if (body != null && body.length != 0) continue;
            throw Error.methodHasEmptyBody(method);
        }
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream(1024);){
            new ClassWriter(this).writeClass(outputStream);
            String fullName = this.getClassFullName();
            byte[] classBytes = outputStream.toByteArray();
            if (writeTo != null) {
                writeTo.write(classBytes);
            } else {
                try (OutputStream tempStream = this.getDefaultOutputStream();){
                    if (tempStream != null) {
                        tempStream.write(classBytes);
                    }
                }
            }
            this._hasBeenCreated = true;
            this._generatedClass = TypeBuilder.getUnsafeInstance().defineClass(fullName, classBytes, 0, classBytes.length, ClassLoader.getSystemClassLoader(), this._protectionDomain);
            RuntimeHelpers.ensureClassInitialized(this._generatedClass);
            this._generatedType = Type.of(this._generatedClass);
        }
        catch (Throwable t) {
            throw Error.classGenerationFailed(this, t);
        }
        finally {
            if (this._generatedType != null) {
                this.updateMembersWithGeneratedReferences();
            }
            for (int i = 0; i < methodCount; ++i) {
                this.methodBuilders.get(i).releaseBakedStructures();
            }
        }
        return this._generatedType;
    }

    private void createBridgeMethods() {
        for (MethodOverride methodOverride : this.methodOverrides) {
            if (!this.isBridgeMethodNeeded(methodOverride)) continue;
            this.createBridgeMethod(methodOverride);
        }
    }

    private void createBridgeMethod(MethodOverride methodOverride) {
        MethodInfo baseMethod = methodOverride.baseMethod;
        MethodBuilder override = methodOverride.override;
        TypeList parameterTypes = baseMethod.getParameters().getParameterTypes().getErasedTypes();
        Type<?> returnType = baseMethod.getReturnType() == PrimitiveTypes.Void ? baseMethod.getReturnType() : baseMethod.getReturnType().getErasedType();
        TypeList thrownTypes = baseMethod.getThrownTypes().getErasedTypes();
        MethodBuilder bridge = this.defineMethodCore(override.getName(), baseMethod.getModifiers() & 0xFFFFFBFF | 0x40 | 0x1000, returnType, parameterTypes, thrownTypes);
        CodeGenerator code = bridge.getCodeGenerator();
        code.emitThis();
        int parameterTypesSize = parameterTypes.size();
        for (int i = 0; i < parameterTypesSize; ++i) {
            Type s = (Type)parameterTypes.get(i);
            Type<?> t = override.parameterBuilders[i].getParameterType().getErasedType();
            code.emitLoadArgument(i);
            code.emitConversion(s, t);
        }
        code.call(override);
        if (returnType != PrimitiveTypes.Void) {
            code.emitConversion(override.getReturnType().getErasedType(), returnType);
        }
        code.emitReturn(returnType);
    }

    private boolean isBridgeMethodNeeded(MethodOverride methodOverride) {
        TypeList baseParameters;
        Type<?> overrideReturnType;
        MethodInfo baseMethod = methodOverride.baseMethod;
        MethodBuilder override = methodOverride.override;
        Type<?> baseReturnType = baseMethod.getReturnType().getErasedType();
        if (baseReturnType == PrimitiveTypes.Void != ((overrideReturnType = override.getReturnType().getErasedType()) == PrimitiveTypes.Void)) {
            throw Error.incompatibleReturnTypes();
        }
        if (!TypeUtils.areEquivalent(overrideReturnType, baseReturnType)) {
            return true;
        }
        ParameterBuilder[] parameterBuilders = override.parameterBuilders;
        TypeList typeList = baseParameters = baseMethod instanceof MethodBuilder ? ((MethodBuilder)baseMethod).getParameterTypes().getErasedTypes() : baseMethod.getParameters().getParameterTypes().getErasedTypes();
        if (baseParameters.size() != parameterBuilders.length) {
            throw Error.parameterCountMismatch();
        }
        int n = parameterBuilders.length;
        for (int i = 0; i < n; ++i) {
            Class c2;
            Class<?> c1 = parameterBuilders[i].getParameterType().getErasedClass();
            if (c1 == (c2 = ((Type)baseParameters.get(i)).getErasedClass())) continue;
            return true;
        }
        return false;
    }

    private OutputStream getDefaultOutputStream() {
        if (!StringUtilities.isTrue((String)System.getProperty(DumpGeneratedClassesProperty, "false"))) {
            return null;
        }
        String outputPathSetting = System.getProperty(GeneratedClassOutputPathProperty);
        String outputDirectory = outputPathSetting != null ? PathHelper.getFullPath((String)outputPathSetting) : PathHelper.getTempPath();
        String outputFile = PathHelper.combine((String)outputDirectory, (String)(this.getInternalName().replace('/', PathHelper.DirectorySeparator) + ".class"));
        File temp = new File(outputFile);
        File parentDirectory = temp.getParentFile();
        if (!parentDirectory.exists() && !parentDirectory.mkdirs()) {
            return null;
        }
        try {
            return new FileOutputStream(temp);
        }
        catch (IOException e) {
            return null;
        }
    }

    private void updateMembersWithGeneratedReferences() {
        FieldList generatedFields = this._generatedType.getFields(BindingFlags.AllDeclared);
        MethodList generatedMethods = this._generatedType.getMethods(BindingFlags.AllDeclared);
        ConstructorList generatedConstructors = this._generatedType.getConstructors(BindingFlags.AllDeclared);
        int n = this.fieldBuilders.size();
        for (int i = 0; i < n; ++i) {
            this.fieldBuilders.get((int)i).generatedField = (FieldInfo)generatedFields.get(i);
        }
        HashMap<TypeList, ConstructorInfo> constructorLookup = new HashMap<TypeList, ConstructorInfo>();
        HashMap<Pair, MethodInfo> methodLookup = new HashMap<Pair, MethodInfo>();
        Iterator<MethodBase> iterator = generatedConstructors.iterator();
        while (iterator.hasNext()) {
            ConstructorInfo constructor = (ConstructorInfo)iterator.next();
            constructorLookup.put(constructor.getParameters().getParameterTypes(), constructor);
            constructor.getRawConstructor().setAccessible(true);
        }
        iterator = generatedMethods.iterator();
        while (iterator.hasNext()) {
            MethodInfo method = (MethodInfo)iterator.next();
            if ((method.getModifiers() & 0x40) != 0) continue;
            methodLookup.put(Pair.create((Object)method.getName(), (Object)((Object)method.getParameters().getParameterTypes())), method);
        }
        for (ConstructorBuilder constructorBuilder : this.constructorBuilders) {
            constructorBuilder.generatedConstructor = (ConstructorInfo)constructorLookup.get((Object)constructorBuilder.getParameterTypes());
        }
        for (MethodBuilder methodBuilder : this.methodBuilders) {
            methodBuilder.generatedMethod = (MethodInfo)methodLookup.get(Pair.create((Object)methodBuilder.getName(), (Object)((Object)methodBuilder.getParameterTypes())));
        }
    }

    private static Unsafe getUnsafeInstance() {
        if (_unsafe != null) {
            return _unsafe;
        }
        try {
            _unsafe = Unsafe.getUnsafe();
        }
        catch (Throwable ignored) {
            // empty catch block
        }
        try {
            Field instanceField = Unsafe.class.getDeclaredField("theUnsafe");
            instanceField.setAccessible(true);
            _unsafe = (Unsafe)instanceField.get(Unsafe.class);
        }
        catch (Throwable t) {
            throw Error.couldNotLoadUnsafeClassInstance();
        }
        return _unsafe;
    }

    private static final class MethodOverride {
        final MethodBuilder override;
        final MethodInfo baseMethod;

        private MethodOverride(MethodBuilder override, MethodInfo baseMethod) {
            this.baseMethod = baseMethod;
            this.override = override;
        }
    }
}

