/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.config.classification;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import org.jboss.forge.furnace.util.Assert;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.parameters.ParameterizedIterationOperation;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.LinkModel;
import org.jboss.windup.graph.model.WindupVertexFrame;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.graph.model.resource.SourceFileModel;
import org.jboss.windup.graph.service.LinkService;
import org.jboss.windup.reporting.config.Link;
import org.jboss.windup.reporting.config.classification.ClassificationAs;
import org.jboss.windup.reporting.config.classification.ClassificationBuilderOf;
import org.jboss.windup.reporting.config.classification.ClassificationDescription;
import org.jboss.windup.reporting.config.classification.ClassificationEffort;
import org.jboss.windup.reporting.config.classification.ClassificationLink;
import org.jboss.windup.reporting.config.classification.ClassificationSeverity;
import org.jboss.windup.reporting.config.classification.ClassificationTags;
import org.jboss.windup.reporting.model.ClassificationModel;
import org.jboss.windup.reporting.model.Severity;
import org.jboss.windup.reporting.service.ClassificationService;
import org.jboss.windup.rules.files.model.FileReferenceModel;
import org.ocpsoft.rewrite.config.Rule;
import org.ocpsoft.rewrite.context.EvaluationContext;
import org.ocpsoft.rewrite.event.Rewrite;
import org.ocpsoft.rewrite.param.ParameterStore;
import org.ocpsoft.rewrite.param.RegexParameterizedPatternParser;

public class Classification
extends ParameterizedIterationOperation<FileModel>
implements ClassificationAs,
ClassificationEffort,
ClassificationDescription,
ClassificationLink,
ClassificationTags,
ClassificationSeverity {
    public static final Severity DEFAULT_SEVERITY = Severity.OPTIONAL;
    private static final Logger log = Logger.getLogger(Classification.class.getName());
    private List<Link> links = new ArrayList<Link>();
    private Set<String> tags = new HashSet<String>();
    private RegexParameterizedPatternParser classificationPattern;
    private RegexParameterizedPatternParser descriptionPattern;
    private int effort;
    private Severity severity = DEFAULT_SEVERITY;

    Classification(String variable) {
        super(variable);
    }

    Classification() {
    }

    public FileModel resolvePayload(GraphRewrite event, EvaluationContext context, WindupVertexFrame payload) {
        this.checkVariableName(event, context);
        if (payload instanceof FileReferenceModel) {
            return ((FileReferenceModel)payload).getFile();
        }
        if (payload instanceof FileModel) {
            return (FileModel)payload;
        }
        return null;
    }

    public static ClassificationBuilderOf of(String variable) {
        return new ClassificationBuilderOf(variable);
    }

    public Severity getSeverity() {
        return this.severity;
    }

    @Override
    public ClassificationSeverity withSeverity(Severity severity) {
        this.severity = severity;
        return this;
    }

    @Override
    public ClassificationDescription withDescription(String description) {
        this.descriptionPattern = new RegexParameterizedPatternParser(description);
        return this;
    }

    @Override
    public ClassificationLink with(Link link) {
        this.links.add(link);
        return this;
    }

    @Override
    public ClassificationTags withTags(Set<String> tags) {
        this.tags.addAll(tags);
        return this;
    }

    @Override
    public Classification withEffort(int effort) {
        this.effort = effort;
        return this;
    }

    public static ClassificationAs as(String classification) {
        Assert.notNull((Object)classification, (String)"Classification text must not be null.");
        Classification result = new Classification();
        result.classificationPattern = new RegexParameterizedPatternParser(classification);
        return result;
    }

    public void performParameterized(GraphRewrite event, EvaluationContext context, FileModel payload) {
        String description = null;
        if (this.descriptionPattern != null) {
            description = this.descriptionPattern.getBuilder().build((Rewrite)event, context);
        }
        String text = this.classificationPattern.getBuilder().build((Rewrite)event, context);
        GraphContext graphContext = event.getGraphContext();
        ClassificationService classificationService = new ClassificationService(graphContext);
        ClassificationModel classification = (ClassificationModel)classificationService.getUniqueByProperty("ClassificationModel:classification", text);
        if (classification == null) {
            classification = (ClassificationModel)classificationService.create();
            classification.setEffort(this.effort);
            classification.setSeverity(this.severity);
            classification.setDescription(description);
            classification.setClassification(text);
            classification.setRuleID(((Rule)context.get(Rule.class)).getId());
            LinkService linkService = new LinkService(graphContext);
            for (Link link : this.links) {
                LinkModel linkModel = linkService.getOrCreate(link.getTitle(), link.getLink());
                classification.addLink(linkModel);
            }
        }
        classificationService.attachClassification(classification, payload);
        if (payload instanceof SourceFileModel) {
            ((SourceFileModel)payload).setGenerateSourceReport(true);
        }
        log.info("Classification added to " + payload.getPrettyPathWithinProject() + " [" + this + "] ");
    }

    protected void setClassificationText(String classification) {
        this.classificationPattern = new RegexParameterizedPatternParser(classification);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("Classification.as(" + this.classificationPattern.getPattern() + ")");
        if (this.descriptionPattern != null && !this.descriptionPattern.getPattern().trim().isEmpty()) {
            result.append(".withDescription(" + this.descriptionPattern + ")");
        }
        if (this.effort != 0) {
            result.append(".withEffort(" + this.effort + ")");
        }
        if (this.links != null && !this.links.isEmpty()) {
            result.append(".with(" + this.links + ")");
        }
        return result.toString();
    }

    public List<Link> getLinks() {
        return this.links;
    }

    public RegexParameterizedPatternParser getClassificationPattern() {
        return this.classificationPattern;
    }

    public RegexParameterizedPatternParser getDescriptionPattern() {
        return this.descriptionPattern;
    }

    public int getEffort() {
        return this.effort;
    }

    public Set<String> getRequiredParameterNames() {
        HashSet<String> result = new HashSet<String>(this.classificationPattern.getRequiredParameterNames());
        if (this.descriptionPattern != null) {
            result.addAll(this.descriptionPattern.getRequiredParameterNames());
        }
        return result;
    }

    public void setParameterStore(ParameterStore store) {
        this.classificationPattern.setParameterStore(store);
        if (this.descriptionPattern != null) {
            this.descriptionPattern.setParameterStore(store);
        }
    }
}

