/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.freemarker;

import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.forge.furnace.Furnace;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.config.Variables;
import org.jboss.windup.config.operation.iteration.AbstractIterationOperation;
import org.jboss.windup.reporting.freemarker.FreeMarkerUtil;
import org.jboss.windup.reporting.freemarker.FurnaceFreeMarkerTemplateLoader;
import org.jboss.windup.reporting.model.ReportModel;
import org.jboss.windup.reporting.service.ReportService;
import org.jboss.windup.util.ExecutionStatistics;
import org.ocpsoft.rewrite.context.EvaluationContext;

public class FreeMarkerIterationOperation
extends AbstractIterationOperation<ReportModel> {
    private static final String DEFAULT_ITERATION_PAYLOAD_NAME = "reportModel";
    private static final Logger LOG = Logger.getLogger(FreeMarkerIterationOperation.class.getName());
    private final Furnace furnace;
    private final Set<String> variableNames = new HashSet<String>();
    private final boolean useDefaultPayloadVariableName;

    protected FreeMarkerIterationOperation(Furnace furnace, String ... varNames) {
        this.furnace = furnace;
        this.useDefaultPayloadVariableName = true;
        if (varNames != null) {
            for (String varName : varNames) {
                this.variableNames.add(varName);
            }
        }
    }

    protected FreeMarkerIterationOperation(Furnace furnace, String iterationVarName, String ... varNames) {
        super(iterationVarName);
        this.furnace = furnace;
        this.useDefaultPayloadVariableName = false;
        this.variableNames.add(iterationVarName);
        if (varNames != null) {
            for (String varName : varNames) {
                this.variableNames.add(varName);
            }
        }
    }

    public static FreeMarkerIterationOperation create(Furnace furnace, String ... varNames) {
        return new FreeMarkerIterationOperation(furnace, varNames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void perform(GraphRewrite event, EvaluationContext context, ReportModel payload) {
        String templatePath = payload.getTemplatePath();
        String outputFilename = payload.getReportFilename();
        ExecutionStatistics.get().begin("FreeMarkerIterationOperation.render(" + templatePath + ", " + outputFilename + ")");
        try {
            ReportService reportService = new ReportService(event.getGraphContext());
            Path outputDir = Paths.get(reportService.getReportDirectory(), new String[0]);
            if (!Files.isDirectory(outputDir, new LinkOption[0])) {
                Files.createDirectories(outputDir, new FileAttribute[0]);
            }
            Path outputPath = outputDir.resolve(outputFilename);
            LOG.info("Reporting: Writing template \"" + templatePath + "\" to output file \"" + outputPath.toAbsolutePath().toString() + "\"");
            Configuration freemarkerConfig = new Configuration(Configuration.DEFAULT_INCOMPATIBLE_IMPROVEMENTS);
            freemarkerConfig.setTemplateLoader((TemplateLoader)new FurnaceFreeMarkerTemplateLoader());
            freemarkerConfig.setTemplateUpdateDelayMilliseconds(3600L);
            Template template = freemarkerConfig.getTemplate(templatePath);
            Variables varStack = Variables.instance((GraphRewrite)event);
            Map<String, Object> vars = FreeMarkerUtil.findFreeMarkerContextVariables(varStack, this.variableNames.toArray(new String[this.variableNames.size()]));
            if (this.useDefaultPayloadVariableName) {
                vars.put(DEFAULT_ITERATION_PAYLOAD_NAME, payload);
            }
            Map<String, Object> freeMarkerExtensions = FreeMarkerUtil.findFreeMarkerExtensions(this.furnace, event);
            HashMap<String, Object> objects = new HashMap<String, Object>(vars);
            objects.putAll(freeMarkerExtensions);
            try (FileWriter fw = new FileWriter(outputPath.toFile());){
                template.process(objects, (Writer)fw);
            }
            FreeMarkerUtil.addAssociatedReportData(event.getGraphContext(), payload, vars);
        }
        catch (IOException e) {
            LOG.log(Level.WARNING, "Template \"" + templatePath + "\" Failed to write report at \"" + outputFilename + "\" due to: " + e.getMessage(), e);
        }
        catch (TemplateException e) {
            LOG.log(Level.WARNING, "Template \"" + templatePath + "\" Failed to write report at \"" + outputFilename + "\" due to: " + e.getMessage(), e);
        }
        finally {
            ExecutionStatistics.get().end("FreeMarkerIterationOperation.render(" + templatePath + ", " + outputFilename + ")");
        }
    }

    public String toString() {
        return "RenderFreeMarkerTemplate";
    }
}

