/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.windup.reporting.freemarker.problemsummary;

import freemarker.template.TemplateModelException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jboss.windup.config.GraphRewrite;
import org.jboss.windup.graph.GraphContext;
import org.jboss.windup.graph.model.resource.FileModel;
import org.jboss.windup.reporting.freemarker.WindupFreeMarkerMethod;
import org.jboss.windup.reporting.freemarker.problemsummary.ProblemSummary;
import org.jboss.windup.reporting.model.ClassificationModel;
import org.jboss.windup.reporting.model.InlineHintModel;
import org.jboss.windup.reporting.service.ClassificationService;
import org.jboss.windup.reporting.service.InlineHintService;

public class GetProblemSummariesMethod
implements WindupFreeMarkerMethod {
    public static final String NAME = "getProblemSummaries";
    private GraphContext context;

    public String getMethodName() {
        return NAME;
    }

    public String getDescription() {
        return "Returns a summary of all classification and hints found during analysis in the form of a List<" + ProblemSummary.class.getSimpleName() + ">.";
    }

    public Object exec(List arguments) throws TemplateModelException {
        ArrayList<ProblemSummary> results = new ArrayList<ProblemSummary>();
        HashMap<RuleSummaryKey, ProblemSummary> ruleIDToSummary = new HashMap<RuleSummaryKey, ProblemSummary>();
        InlineHintService hintService = new InlineHintService(this.context);
        for (InlineHintModel hint : hintService.findAll()) {
            RuleSummaryKey key = new RuleSummaryKey(hint.getRuleID(), hint.getTitle());
            ProblemSummary summary = (ProblemSummary)ruleIDToSummary.get(key);
            if (summary == null) {
                summary = new ProblemSummary(hint.getRuleID(), hint.getTitle(), 1, hint.getEffort());
                ruleIDToSummary.put(key, summary);
                results.add(summary);
            } else {
                summary.setNumberFound(summary.getNumberFound() + 1);
            }
            summary.addFile(hint.getFile());
        }
        ClassificationService classificationService = new ClassificationService(this.context);
        for (ClassificationModel classification : classificationService.findAll()) {
            RuleSummaryKey key = new RuleSummaryKey(classification.getRuleID(), classification.getClassification());
            ProblemSummary summary = (ProblemSummary)ruleIDToSummary.get(key);
            if (summary == null) {
                summary = new ProblemSummary(classification.getRuleID(), classification.getClassification(), 1, classification.getEffort());
                ruleIDToSummary.put(key, summary);
                results.add(summary);
            } else {
                summary.setNumberFound(summary.getNumberFound() + 1);
            }
            for (FileModel file : classification.getFileModels()) {
                summary.addFile(file);
            }
        }
        return results;
    }

    public void setContext(GraphRewrite event) {
        this.context = event.getGraphContext();
    }

    private class RuleSummaryKey {
        private String ruleID;
        private String title;

        public RuleSummaryKey(String ruleID, String title) {
            this.ruleID = ruleID;
            this.title = title;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RuleSummaryKey that = (RuleSummaryKey)o;
            if (this.ruleID != null ? !this.ruleID.equals(that.ruleID) : that.ruleID != null) {
                return false;
            }
            return !(this.title == null ? that.title != null : !this.title.equals(that.title));
        }

        public int hashCode() {
            int result = this.ruleID != null ? this.ruleID.hashCode() : 0;
            result = 31 * result + (this.title != null ? this.title.hashCode() : 0);
            return result;
        }
    }
}

