/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages;

import com.strobel.annotations.NotNull;
import com.strobel.assembler.ir.ConstantPool;
import com.strobel.assembler.ir.ErrorOperand;
import com.strobel.assembler.ir.ExceptionHandler;
import com.strobel.assembler.ir.Instruction;
import com.strobel.assembler.ir.InstructionCollection;
import com.strobel.assembler.ir.InstructionVisitor;
import com.strobel.assembler.ir.OpCode;
import com.strobel.assembler.ir.OpCodeHelpers;
import com.strobel.assembler.ir.StackMapFrame;
import com.strobel.assembler.ir.attributes.BlobAttribute;
import com.strobel.assembler.ir.attributes.ConstantValueAttribute;
import com.strobel.assembler.ir.attributes.EnclosingMethodAttribute;
import com.strobel.assembler.ir.attributes.ExceptionsAttribute;
import com.strobel.assembler.ir.attributes.InnerClassEntry;
import com.strobel.assembler.ir.attributes.InnerClassesAttribute;
import com.strobel.assembler.ir.attributes.LineNumberTableAttribute;
import com.strobel.assembler.ir.attributes.LineNumberTableEntry;
import com.strobel.assembler.ir.attributes.LocalVariableTableAttribute;
import com.strobel.assembler.ir.attributes.LocalVariableTableEntry;
import com.strobel.assembler.ir.attributes.MethodParameterEntry;
import com.strobel.assembler.ir.attributes.MethodParametersAttribute;
import com.strobel.assembler.ir.attributes.SignatureAttribute;
import com.strobel.assembler.ir.attributes.SourceAttribute;
import com.strobel.assembler.ir.attributes.SourceFileAttribute;
import com.strobel.assembler.metadata.ConstantPoolPrinter;
import com.strobel.assembler.metadata.DynamicCallSite;
import com.strobel.assembler.metadata.FieldDefinition;
import com.strobel.assembler.metadata.FieldReference;
import com.strobel.assembler.metadata.Flags;
import com.strobel.assembler.metadata.GenericParameter;
import com.strobel.assembler.metadata.IMetadataResolver;
import com.strobel.assembler.metadata.Label;
import com.strobel.assembler.metadata.MetadataHelper;
import com.strobel.assembler.metadata.MetadataParser;
import com.strobel.assembler.metadata.MetadataSystem;
import com.strobel.assembler.metadata.MethodBody;
import com.strobel.assembler.metadata.MethodBodyParseException;
import com.strobel.assembler.metadata.MethodDefinition;
import com.strobel.assembler.metadata.MethodReference;
import com.strobel.assembler.metadata.ParameterDefinition;
import com.strobel.assembler.metadata.SwitchInfo;
import com.strobel.assembler.metadata.TypeDefinition;
import com.strobel.assembler.metadata.TypeMetadataVisitor;
import com.strobel.assembler.metadata.TypeReference;
import com.strobel.assembler.metadata.VariableDefinition;
import com.strobel.assembler.metadata.VariableDefinitionCollection;
import com.strobel.assembler.metadata.VariableReference;
import com.strobel.core.ExceptionUtilities;
import com.strobel.core.StringUtilities;
import com.strobel.core.VerifyArgument;
import com.strobel.decompiler.DecompilationOptions;
import com.strobel.decompiler.DecompilerHelpers;
import com.strobel.decompiler.DecompilerSettings;
import com.strobel.decompiler.ITextOutput;
import com.strobel.decompiler.NameSyntax;
import com.strobel.decompiler.PlainTextOutput;
import com.strobel.decompiler.languages.Language;
import com.strobel.decompiler.languages.TypeDecompilationResults;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;

public class BytecodeLanguage
extends Language {
    @Override
    public String getName() {
        return "Bytecode";
    }

    @Override
    public String getFileExtension() {
        return ".class";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TypeDecompilationResults decompileType(TypeDefinition type, ITextOutput output, DecompilationOptions options) {
        VerifyArgument.notNull((Object)type, (String)"type");
        VerifyArgument.notNull((Object)output, (String)"output");
        VerifyArgument.notNull((Object)options, (String)"options");
        if (type.isInterface()) {
            if (type.isAnnotation()) {
                output.writeKeyword("@interface");
            } else {
                output.writeKeyword("interface");
            }
        } else if (type.isEnum()) {
            output.writeKeyword("enum");
        } else {
            output.writeKeyword("class");
        }
        output.write(' ');
        DecompilerHelpers.writeType(output, type, NameSyntax.TYPE_NAME, true);
        output.writeLine();
        output.indent();
        try {
            this.writeTypeHeader(output, type);
            for (SourceAttribute sourceAttribute : type.getSourceAttributes()) {
                this.writeTypeAttribute(output, type, sourceAttribute);
            }
            ConstantPool constantPool = type.getConstantPool();
            if (constantPool != null) {
                constantPool.accept(new ConstantPoolPrinter(output, options.getSettings()));
            }
            for (FieldDefinition field : type.getDeclaredFields()) {
                output.writeLine();
                this.decompileField(field, output, options);
            }
            for (MethodDefinition method : type.getDeclaredMethods()) {
                output.writeLine();
                try {
                    this.decompileMethod(method, output, options);
                }
                catch (MethodBodyParseException e) {
                    this.writeMethodBodyParseError(output, e);
                }
            }
        }
        finally {
            output.unindent();
        }
        if (!options.getSettings().getExcludeNestedTypes()) {
            for (TypeDefinition typeDefinition : type.getDeclaredTypes()) {
                output.writeLine();
                this.decompileType(typeDefinition, output, options);
            }
        }
        return new TypeDecompilationResults(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeMethodBodyParseError(ITextOutput output, Throwable error) {
        output.indent();
        try {
            output.writeError("Method could not be disassembled because an error occurred.");
            output.writeLine();
            for (String line : StringUtilities.split((String)ExceptionUtilities.getStackTraceString((Throwable)error), (boolean)true, (char)'\r', (char[])new char[]{'\n'})) {
                output.writeError(line);
                output.writeLine();
            }
        }
        finally {
            output.unindent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeTypeAttribute(ITextOutput output, TypeDefinition type, SourceAttribute attribute) {
        if (attribute instanceof BlobAttribute) {
            return;
        }
        switch (attribute.getName()) {
            case "SourceFile": {
                output.writeAttribute("SourceFile");
                output.write(": ");
                output.writeTextLiteral(((SourceFileAttribute)attribute).getSourceFile());
                output.writeLine();
                break;
            }
            case "Deprecated": {
                output.writeAttribute("Deprecated");
                output.writeLine();
                break;
            }
            case "EnclosingMethod": {
                TypeReference enclosingType = ((EnclosingMethodAttribute)attribute).getEnclosingType();
                MethodReference enclosingMethod = ((EnclosingMethodAttribute)attribute).getEnclosingMethod();
                if (enclosingType != null) {
                    output.writeAttribute("EnclosingType");
                    output.write(": ");
                    output.writeReference(enclosingType.getInternalName(), enclosingType);
                    output.writeLine();
                }
                if (enclosingMethod == null) break;
                TypeReference declaringType = enclosingMethod.getDeclaringType();
                output.writeAttribute("EnclosingMethod");
                output.write(": ");
                output.writeReference(declaringType.getInternalName(), declaringType);
                output.writeDelimiter(".");
                output.writeReference(enclosingMethod.getName(), enclosingMethod);
                output.writeDelimiter(":");
                DecompilerHelpers.writeMethodSignature(output, enclosingMethod);
                output.writeLine();
                break;
            }
            case "InnerClasses": {
                InnerClassesAttribute innerClasses = (InnerClassesAttribute)attribute;
                List<InnerClassEntry> entries = innerClasses.getEntries();
                output.writeAttribute("InnerClasses");
                output.writeLine(": ");
                output.indent();
                try {
                    for (InnerClassEntry entry : entries) {
                        this.writeInnerClassEntry(output, type, entry);
                    }
                }
                finally {
                    output.unindent();
                }
            }
            case "Signature": {
                output.writeAttribute("Signature");
                output.write(": ");
                DecompilerHelpers.writeGenericSignature(output, type);
                output.writeLine();
            }
        }
    }

    private void writeInnerClassEntry(ITextOutput output, TypeDefinition type, InnerClassEntry entry) {
        String shortName = entry.getShortName();
        String innerClassName = entry.getInnerClassName();
        String outerClassName = entry.getOuterClassName();
        EnumSet<Flags.Flag> flagsSet = Flags.asFlagSet(entry.getAccessFlags(), Flags.Kind.InnerClass);
        for (Flags.Flag flag : flagsSet) {
            output.writeKeyword(flag.toString());
            output.write(' ');
        }
        MetadataParser parser = new MetadataParser(type);
        if (this.tryWriteType(output, parser, shortName, innerClassName)) {
            output.writeDelimiter(" = ");
        }
        if (!this.tryWriteType(output, parser, innerClassName, innerClassName)) {
            output.writeError("?");
        }
        if (!StringUtilities.isNullOrEmpty((String)outerClassName)) {
            output.writeDelimiter(" of ");
            if (!this.tryWriteType(output, parser, outerClassName, outerClassName)) {
                output.writeError("?");
            }
        }
        output.writeLine();
    }

    private boolean tryWriteType(@NotNull ITextOutput output, @NotNull MetadataParser parser, String text, String descriptor) {
        if (StringUtilities.isNullOrEmpty((String)text)) {
            return false;
        }
        if (StringUtilities.isNullOrEmpty((String)descriptor)) {
            output.writeError(text);
            return true;
        }
        try {
            TypeReference type = parser.parseTypeDescriptor(descriptor);
            output.writeReference(text, type);
            return true;
        }
        catch (Throwable ignored) {
            try {
                output.writeReference(text, new DummyTypeReference(descriptor));
                return true;
            }
            catch (Throwable ignored2) {
                output.writeError(text);
                return true;
            }
        }
    }

    private void writeTypeHeader(ITextOutput output, TypeDefinition type) {
        output.writeAttribute("Minor version");
        output.write(": ");
        output.writeLiteral(type.getCompilerMinorVersion());
        output.writeLine();
        output.writeAttribute("Major version");
        output.write(": ");
        output.writeLiteral(type.getCompilerMajorVersion());
        output.writeLine();
        long flags = type.getFlags();
        ArrayList<String> flagStrings = new ArrayList<String>();
        EnumSet<Flags.Flag> flagsSet = Flags.asFlagSet(flags, type.isInnerClass() ? Flags.Kind.InnerClass : Flags.Kind.Class);
        for (Flags.Flag flag : flagsSet) {
            flagStrings.add(flag.name());
        }
        if (!flagStrings.isEmpty()) {
            output.writeAttribute("Flags");
            output.write(": ");
            for (int i = 0; i < flagStrings.size(); ++i) {
                if (i != 0) {
                    output.write(", ");
                }
                output.writeLiteral(flagStrings.get(i));
            }
            output.writeLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void decompileField(FieldDefinition field, ITextOutput output, DecompilationOptions options) {
        long flags = field.getFlags();
        EnumSet<Flags.Flag> flagSet = Flags.asFlagSet(flags & 0x40DFL & 0xFFFFFFFFFFFFBFFFL, Flags.Kind.Field);
        ArrayList<String> flagStrings = new ArrayList<String>();
        for (Flags.Flag flag : flagSet) {
            flagStrings.add(flag.toString());
        }
        if (flagSet.size() > 0) {
            for (int i = 0; i < flagStrings.size(); ++i) {
                output.writeKeyword((String)flagStrings.get(i));
                output.write(' ');
            }
        }
        DecompilerHelpers.writeType(output, field.getFieldType(), NameSyntax.TYPE_NAME);
        output.write(' ');
        output.writeDefinition(field.getName(), field);
        output.writeDelimiter(";");
        output.writeLine();
        flagStrings.clear();
        for (Flags.Flag flag : Flags.asFlagSet(flags & 0xFFFFFFFFFFFFF0DFL, Flags.Kind.Field)) {
            flagStrings.add(flag.name());
        }
        if (flagStrings.isEmpty()) {
            return;
        }
        output.indent();
        try {
            output.writeAttribute("Flags");
            output.write(": ");
            for (int i = 0; i < flagStrings.size(); ++i) {
                if (i != 0) {
                    output.write(", ");
                }
                output.writeLiteral(flagStrings.get(i));
            }
            output.writeLine();
            for (SourceAttribute attribute : field.getSourceAttributes()) {
                this.writeFieldAttribute(output, field, attribute);
            }
        }
        finally {
            output.unindent();
        }
    }

    private void writeFieldAttribute(ITextOutput output, FieldDefinition field, SourceAttribute attribute) {
        switch (attribute.getName()) {
            case "ConstantValue": {
                Object constantValue = ((ConstantValueAttribute)attribute).getValue();
                output.writeAttribute("ConstantValue");
                output.write(": ");
                if (constantValue != null) {
                    String typeDescriptor = constantValue.getClass().getName().replace('.', '/');
                    TypeReference valueType = field.getDeclaringType().getResolver().lookupType(typeDescriptor);
                    if (valueType != null) {
                        DecompilerHelpers.writeType(output, MetadataHelper.getUnderlyingPrimitiveTypeOrSelf(valueType), NameSyntax.TYPE_NAME);
                        output.write(' ');
                    }
                }
                DecompilerHelpers.writeOperand(output, constantValue);
                output.writeLine();
                break;
            }
            case "Signature": {
                output.writeAttribute("Signature");
                output.write(": ");
                DecompilerHelpers.writeType(output, field.getFieldType(), NameSyntax.SIGNATURE, false);
                output.writeLine();
            }
        }
    }

    @Override
    public void decompileMethod(MethodDefinition method, ITextOutput output, DecompilationOptions options) {
        this.writeMethodHeader(output, method);
        this.writeMethodBody(output, method, options);
        for (SourceAttribute attribute : method.getSourceAttributes()) {
            this.writeMethodAttribute(output, method, attribute);
        }
        this.writeMethodEnd(output, method, options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeMethodHeader(ITextOutput output, MethodDefinition method) {
        String name = method.getName();
        long flags = Flags.fromStandardFlags(method.getFlags(), Flags.Kind.Method);
        ArrayList<String> flagStrings = new ArrayList<String>();
        if ("<clinit>".equals(name)) {
            output.writeKeyword("static");
            output.write(" {}");
        } else {
            List<GenericParameter> genericParameters;
            EnumSet<Flags.Flag> flagSet = Flags.asFlagSet(flags & 0xD3FL, Flags.Kind.Method);
            Iterator iterator = flagSet.iterator();
            while (iterator.hasNext()) {
                Flags.Flag flag = (Flags.Flag)((Object)iterator.next());
                flagStrings.add(flag.toString());
            }
            if (flagSet.size() > 0) {
                for (int i = 0; i < flagStrings.size(); ++i) {
                    output.writeKeyword((String)flagStrings.get(i));
                    output.write(' ');
                }
            }
            if (!(genericParameters = method.getGenericParameters()).isEmpty()) {
                output.writeDelimiter("<");
                for (int i = 0; i < genericParameters.size(); ++i) {
                    if (i != 0) {
                        output.writeDelimiter(", ");
                    }
                    DecompilerHelpers.writeType(output, genericParameters.get(i), NameSyntax.TYPE_NAME, true);
                }
                output.writeDelimiter(">");
                output.write(' ');
            }
            DecompilerHelpers.writeType(output, method.getReturnType(), NameSyntax.TYPE_NAME, false);
            output.write(' ');
            output.writeDefinition(name, method);
            output.writeDelimiter("(");
            List<ParameterDefinition> parameters = method.getParameters();
            for (int i = 0; i < parameters.size(); ++i) {
                if (i != 0) {
                    output.writeDelimiter(", ");
                }
                ParameterDefinition parameter = parameters.get(i);
                if (Flags.testAny(flags, 0x400000080L) && i == parameters.size() - 1) {
                    DecompilerHelpers.writeType(output, parameter.getParameterType().getElementType(), NameSyntax.TYPE_NAME, false);
                    output.writeDelimiter("...");
                } else {
                    DecompilerHelpers.writeType(output, parameter.getParameterType(), NameSyntax.TYPE_NAME, false);
                }
                output.write(' ');
                String parameterName = parameter.getName();
                if (StringUtilities.isNullOrEmpty((String)parameterName)) {
                    output.write("p%d", i);
                    continue;
                }
                output.write(parameterName);
            }
            output.writeDelimiter(")");
            List<TypeReference> thrownTypes = method.getThrownTypes();
            if (!thrownTypes.isEmpty()) {
                output.writeKeyword(" throws ");
                for (int i = 0; i < thrownTypes.size(); ++i) {
                    if (i != 0) {
                        output.writeDelimiter(", ");
                    }
                    DecompilerHelpers.writeType(output, thrownTypes.get(i), NameSyntax.TYPE_NAME, false);
                }
            }
        }
        output.writeDelimiter(";");
        output.writeLine();
        flagStrings.clear();
        for (Flags.Flag flag : Flags.asFlagSet(flags & 0xFFFFFFFFFFFFFD3FL, Flags.Kind.Method)) {
            flagStrings.add(flag.name());
        }
        if (flagStrings.isEmpty()) {
            return;
        }
        output.indent();
        try {
            output.writeAttribute("Flags");
            output.write(": ");
            for (int i = 0; i < flagStrings.size(); ++i) {
                if (i != 0) {
                    output.write(", ");
                }
                output.writeLiteral(flagStrings.get(i));
            }
            output.writeLine();
        }
        finally {
            output.unindent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeMethodAttribute(ITextOutput output, MethodDefinition method, SourceAttribute attribute) {
        switch (attribute.getName()) {
            case "Exceptions": {
                ExceptionsAttribute exceptionsAttribute = (ExceptionsAttribute)attribute;
                List<TypeReference> exceptionTypes = exceptionsAttribute.getExceptionTypes();
                if (exceptionTypes.isEmpty()) break;
                output.indent();
                try {
                    output.writeAttribute("Exceptions");
                    output.writeLine(":");
                    output.indent();
                    try {
                        for (TypeReference exceptionType : exceptionTypes) {
                            output.writeKeyword("throws");
                            output.write(' ');
                            DecompilerHelpers.writeType(output, exceptionType, NameSyntax.TYPE_NAME);
                            output.writeLine();
                        }
                        break;
                    }
                    finally {
                        output.unindent();
                    }
                }
                finally {
                    output.unindent();
                }
            }
            case "LocalVariableTable": 
            case "LocalVariableTypeTable": {
                LocalVariableTableAttribute localVariables = (LocalVariableTableAttribute)attribute;
                List<LocalVariableTableEntry> entries = localVariables.getEntries();
                int longestName = "Name".length();
                int longestSignature = "Signature".length();
                for (LocalVariableTableEntry localVariableTableEntry : entries) {
                    String signature;
                    String name = localVariableTableEntry.getName();
                    TypeReference type = localVariableTableEntry.getType();
                    if (type != null && (signature = attribute.getName().equals("LocalVariableTypeTable") ? type.getSignature() : type.getErasedSignature()).length() > longestSignature) {
                        longestSignature = signature.length();
                    }
                    if (name == null || name.length() <= longestName) continue;
                    longestName = name.length();
                }
                output.indent();
                try {
                    output.writeAttribute(attribute.getName());
                    output.writeLine(":");
                    output.indent();
                    try {
                        output.write("Start  Length  Slot  %1$-" + longestName + "s  Signature", "Name");
                        output.writeLine();
                        output.write("-----  ------  ----  %1$-" + longestName + "s  %2$-" + longestSignature + "s", StringUtilities.repeat((char)'-', (int)longestName), StringUtilities.repeat((char)'-', (int)longestSignature));
                        output.writeLine();
                        MethodBody body = method.getBody();
                        for (LocalVariableTableEntry entry : entries) {
                            VariableDefinitionCollection variables = body != null ? body.getVariables() : null;
                            NameSyntax nameSyntax = attribute.getName().equals("LocalVariableTypeTable") ? NameSyntax.SIGNATURE : NameSyntax.ERASED_SIGNATURE;
                            output.writeLiteral(String.format("%1$-5d", entry.getScopeOffset()));
                            output.write("  ");
                            output.writeLiteral(String.format("%1$-6d", entry.getScopeLength()));
                            output.write("  ");
                            output.writeLiteral(String.format("%1$-4d", entry.getIndex()));
                            output.writeReference(String.format("  %1$-" + longestName + "s  ", entry.getName()), variables != null ? variables.tryFind(entry.getIndex(), entry.getScopeOffset()) : null);
                            DecompilerHelpers.writeType(output, entry.getType(), nameSyntax);
                            output.writeLine();
                        }
                        break;
                    }
                    finally {
                        output.unindent();
                    }
                }
                finally {
                    output.unindent();
                }
            }
            case "MethodParameters": {
                Object flags;
                MethodParametersAttribute parameters = (MethodParametersAttribute)attribute;
                List<MethodParameterEntry> entries = parameters.getEntries();
                int longestName = "Name".length();
                int longestFlags = "Flags".length();
                for (MethodParameterEntry methodParameterEntry : entries) {
                    String name = methodParameterEntry.getName();
                    flags = Flags.toString(methodParameterEntry.getFlags());
                    if (name != null && name.length() > longestName) {
                        longestName = name.length();
                    }
                    if (flags == null || ((String)flags).length() <= longestFlags) continue;
                    longestFlags = ((String)flags).length();
                }
                output.indent();
                try {
                    output.writeAttribute(attribute.getName());
                    output.writeLine(":");
                    output.indent();
                    try {
                        output.write("%1$-" + longestName + "s  %2$-" + longestFlags + "s  ", "Name", "Flags");
                        output.writeLine();
                        output.write("%1$-" + longestName + "s  %2$-" + longestFlags + "s", StringUtilities.repeat((char)'-', (int)longestName), StringUtilities.repeat((char)'-', (int)longestFlags));
                        output.writeLine();
                        for (int i = 0; i < entries.size(); ++i) {
                            MethodParameterEntry methodParameterEntry = entries.get(i);
                            List<ParameterDefinition> parameterDefinitions = method.getParameters();
                            output.writeReference(String.format("%1$-" + longestName + "s  ", methodParameterEntry.getName()), i < parameterDefinitions.size() ? parameterDefinitions.get(i) : null);
                            flags = Flags.asFlagSet(methodParameterEntry.getFlags());
                            boolean firstFlag = true;
                            Iterator iterator = ((AbstractCollection)flags).iterator();
                            while (iterator.hasNext()) {
                                Flags.Flag flag = (Flags.Flag)((Object)iterator.next());
                                if (!firstFlag) {
                                    output.writeDelimiter(", ");
                                }
                                output.writeLiteral(flag.name());
                                firstFlag = false;
                            }
                            output.writeLine();
                        }
                        break;
                    }
                    finally {
                        output.unindent();
                    }
                }
                finally {
                    output.unindent();
                }
            }
            case "Signature": {
                output.indent();
                try {
                    String signature = ((SignatureAttribute)attribute).getSignature();
                    output.writeAttribute(attribute.getName());
                    output.writeLine(":");
                    output.indent();
                    PlainTextOutput temp = new PlainTextOutput();
                    DecompilerHelpers.writeMethodSignature(temp, method);
                    DecompilerHelpers.writeMethodSignature(output, method);
                    if (!StringUtilities.equals((String)temp.toString(), (String)signature)) {
                        output.write(' ');
                        output.writeDelimiter("[");
                        output.write("from metadata: ");
                        output.writeError(signature);
                        output.writeDelimiter("]");
                        output.writeLine();
                    }
                    output.writeLine();
                    output.unindent();
                    break;
                }
                finally {
                    output.unindent();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeMethodBody(ITextOutput output, MethodDefinition method, DecompilationOptions options) {
        MethodBody body = method.getBody();
        if (body == null) {
            return;
        }
        output.indent();
        try {
            output.writeAttribute("Code");
            output.writeLine(":");
            output.indent();
            try {
                output.write("stack=");
                output.writeLiteral(body.getMaxStackSize());
                output.write(", locals=");
                output.writeLiteral(body.getMaxLocals());
                output.write(", arguments=");
                output.writeLiteral(method.getParameters().size());
                output.writeLine();
            }
            finally {
                output.unindent();
            }
            InstructionCollection instructions = body.getInstructions();
            if (!instructions.isEmpty()) {
                int[] lineNumbers;
                if (options.getSettings().getIncludeLineNumbersInBytecode()) {
                    LineNumberTableAttribute lineNumbersAttribute = (LineNumberTableAttribute)SourceAttribute.find("LineNumberTable", method.getSourceAttributes());
                    if (lineNumbersAttribute != null) {
                        lineNumbers = new int[body.getCodeSize()];
                        Arrays.fill(lineNumbers, -1);
                        for (LineNumberTableEntry entry : lineNumbersAttribute.getEntries()) {
                            if (entry.getOffset() >= lineNumbers.length) {
                                lineNumbers = Arrays.copyOf(lineNumbers, entry.getOffset() + 1);
                            }
                            lineNumbers[entry.getOffset()] = entry.getLineNumber();
                        }
                    } else {
                        lineNumbers = null;
                    }
                } else {
                    lineNumbers = null;
                }
                InstructionPrinter printer = new InstructionPrinter(output, method, options.getSettings(), lineNumbers);
                for (Instruction instruction : instructions) {
                    printer.visit(instruction);
                }
            }
        }
        finally {
            output.unindent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeMethodEnd(ITextOutput output, MethodDefinition method, DecompilationOptions options) {
        MethodBody body = method.getBody();
        if (body == null) {
            return;
        }
        List<ExceptionHandler> handlers = body.getExceptionHandlers();
        List<StackMapFrame> stackMapFrames = body.getStackMapFrames();
        if (!handlers.isEmpty()) {
            output.indent();
            try {
                int longestType = "Type".length();
                for (ExceptionHandler handler : handlers) {
                    String signature;
                    TypeReference catchType = handler.getCatchType();
                    if (catchType == null || (signature = catchType.getSignature()).length() <= longestType) continue;
                    longestType = signature.length();
                }
                output.writeAttribute("Exceptions");
                output.writeLine(":");
                output.indent();
                try {
                    output.write("Try           Handler");
                    output.writeLine();
                    output.write("Start  End    Start  End    %1$-" + longestType + "s", "Type");
                    output.writeLine();
                    output.write("-----  -----  -----  -----  %1$-" + longestType + "s", StringUtilities.repeat((char)'-', (int)longestType));
                    output.writeLine();
                    for (ExceptionHandler handler : handlers) {
                        boolean isFinally;
                        TypeReference catchType = handler.getCatchType();
                        if (catchType != null) {
                            isFinally = false;
                        } else {
                            catchType = BytecodeLanguage.getResolver(body).lookupType("java/lang/Throwable");
                            isFinally = true;
                        }
                        output.writeLiteral(String.format("%1$-5d", handler.getTryBlock().getFirstInstruction().getOffset()));
                        output.write("  ");
                        output.writeLiteral(String.format("%1$-5d", handler.getTryBlock().getLastInstruction().getEndOffset()));
                        output.write("  ");
                        output.writeLiteral(String.format("%1$-5d", handler.getHandlerBlock().getFirstInstruction().getOffset()));
                        output.write("  ");
                        output.writeLiteral(String.format("%1$-5d", handler.getHandlerBlock().getLastInstruction().getEndOffset()));
                        output.write("  ");
                        if (isFinally) {
                            output.writeReference("Any", catchType);
                        } else {
                            DecompilerHelpers.writeType(output, catchType, NameSyntax.SIGNATURE);
                        }
                        output.writeLine();
                    }
                }
                finally {
                    output.unindent();
                }
            }
            finally {
                output.unindent();
            }
        }
        if (!stackMapFrames.isEmpty()) {
            output.indent();
            try {
                output.writeAttribute("Stack Map Frames");
                output.writeLine(":");
                output.indent();
                try {
                    for (StackMapFrame frame : stackMapFrames) {
                        DecompilerHelpers.writeOffsetReference(output, frame.getStartInstruction());
                        output.write(' ');
                        DecompilerHelpers.writeFrame(output, frame.getFrame());
                        output.writeLine();
                    }
                }
                finally {
                    output.unindent();
                }
            }
            finally {
                output.unindent();
            }
        }
    }

    private static IMetadataResolver getResolver(MethodBody body) {
        TypeDefinition declaringType;
        MethodDefinition resolvedMethod;
        MethodDefinition method = body.getMethod();
        if (method != null && (resolvedMethod = method.resolve()) != null && (declaringType = resolvedMethod.getDeclaringType()) != null) {
            return declaringType.getResolver();
        }
        return MetadataSystem.instance();
    }

    private static final class DummyTypeReference
    extends TypeReference {
        private final String _descriptor;
        private final String _fullName;
        private final String _simpleName;

        public DummyTypeReference(String descriptor) {
            this._descriptor = (String)VerifyArgument.notNull((Object)descriptor, (String)"descriptor");
            this._fullName = descriptor.replace('/', '.');
            int delimiterIndex = this._fullName.lastIndexOf(46);
            this._simpleName = delimiterIndex < 0 || delimiterIndex == this._fullName.length() - 1 ? this._fullName : this._fullName.substring(delimiterIndex + 1);
        }

        @Override
        public final String getSimpleName() {
            return this._simpleName;
        }

        @Override
        public final String getFullName() {
            return this._fullName;
        }

        @Override
        public final String getInternalName() {
            return this._descriptor;
        }

        @Override
        public final <R, P> R accept(TypeMetadataVisitor<P, R> visitor, P parameter) {
            return visitor.visitClassType(this, parameter);
        }
    }

    private static final class InstructionPrinter
    implements InstructionVisitor {
        private static final int MAX_OPCODE_LENGTH;
        private static final String[] OPCODE_NAMES;
        private static final String LINE_NUMBER_CODE = "linenumber";
        private final DecompilerSettings _settings;
        private final ITextOutput _output;
        private final MethodBody _body;
        private final int[] _lineNumbers;
        private int _currentOffset = -1;

        private InstructionPrinter(ITextOutput output, MethodDefinition method, DecompilerSettings settings, int[] lineNumbers) {
            this._settings = settings;
            this._output = (ITextOutput)VerifyArgument.notNull((Object)output, (String)"output");
            this._body = ((MethodDefinition)VerifyArgument.notNull((Object)method, (String)"method")).getBody();
            this._lineNumbers = lineNumbers;
        }

        private void printOpCode(OpCode opCode) {
            switch (opCode) {
                case TABLESWITCH: 
                case LOOKUPSWITCH: {
                    this._output.writeReference(OPCODE_NAMES[opCode.ordinal()], (Object)opCode);
                    break;
                }
                default: {
                    this._output.writeReference(String.format("%1$-" + MAX_OPCODE_LENGTH + "s", OPCODE_NAMES[opCode.ordinal()]), (Object)opCode);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void visit(Instruction instruction) {
            int lineNumber;
            VerifyArgument.notNull((Object)instruction, (String)"instruction");
            if (this._lineNumbers != null && (lineNumber = this._lineNumbers[instruction.getOffset()]) >= 0) {
                this._output.write("          ");
                this._output.write("%1$-" + MAX_OPCODE_LENGTH + "s", LINE_NUMBER_CODE);
                this._output.write(' ');
                this._output.writeLiteral(lineNumber);
                this._output.writeLine();
            }
            this._currentOffset = instruction.getOffset();
            try {
                this._output.writeLabel(String.format("%1$8d", instruction.getOffset()));
                this._output.write(": ");
                instruction.accept(this);
            }
            catch (Throwable t) {
                this.printOpCode(instruction.getOpCode());
                boolean foundError = false;
                for (int i = 0; i < instruction.getOperandCount(); ++i) {
                    Object operand = instruction.getOperand(i);
                    if (!(operand instanceof ErrorOperand)) continue;
                    this._output.write(String.valueOf(operand));
                    foundError = true;
                    break;
                }
                if (!foundError) {
                    this._output.write("!!! ERROR");
                }
                this._output.writeLine();
            }
            finally {
                this._currentOffset = -1;
            }
        }

        @Override
        public void visit(OpCode op) {
            VariableDefinition variable;
            VariableDefinitionCollection variables;
            this.printOpCode(op);
            int slot = OpCodeHelpers.getLoadStoreMacroArgumentIndex(op);
            if (slot >= 0 && slot < (variables = this._body.getVariables()).size() && (variable = this.findVariable(op, slot, this._currentOffset)) != null && variable.hasName() && variable.isFromMetadata()) {
                this._output.writeComment(" /* %s */", StringUtilities.escape((String)variable.getName(), (boolean)false, (boolean)this._settings.isUnicodeOutputEnabled()));
            }
            this._output.writeLine();
        }

        private VariableDefinition findVariable(OpCode op, int slot, int offset) {
            VariableDefinition variable = this._body.getVariables().tryFind(slot, offset);
            if (variable == null && op.isStore()) {
                variable = this._body.getVariables().tryFind(slot, offset + op.getSize() + op.getOperandType().getBaseSize());
            }
            return variable;
        }

        @Override
        public void visitConstant(OpCode op, TypeReference value) {
            this.printOpCode(op);
            this._output.write(' ');
            DecompilerHelpers.writeType(this._output, value, NameSyntax.ERASED_SIGNATURE);
            this._output.write(".class");
            this._output.writeLine();
        }

        @Override
        public void visitConstant(OpCode op, int value) {
            this.printOpCode(op);
            this._output.write(' ');
            this._output.writeLiteral(value);
            this._output.writeLine();
        }

        @Override
        public void visitConstant(OpCode op, long value) {
            this.printOpCode(op);
            this._output.write(' ');
            this._output.writeLiteral(value);
            this._output.writeLine();
        }

        @Override
        public void visitConstant(OpCode op, float value) {
            this.printOpCode(op);
            this._output.write(' ');
            this._output.writeLiteral(Float.valueOf(value));
            this._output.writeLine();
        }

        @Override
        public void visitConstant(OpCode op, double value) {
            this.printOpCode(op);
            this._output.write(' ');
            this._output.writeLiteral(value);
            this._output.writeLine();
        }

        @Override
        public void visitConstant(OpCode op, String value) {
            this.printOpCode(op);
            this._output.write(' ');
            this._output.writeTextLiteral(StringUtilities.escape((String)value, (boolean)true, (boolean)this._settings.isUnicodeOutputEnabled()));
            this._output.writeLine();
        }

        @Override
        public void visitBranch(OpCode op, Instruction target) {
            this.printOpCode(op);
            this._output.write(' ');
            this._output.writeLabel(String.valueOf(target.getOffset()));
            this._output.writeLine();
        }

        @Override
        public void visitVariable(OpCode op, VariableReference variable) {
            this.printOpCode(op);
            this._output.write(' ');
            VariableDefinition definition = this.findVariable(op, variable.getSlot(), this._currentOffset);
            if (definition != null && definition.hasName() && definition.isFromMetadata()) {
                this._output.writeReference(variable.getName(), variable);
            } else {
                this._output.writeLiteral(variable.getSlot());
            }
            this._output.writeLine();
        }

        @Override
        public void visitVariable(OpCode op, VariableReference variable, int operand) {
            this.printOpCode(op);
            this._output.write(' ');
            VariableDefinition definition = variable instanceof VariableDefinition ? (VariableDefinition)variable : this.findVariable(op, variable.getSlot(), this._currentOffset);
            if (definition != null && definition.hasName() && definition.isFromMetadata()) {
                this._output.writeReference(variable.getName(), variable);
            } else {
                this._output.writeLiteral(variable.getSlot());
            }
            this._output.write(", ");
            this._output.writeLiteral(String.valueOf(operand));
            this._output.writeLine();
        }

        @Override
        public void visitType(OpCode op, TypeReference type) {
            this.printOpCode(op);
            this._output.write(' ');
            DecompilerHelpers.writeType(this._output, type, NameSyntax.SIGNATURE);
            this._output.writeLine();
        }

        @Override
        public void visitMethod(OpCode op, MethodReference method) {
            this.printOpCode(op);
            this._output.write(' ');
            DecompilerHelpers.writeMethod(this._output, method);
            this._output.writeLine();
        }

        @Override
        public void visitDynamicCallSite(OpCode op, DynamicCallSite callSite) {
            this.printOpCode(op);
            this._output.write(' ');
            this._output.writeReference(callSite.getMethodName(), callSite.getMethodType());
            this._output.writeDelimiter(":");
            DecompilerHelpers.writeMethodSignature(this._output, callSite.getMethodType());
            this._output.writeLine();
        }

        @Override
        public void visitField(OpCode op, FieldReference field) {
            this.printOpCode(op);
            this._output.write(' ');
            DecompilerHelpers.writeField(this._output, field);
            this._output.writeLine();
        }

        @Override
        public void visitLabel(Label label) {
        }

        @Override
        public void visitSwitch(OpCode op, SwitchInfo switchInfo) {
            this.printOpCode(op);
            this._output.write(" {");
            this._output.writeLine();
            switch (op) {
                case TABLESWITCH: {
                    Instruction[] targets = switchInfo.getTargets();
                    int caseValue = switchInfo.getLowValue();
                    for (Instruction target : targets) {
                        this._output.write("            ");
                        this._output.writeLiteral(String.format("%1$7d", switchInfo.getLowValue() + caseValue++));
                        this._output.write(": ");
                        this._output.writeLabel(String.valueOf(target.getOffset()));
                        this._output.writeLine();
                    }
                    this._output.write("            ");
                    this._output.writeKeyword("default");
                    this._output.write(": ");
                    this._output.writeLabel(String.valueOf(switchInfo.getDefaultTarget().getOffset()));
                    this._output.writeLine();
                    break;
                }
                case LOOKUPSWITCH: {
                    int[] keys = switchInfo.getKeys();
                    Instruction[] targets = switchInfo.getTargets();
                    for (int i = 0; i < keys.length; ++i) {
                        int key = keys[i];
                        Instruction target = targets[i];
                        this._output.write("            ");
                        this._output.writeLiteral(String.format("%1$7d", key));
                        this._output.write(": ");
                        this._output.writeLabel(String.valueOf(target.getOffset()));
                        this._output.writeLine();
                    }
                    this._output.write("            ");
                    this._output.writeKeyword("default");
                    this._output.write(": ");
                    this._output.writeLabel(String.valueOf(switchInfo.getDefaultTarget().getOffset()));
                    this._output.writeLine();
                    break;
                }
            }
            this._output.write("          }");
            this._output.writeLine();
        }

        @Override
        public void visitEnd() {
        }

        static {
            int maxLength = LINE_NUMBER_CODE.length();
            OpCode[] values = OpCode.values();
            String[] names = new String[values.length];
            for (int i = 0; i < values.length; ++i) {
                OpCode op = values[i];
                int length = op.name().length();
                if (length > maxLength) {
                    maxLength = length;
                }
                names[i] = op.name().toLowerCase();
            }
            MAX_OPCODE_LENGTH = maxLength;
            OPCODE_NAMES = names;
        }
    }
}

