/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addon.ui.impl.command;

import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jboss.forge.addon.ui.UIDesktop;
import org.jboss.forge.addon.ui.UIProvider;
import org.jboss.forge.addon.ui.command.CommandFactory;
import org.jboss.forge.addon.ui.command.CommandProvider;
import org.jboss.forge.addon.ui.command.UICommand;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.impl.context.DelegatingUIContext;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.output.UIOutput;
import org.jboss.forge.addon.ui.util.Commands;
import org.jboss.forge.addon.ui.wizard.UIWizardStep;
import org.jboss.forge.furnace.addons.AddonRegistry;
import org.jboss.forge.furnace.services.Imported;
import org.jboss.forge.furnace.util.Sets;
import org.jboss.forge.furnace.util.Strings;

@Singleton
public class CommandFactoryImpl
implements CommandFactory {
    @Inject
    private AddonRegistry registry;
    private Set<UICommand> cache = Sets.getConcurrentSet();
    private long version = -1L;
    private static final Logger log = Logger.getLogger(CommandFactoryImpl.class.getName());

    public Iterable<UICommand> getCommands() {
        return this.getCachedCommands();
    }

    public Set<String> getEnabledCommandNames(UIContext context) {
        TreeSet<String> commands = new TreeSet<String>();
        Iterable<UICommand> allCommands = this.getCommands();
        for (UICommand cmd : allCommands) {
            try {
                if (!Commands.isEnabled((UICommand)cmd, (UIContext)context)) continue;
                commands.add(this.getCommandName(context, cmd));
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Error while checking if command " + cmd + " isEnabled", e);
            }
        }
        return commands;
    }

    public String getCommandName(UIContext context, UICommand cmd) {
        String name = null;
        try {
            UICommandMetadata metadata = cmd.getMetadata(context);
            name = metadata.getName();
            if (!context.getProvider().isGUI()) {
                name = CommandFactoryImpl.shellifyName(name);
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Error while getting command name for " + cmd.getClass(), e);
        }
        return name;
    }

    public Set<String> getCommandNames(UIContext context) {
        TreeSet<String> commands = new TreeSet<String>();
        for (UICommand cmd : this.getCommands()) {
            String commandName = this.getCommandName(context, cmd);
            if (commandName == null) continue;
            commands.add(commandName);
        }
        return commands;
    }

    public UICommand getCommandByName(UIContext context, String name) {
        return this.findCommand(this.getCommands(), context, name);
    }

    public UICommand getNewCommandByName(UIContext context, String name) {
        return this.findCommand(this.getCommandsFromSource(), context, name);
    }

    private UICommand findCommand(Iterable<UICommand> commands, UIContext context, String name) {
        CommandNameUIProvider provider = new CommandNameUIProvider(context.getProvider());
        DelegatingUIContext delegatingContext = new DelegatingUIContext(context, provider);
        if (commands != null) {
            for (UICommand cmd : commands) {
                provider.setGUI(false);
                String commandName = this.getCommandName(delegatingContext, cmd);
                if (Strings.compare((String)name, (String)commandName) || Strings.compare((String)name, (String)CommandFactoryImpl.shellifyName(commandName))) {
                    return cmd;
                }
                provider.setGUI(true);
                commandName = this.getCommandName(delegatingContext, cmd);
                if (!Strings.compare((String)name, (String)commandName) && !Strings.compare((String)name, (String)CommandFactoryImpl.shellifyName(commandName))) continue;
                return cmd;
            }
        }
        return null;
    }

    private Iterable<UICommand> getCachedCommands() {
        if (this.registry.getVersion() != this.version) {
            this.version = this.registry.getVersion();
            this.cache.clear();
            this.getCommands(new Operation(){

                @Override
                public void execute(UICommand command) {
                    CommandFactoryImpl.this.cache.add(command);
                }
            });
        }
        return this.cache;
    }

    private Iterable<UICommand> getCommandsFromSource() {
        final Set result = Sets.getConcurrentSet();
        this.getCommands(new Operation(){

            @Override
            public void execute(UICommand command) {
                result.add(command);
            }
        });
        return result;
    }

    private void getCommands(Operation operation) {
        Imported instances = this.registry.getServices(CommandProvider.class);
        for (CommandProvider provider : instances) {
            Iterable commands = provider.getCommands();
            Iterator iterator = commands.iterator();
            while (iterator.hasNext()) {
                try {
                    UICommand command = (UICommand)iterator.next();
                    if (command instanceof UIWizardStep) continue;
                    operation.execute(command);
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "Error while retrieving command instance", e);
                }
            }
            instances.release((Object)provider);
        }
    }

    private static String shellifyName(String name) {
        return name != null ? name.trim().toLowerCase().replaceAll("\\W+", "-").replaceAll("\\:", "") : null;
    }

    private static class CommandNameUIProvider
    implements UIProvider {
        private final UIProvider delegate;
        private boolean gui;

        public CommandNameUIProvider(UIProvider delegate) {
            this.delegate = delegate;
        }

        public boolean isGUI() {
            return this.gui;
        }

        public void setGUI(boolean gui) {
            this.gui = gui;
        }

        public UIOutput getOutput() {
            return this.delegate.getOutput();
        }

        public UIDesktop getDesktop() {
            return this.delegate.getDesktop();
        }
    }

    static interface Operation {
        public void execute(UICommand var1);
    }
}

